/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.trust.client.v10draft;

import com.ibm.ws.wssecurity.trust.client.ITrustClient;
import com.ibm.ws.wssecurity.trust.client.ITrustConstants;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityToken;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenCollection;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenResponseCollection;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenTemplate;
import com.ibm.ws.wssecurity.trust.client.impl.TrustException;
import com.ibm.ws.wssecurity.trust.client.v10draft.Trust10RequestSecurityToken;
import com.ibm.ws.wssecurity.trust.client.v10draft.Trust10RequestSecurityTokenResponseCollection;
import com.ibm.ws.wssecurity.trust.client.v10draft.Trust10RequestSecurityTokenTemplate;
import com.ibm.ws.wssecurity.trust.client.v10draft.wsdl.Trust10SecurityTokenServiceStub;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axiom.om.util.DetachableInputStream;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trust10Client
implements ITrustClient {
    Options options = new Options();
    protected static final byte[] LOCK = new byte[0];
    private static String CLASSNAME;
    private static Logger log;
    private static Level level;
    Properties clientOptions = null;

    @Override
    public ITrustRequestSecurityTokenTemplate getSTSRequestSecurityTokenTemplate() {
        return new Trust10RequestSecurityTokenTemplate();
    }

    @Override
    public Stub init(Map map) throws TrustException {
        String method = "init()";
        if (map == null) {
            String errorMessage = "invalid_value_specified";
            log.logp(level, CLASSNAME, method, errorMessage);
            throw TrustException.format(errorMessage, "configuration map is null");
        }
        Map stsConfig = (Map)map.get("STSCONFIGURATION");
        if (stsConfig == null) {
            String errorMessage = "missing_required_settings";
            log.logp(level, CLASSNAME, method, errorMessage + ":  stsConfig required");
            throw TrustException.format(errorMessage, "configuration map");
        }
        Map properties = null;
        if (map.containsKey("AXIS2_MESSAGECONTEXT_PROPERTYMAP")) {
            properties = (Map)map.get("AXIS2_MESSAGECONTEXT_PROPERTYMAP");
        }
        ConfigurationContext cfgContext = null;
        if (map.containsKey("CONFIG_CONTEXT")) {
            cfgContext = (ConfigurationContext)map.get("CONFIG_CONTEXT");
        }
        return this.init(stsConfig, properties, cfgContext);
    }

    public Stub init(Map stsConfig, Map properties, ConfigurationContext cfgContext) throws TrustException {
        String method = "init()";
        if (stsConfig == null) {
            String errorMessage = "missing_required_settings";
            log.logp(level, CLASSNAME, method, errorMessage + ":  stsConfig required");
            throw TrustException.format(errorMessage, "configuration map");
        }
        String toHeader = (String)stsConfig.get("MESSAGE_TO");
        if (toHeader == null) {
            String errorMessage = "required_header_not_found";
            log.logp(level, CLASSNAME, method, errorMessage + ": To header required");
            throw TrustException.format(errorMessage, ITrustConstants.v10Draft.wsaNamespace.getNamespaceURI(), "To:");
        }
        String tolerateWSFPMessages = (String)stsConfig.get("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages");
        if (tolerateWSFPMessages != null) {
            this.clientOptions = new Properties();
            this.clientOptions.setProperty("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages", tolerateWSFPMessages);
        }
        this.options = Trust10Client.initOptions(toHeader, stsConfig, properties);
        Stub tokenServiceStub = Trust10Client.initStub(toHeader, stsConfig, cfgContext);
        return tokenServiceStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ITrustRequestSecurityTokenResponseCollection send(ITrustRequestSecurityToken rst) throws TrustException {
        method = "send()";
        if (rst == null) {
            errorMessage = "invalid_value_specified";
            Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, errorMessage + ": rst");
            throw TrustException.format(errorMessage, "rst is null");
        }
        rstrc = null;
        response = null;
        to = rst.getTo();
        Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "To: " + to);
        messageID = rst.getMessageID();
        Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "MessageID: " + messageID);
        action = rst.getAction();
        Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "Action: " + action);
        replyTo = null;
        Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "ReplyTo: " + replyTo);
        from = null;
        Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "From: " + from);
        otherHeaders = rst.getOtherHeaders();
        body = rst.getBody();
        Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "body: " + body);
        if (to == null) {
            errorMessage = "required_element_not_found";
            Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, errorMessage + ": To");
            throw TrustException.format(errorMessage);
        }
        if (action == null) {
            errorMessage = "required_element_not_found";
            Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, errorMessage + ": Action");
            throw TrustException.format(errorMessage);
        }
        if (body == null) {
            errorMessage = "required_element_not_found";
            Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, errorMessage + ": Body");
            throw TrustException.format(errorMessage);
        }
        serviceStub = rst.getSecurityTokenServiceStub();
        response = ((Trust10SecurityTokenServiceStub)serviceStub).RequestSecurityToken(body, to, replyTo, messageID, action, from, otherHeaders, this.options);
        var16_17 = null;
        msgContext = null;
        serviceClient = null;
        try {
            serviceClient = serviceStub._getServiceClient();
            if (serviceClient == null) {
                Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "unable get serviceClient from serviceStub.  Stream cannot be closed.");
            } else {
                lastOperationContext = serviceClient.getLastOperationContext();
                if (lastOperationContext == null) {
                    Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "unable get lastOperationContext from serviceClient.  Stream cannot be closed.");
                } else {
                    msgContext = lastOperationContext.getMessageContext("In");
                    if (msgContext == null) {
                        Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "unable get retrieve msgContext from lastOperationContext.  Stream cannot be closed.");
                    } else {
                        inputStream = (DetachableInputStream)msgContext.getProperty("org.apache.axiom.om.util.DetachableInputStream");
                        if (inputStream == null) {
                            Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "unable get retrieve InputStream from MessageContext.  Stream cannot be closed.");
                        } else {
                            response.build();
                            inputStream.close();
                        }
                    }
                }
            }
        }
        catch (AxisFault e) {
            Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "AxisFault caught while getting MessageContext.  Stream cannot be closed. " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "IOException caught while closing InputStream.  Stream cannot be closed. " + e.getLocalizedMessage());
        }
        catch (Throwable e) {
            Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "Throwable caught. Stream cannot be closed. " + e.getLocalizedMessage());
        }
        axisServiceName = null;
        try {
            axisConfiguration = serviceClient.getAxisConfiguration();
            if (axisConfiguration == null || (axisService = serviceClient.getAxisService()) == null || (axisServiceName = axisService.getName()) == null) ** break block41
            var22_29 = Trust10Client.LOCK;
            synchronized (Trust10Client.LOCK) {
                axisConfiguration.removeService(axisServiceName);
                // ** MonitorExit[var22_29] (shouldn't be in output)
                ** break block41
            }
        }
        catch (Throwable e) {
            Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "Throwable caught while removing AxisService[" + axisServiceName + "] from AxisConfiguration." + e.getLocalizedMessage());
        }
        ** GOTO lbl-1000
        {
            catch (RemoteException e) {
                errorMessage = "request_failed_with_exception";
                Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, errorMessage + ": " + e.getMessage());
                throw TrustException.format(errorMessage, e.getLocalizedMessage(), e);
            }
        }
        catch (Throwable var15_36) {
            var16_18 = null;
            msgContext = null;
            serviceClient = null;
            try {
                serviceClient = serviceStub._getServiceClient();
                if (serviceClient == null) {
                    Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "unable get serviceClient from serviceStub.  Stream cannot be closed.");
                } else {
                    lastOperationContext = serviceClient.getLastOperationContext();
                    if (lastOperationContext == null) {
                        Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "unable get lastOperationContext from serviceClient.  Stream cannot be closed.");
                    } else {
                        msgContext = lastOperationContext.getMessageContext("In");
                        if (msgContext == null) {
                            Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "unable get retrieve msgContext from lastOperationContext.  Stream cannot be closed.");
                        } else {
                            inputStream = (DetachableInputStream)msgContext.getProperty("org.apache.axiom.om.util.DetachableInputStream");
                            if (inputStream == null) {
                                Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "unable get retrieve InputStream from MessageContext.  Stream cannot be closed.");
                            } else {
                                response.build();
                                inputStream.close();
                            }
                        }
                    }
                }
            }
            catch (AxisFault e) {
                Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "AxisFault caught while getting MessageContext.  Stream cannot be closed. " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "IOException caught while closing InputStream.  Stream cannot be closed. " + e.getLocalizedMessage());
            }
            catch (Throwable e) {
                Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "Throwable caught. Stream cannot be closed. " + e.getLocalizedMessage());
            }
            axisServiceName = null;
            try {
                axisConfiguration = serviceClient.getAxisConfiguration();
                if (axisConfiguration == null || (axisService = serviceClient.getAxisService()) == null || (axisServiceName = axisService.getName()) == null) ** break block43
                var22_30 = Trust10Client.LOCK;
                synchronized (Trust10Client.LOCK) {
                    axisConfiguration.removeService(axisServiceName);
                    // ** MonitorExit[var22_30] (shouldn't be in output)
                }
            }
            catch (Throwable e) {
                Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, "Throwable caught while removing AxisService[" + axisServiceName + "] from AxisConfiguration." + e.getLocalizedMessage());
            }
            {
                throw var15_36;
            }
        }
lbl-1000:
        // 3 sources

        {
            if (response == null) {
                errorMessage = "invalid_response_from_service";
                Trust10Client.log.logp(Trust10Client.level, Trust10Client.CLASSNAME, method, errorMessage + ": serviceStub.RequestSecurityToken() returned null");
                throw TrustException.format(errorMessage, "response is null");
            }
            rstrc = new Trust10RequestSecurityTokenResponseCollection(response, this.clientOptions);
            return rstrc;
        }
    }

    @Override
    public ITrustRequestSecurityToken createRequestSecurityToken(ITrustRequestSecurityTokenTemplate rstt, Map map) throws TrustException {
        Trust10RequestSecurityToken rst = new Trust10RequestSecurityToken(rstt);
        Trust10SecurityTokenServiceStub stub = (Trust10SecurityTokenServiceStub)this.init(map);
        rst.setSecurityTokenServiceStub(stub);
        return rst;
    }

    @Override
    public ITrustRequestSecurityTokenResponseCollection issue(ITrustRequestSecurityToken rst) throws TrustException {
        rst.setContextURI("http://www.ibm.com/login/");
        return this.send(rst);
    }

    @Override
    public ITrustRequestSecurityTokenResponseCollection renew(ITrustRequestSecurityToken rst) throws TrustException {
        rst.setContextURI("http://www.ibm.com/login/");
        return this.send(rst);
    }

    @Override
    public ITrustRequestSecurityTokenResponseCollection cancel(ITrustRequestSecurityToken rst) throws TrustException {
        rst.setContextURI("http://www.ibm.com/login/");
        return this.send(rst);
    }

    @Override
    public ITrustRequestSecurityTokenResponseCollection validate(ITrustRequestSecurityToken rst) throws TrustException {
        rst.setContextURI("http://www.ibm.com/login/");
        return this.send(rst);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Options initOptions(String toHeader, Map stsConfig, Map properties) throws TrustException {
        String trustlevel;
        String method = "initOptions()";
        if (toHeader == null) {
            String errorMessage = "required_header_not_found";
            log.logp(level, CLASSNAME, method, errorMessage + ": To header required");
            throw TrustException.format(errorMessage, ITrustConstants.v10Draft.wsaNamespace.getNamespaceURI(), "To:");
        }
        if (stsConfig == null) {
            String errorMessage = "missing_required_settings";
            log.logp(level, CLASSNAME, method, errorMessage + ": stsConfig required");
            throw TrustException.format(errorMessage, "configuration map");
        }
        Options options = new Options();
        if (options == null) {
            String errorMessage = "unable_to_allocate_memory";
            log.logp(level, CLASSNAME, method, errorMessage + ": unable to allocate Options object");
            throw TrustException.format(errorMessage, "Options");
        }
        if (stsConfig.containsKey("SOAP_LEVEL")) {
            String soaplevel = (String)stsConfig.get("SOAP_LEVEL");
            if (soaplevel.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                options.setSoapVersionURI(soaplevel);
            } else {
                if (!soaplevel.equals("http://www.w3.org/2003/05/soap-envelope")) {
                    String errorMessage = "invalid_soap_level";
                    log.logp(level, CLASSNAME, method, errorMessage);
                    throw TrustException.format(errorMessage, soaplevel);
                }
                options.setSoapVersionURI(soaplevel);
            }
        } else {
            options.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        }
        if (stsConfig.containsKey("ADDRESSING_LEVEL")) {
            String addrlevel = (String)stsConfig.get("ADDRESSING_LEVEL");
            if (addrlevel.equals("http://schemas.xmlsoap.org/ws/2004/08/addressing")) {
                options.setProperty("WSAddressingVersion", addrlevel);
            } else {
                if (!addrlevel.equals("http://www.w3.org/2005/08/addressing")) {
                    String errorMessage = "invalid_namespace";
                    log.logp(level, CLASSNAME, method, errorMessage + ": Invalid WS-Addressing Level");
                    throw TrustException.format(errorMessage, addrlevel);
                }
                options.setProperty("WSAddressingVersion", addrlevel);
            }
        } else {
            options.setProperty("WSAddressingVersion", "http://www.w3.org/2005/08/addressing");
        }
        if (stsConfig.containsKey("TRUST_LEVEL") && !(trustlevel = (String)stsConfig.get("TRUST_LEVEL")).equals("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
            String errorMessage = "invalid_namespace";
            log.logp(level, CLASSNAME, method, errorMessage + ": Invalid Trust Namespace");
            throw TrustException.format(errorMessage, trustlevel);
        }
        EndpointReference toEndpointRef = new EndpointReference(toHeader);
        options.setTo(toEndpointRef);
        if (stsConfig.containsKey("MESSAGE_REPLYTO")) {
            EndpointReference replyTo = new EndpointReference((String)stsConfig.get("MESSAGE_REPLYTO"));
            options.setReplyTo(replyTo);
        }
        if (stsConfig.containsKey("MESSAGE_ID")) {
            options.setMessageId((String)stsConfig.get("MESSAGE_ID"));
        }
        if (stsConfig.containsKey("MESSAGE_ACTION")) {
            options.setAction((String)stsConfig.get("MESSAGE_ACTION"));
        }
        if (properties != null) {
            options.setProperties(properties);
        }
        options.setTransportInProtocol("http");
        options.setExceptionToBeThrownOnSOAPFault(true);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stub initStub(String toHeader, Map stsConfig, ConfigurationContext configContext) throws TrustException {
        String method = "initStub()";
        Trust10SecurityTokenServiceStub serviceStub = null;
        if (toHeader == null) {
            String errorMessage = "required_header_not_found";
            log.logp(level, CLASSNAME, method, errorMessage + ": To header required");
            throw TrustException.format(errorMessage, ITrustConstants.v10Draft.wsaNamespace.getNamespaceURI(), "To:");
        }
        try {
            Object axis2;
            if (configContext == null) {
                axis2 = null;
                if (stsConfig != null && stsConfig.containsKey("AXIS_HOME")) {
                    axis2 = (String)stsConfig.get("AXIS_HOME");
                }
                configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)axis2, null);
            }
            axis2 = LOCK;
            synchronized (LOCK) {
                serviceStub = new Trust10SecurityTokenServiceStub(configContext, toHeader);
                // ** MonitorExit[axis2 /* !! */ ] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            String errorMessage = "unable_to_instantiate_trust_client";
            log.logp(level, CLASSNAME, method, errorMessage + ": " + e.getMessage());
            throw TrustException.format(errorMessage, e);
        }
        {
            return serviceStub;
        }
    }

    @Override
    public ITrustRequestSecurityTokenCollection createRequestSecurityTokenCollection(ITrustRequestSecurityToken rst) throws TrustException {
        throw TrustException.format("not_supported");
    }

    @Override
    public ITrustRequestSecurityTokenCollection createRequestSecurityTokenCollection(List<ITrustRequestSecurityToken> rstList) throws TrustException {
        throw TrustException.format("not_supported");
    }

    static {
        level = Level.FINE;
        CLASSNAME = Trust10Client.class.getName();
        log = Logger.getLogger(CLASSNAME);
    }
}

