/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.token;

import com.ibm.websphere.wssecurity.wssapi.token.DerivedKeyToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.CallerConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.SubjectCache;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.token.AuthResult;
import com.ibm.ws.wssecurity.token.CacheableSubjectHelper;
import com.ibm.ws.wssecurity.token.CacheableSubjectHelperFactory;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.CommonCallbackHandler;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;

public class LoginProcessor
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(LoginProcessor.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LoginProcessor.class.getName();
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMNode target, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invoke(");
            buf.append("OMNode target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        WSSConsumerConfig gconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        SecurityToken token = LoginProcessor.invokeLoginModule(gconfig.getCallers(), context);
        SecurityTokenManagerImpl securityTokenManager = (SecurityTokenManagerImpl)context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        securityTokenManager.integrateSubject();
        this.cacheInformation(token, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Element, Map)");
        }
    }

    private static SecurityToken invokeLoginModule(Collection<CallerConfig> cconfigsCandidates, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invokeLoginModule(");
            buf.append("Set cconfigs[").append(cconfigsCandidates).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        SecurityToken token = null;
        CallerConfig selectedCaller = LoginProcessor.selectCallers(cconfigsCandidates, context);
        if (selectedCaller != null) {
            try {
                LoginProcessor.invokeLoginModule(selectedCaller, context);
            }
            catch (Exception e) {
                if (e instanceof SoapSecurityException) {
                    if (((SoapSecurityException)e).getFaultCode() == null) {
                        QName fault = Axis2Util.setFailedAuthFaultCodeIfNone(context);
                    }
                    throw (SoapSecurityException)e;
                }
                QName fault = Axis2Util.setFailedAuthFaultCodeIfNone(context);
                throw SoapSecurityException.format(fault, "security.wssecurity.WSEC6837E", (Throwable)e);
            }
            token = (SecurityToken)context.get(Constants.WSSECURITY_TOKEN_LOGININFO);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invokeLoginModule(Set, Map)");
            buf.append(" returns SecurityToken [").append(token).append("]");
            Tr.entry(tc, buf.toString());
        }
        return token;
    }

    private static CallerConfig selectCallers(Collection<CallerConfig> cconfigs, Map<Object, Object> context) throws SoapSecurityException {
        WSSConsumerConfig config2 = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        boolean callerOrderEnforced = config2.isCallerOrderEnforced();
        CallerConfig selectedCaller = null;
        if (cconfigs.size() > 0) {
            LoginProcessor.checkImpliedCaller(context);
            Result[] results = ResultPool.get(context, AuthResult.class);
            int resultsLength = results.length;
            if (resultsLength == 0) {
                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s01");
            }
            if (callerOrderEnforced) {
                for (CallerConfig aConfig : cconfigs) {
                    boolean foundMatch = LoginProcessor.isCallerMatch(aConfig, results);
                    if (!foundMatch) continue;
                    selectedCaller = aConfig;
                    break;
                }
            } else {
                for (CallerConfig aConfig : cconfigs) {
                    boolean foundMatch = LoginProcessor.isCallerMatch(aConfig, results);
                    if (foundMatch && selectedCaller == null) {
                        selectedCaller = aConfig;
                        continue;
                    }
                    if (!foundMatch || selectedCaller == null) continue;
                    throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s06");
                }
            }
            if (selectedCaller == null) {
                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s07");
            }
        }
        return selectedCaller;
    }

    private static void checkImpliedCaller(Map<Object, Object> context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkImpliedCaller");
        }
        Result[] results = ResultPool.get(context, AuthResult.class);
        int resultsLength = results.length;
        boolean isSupportingToken = false;
        SecurityTokenManagerImpl securityTokenManager = (SecurityTokenManagerImpl)context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        WSSConsumerConfig config2 = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        List<CallerConfig> cconfigs = config2.getCallers();
        Set<TokenConsumerConfig> tconfigs = config2.getTokenConsumers();
        for (TokenConsumerConfig tconfig : tconfigs) {
            Collection<SecurityToken> tokens;
            if (!tconfig.isUsedForDecryption() && !tconfig.isUsedForVerification()) continue;
            results = ResultPool.get(context, AuthResult.class);
            resultsLength = results.length;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TokenConsumerConfig hash =" + tconfig.hashCode());
            }
            boolean escape = false;
            if (resultsLength > 0) {
                for (int k = 0; k < resultsLength; ++k) {
                    AuthResult result = (AuthResult)results[k];
                    if (result.getTokenWrapper() != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "result.getTokenWrapper().getUsedTokenConsumerHash() =" + result.getTokenWrapper().getUsedTokenConsumerHash());
                        }
                        if (tconfig.hashCode() != result.getTokenWrapper().getUsedTokenConsumerHash()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "This token config has been added as candidate already: " + result.getTokenWrapper().getSecurityToken().getId());
                        }
                        escape = true;
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No TokenWrapper");
                }
            }
            if (escape || (tokens = securityTokenManager.getTokens(tconfig)).size() <= 0) continue;
            QName config_qn = tconfig.getType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, tokens.size() + " tokens found.");
                Tr.debug(tc, cconfigs.size() + " CallerConfigs found, so start to process it...");
                Tr.debug(tc, "The value type of the token consumer configuration: " + config_qn);
            }
            for (CallerConfig cconfig : cconfigs) {
                boolean requiredTrustedIdentityChecking;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing a CallerConfig [" + cconfig + "]...");
                }
                QName caller_qn = cconfig.getCallerIdentity();
                QName tidentity_qn = cconfig.getTrustedIdentity();
                ReferencePartConfig spart = cconfig.getRequiredSigningPartReference();
                boolean requiredCallerIdentityChecking = caller_qn != null && caller_qn.equals(config_qn) && (spart == null || tidentity_qn != null);
                boolean bl = requiredTrustedIdentityChecking = tidentity_qn != null && tidentity_qn.equals(config_qn) && spart == null;
                if (!requiredCallerIdentityChecking && !requiredTrustedIdentityChecking) continue;
                Iterator<SecurityToken> j = tokens.iterator();
                while (j.hasNext()) {
                    boolean callerIdentityCandidate = false;
                    boolean trustedIdentityCandidate = false;
                    SecurityToken token = j.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Check Token: " + token.getId());
                    }
                    QName token_qn = token.getValueType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The value type of the token: " + token_qn);
                    }
                    if (NamespaceUtil.equals(DerivedKeyToken.ValueType, token_qn)) {
                        SecurityToken baseToken;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "This is DerivedKeyToken: " + token_qn);
                        }
                        if ((baseToken = ((DKToken)token).getDerivableSecurityToken()) != null) {
                            SecurityTokenWrapper basetokenWrapper;
                            QName base_token_qn = baseToken.getValueType();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The value type of the base token: " + base_token_qn);
                            }
                            if ((basetokenWrapper = securityTokenManager.getTokenWrapper(baseToken)) == null) {
                                final SecurityTokenWrapper tw = new SecurityTokenWrapper(baseToken);
                                final int tconfigHash = tconfig.hashCode();
                                final int tconfigClassNameHash = tconfig.getClass().getName().hashCode();
                                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                    @Override
                                    public Object run() {
                                        tw.setUsedTokenConsumer(tconfigHash, tconfigClassNameHash);
                                        tw.setProcessed(true);
                                        return null;
                                    }
                                });
                                securityTokenManager.addTokenWrapper(tw);
                                basetokenWrapper = tw;
                            }
                            results = ResultPool.get(context, AuthResult.class);
                            resultsLength = results.length;
                            boolean inserted = false;
                            if (resultsLength > 0) {
                                for (int k = 0; k < resultsLength; ++k) {
                                    AuthResult result = (AuthResult)results[k];
                                    if (result.getTokenWrapper() != null) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "result.getTokenWrapper().getUsedTokenConsumerHash() =" + result.getTokenWrapper().getUsedTokenConsumerHash());
                                        }
                                        if (basetokenWrapper.getUsedTokenConsumerHash() != result.getTokenWrapper().getUsedTokenConsumerHash()) continue;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "This token has been added as candidate already: " + result.getTokenWrapper().getSecurityToken().getId());
                                        }
                                        inserted = true;
                                        continue;
                                    }
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "No TokenWrapper");
                                }
                            }
                            if (!inserted) {
                                token = baseToken;
                                token_qn = baseToken.getValueType();
                            }
                        }
                    }
                    if (requiredCallerIdentityChecking) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking the caller identity [" + caller_qn + "]...");
                        }
                        if (caller_qn.equals(token_qn)) {
                            callerIdentityCandidate = true;
                        }
                    }
                    if (requiredTrustedIdentityChecking) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking the trusted identity [" + tidentity_qn + "]...");
                        }
                        if (tidentity_qn.equals(token_qn)) {
                            trustedIdentityCandidate = true;
                        }
                    }
                    if (!callerIdentityCandidate && !trustedIdentityCandidate) continue;
                    SecurityTokenWrapper tokenWrapper = securityTokenManager.getTokenWrapper(token);
                    if (tokenWrapper == null) {
                        final SecurityTokenWrapper tw = new SecurityTokenWrapper(token);
                        final int tconfigHash = tconfig.hashCode();
                        final int tconfigClassNameHash = tconfig.getClass().getName().hashCode();
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                tw.setUsedTokenConsumer(tconfigHash, tconfigClassNameHash);
                                tw.setProcessed(true);
                                return null;
                            }
                        });
                        securityTokenManager.addTokenWrapper(tw);
                        tokenWrapper = tw;
                    }
                    AuthResult aresult = new AuthResult(tokenWrapper, cconfig, callerIdentityCandidate, trustedIdentityCandidate, isSupportingToken);
                    ResultPool.add(context, aresult);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added AuthResult[" + aresult + "] into the ResultPool.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkImpliedCaller");
        }
    }

    private static boolean isCallerMatch(CallerConfig aConfig, Result[] results) throws SoapSecurityException {
        boolean isCallerMatch = false;
        boolean isTrustedIdConfig = false;
        boolean trustedIdAndCallerIdSameType = false;
        int resultsLength = results.length;
        ArrayList<AuthResult> trustedIdProtectionTokenCandidates = new ArrayList<AuthResult>();
        ArrayList<AuthResult> callerIdProtectionTokenCandidates = new ArrayList<AuthResult>();
        ArrayList<AuthResult> trustedIdSupportingTokenCandidates = new ArrayList<AuthResult>();
        ArrayList<AuthResult> callerIdSupportingTokenCandidates = new ArrayList<AuthResult>();
        if (aConfig.getTrustedIdentity() != null) {
            isTrustedIdConfig = true;
            if (aConfig.getCallerIdentity().equals(aConfig.getTrustedIdentity())) {
                trustedIdAndCallerIdSameType = true;
            }
        }
        for (int i = 0; i < resultsLength; ++i) {
            AuthResult result = (AuthResult)results[i];
            if (result.getConfig() != aConfig) continue;
            if (result._callerIdentityCandidate) {
                if (result.isSupportingToken()) {
                    callerIdSupportingTokenCandidates.add(result);
                } else {
                    callerIdProtectionTokenCandidates.add(result);
                }
            }
            if (!result._trustedIdentityCandidate) continue;
            if (result.isSupportingToken()) {
                trustedIdSupportingTokenCandidates.add(result);
                continue;
            }
            trustedIdProtectionTokenCandidates.add(result);
        }
        if (isTrustedIdConfig) {
            boolean callerIdFound = false;
            boolean trustedIdFound = false;
            if (trustedIdAndCallerIdSameType) {
                if (!callerIdSupportingTokenCandidates.isEmpty()) {
                    if (callerIdSupportingTokenCandidates.size() == 2) {
                        ((AuthResult)callerIdSupportingTokenCandidates.get(0)).setIsCallerToken();
                        ((AuthResult)callerIdSupportingTokenCandidates.get(1)).setIsCallerToken();
                        trustedIdFound = true;
                        callerIdFound = true;
                    } else if (callerIdSupportingTokenCandidates.size() == 1 && callerIdProtectionTokenCandidates.size() == 1) {
                        ((AuthResult)callerIdSupportingTokenCandidates.get(0)).setIsCallerToken();
                        ((AuthResult)callerIdProtectionTokenCandidates.get(0)).setIsCallerToken();
                    } else if (callerIdSupportingTokenCandidates.size() > 2) {
                        throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s12", aConfig.getCallerIdentity().toString(), Integer.toString(callerIdSupportingTokenCandidates.size()));
                    }
                } else if (!callerIdProtectionTokenCandidates.isEmpty()) {
                    if (callerIdProtectionTokenCandidates.size() == 2) {
                        ((AuthResult)callerIdProtectionTokenCandidates.get(0)).setIsCallerToken();
                        ((AuthResult)callerIdProtectionTokenCandidates.get(1)).setIsCallerToken();
                        trustedIdFound = true;
                        callerIdFound = true;
                    } else if (callerIdProtectionTokenCandidates.size() > 2) {
                        throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s13", aConfig.getCallerIdentity().toString(), Integer.toString(callerIdProtectionTokenCandidates.size()));
                    }
                }
            } else {
                if (!callerIdSupportingTokenCandidates.isEmpty()) {
                    if (callerIdSupportingTokenCandidates.size() != 1) {
                        throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s12", aConfig.getCallerIdentity().toString(), Integer.toString(callerIdSupportingTokenCandidates.size()));
                    }
                    ((AuthResult)callerIdSupportingTokenCandidates.get(0)).setIsCallerToken();
                    callerIdFound = true;
                } else if (!callerIdProtectionTokenCandidates.isEmpty()) {
                    if (callerIdProtectionTokenCandidates.size() != 1) {
                        throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s13", aConfig.getCallerIdentity().toString(), Integer.toString(callerIdProtectionTokenCandidates.size()));
                    }
                    ((AuthResult)callerIdProtectionTokenCandidates.get(0)).setIsCallerToken();
                    callerIdFound = true;
                }
                if (!trustedIdSupportingTokenCandidates.isEmpty()) {
                    if (trustedIdSupportingTokenCandidates.size() != 1) {
                        throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s12", aConfig.getTrustedIdentity().toString(), Integer.toString(trustedIdSupportingTokenCandidates.size()));
                    }
                    ((AuthResult)trustedIdSupportingTokenCandidates.get(0)).setIsCallerToken();
                    trustedIdFound = true;
                } else if (!trustedIdProtectionTokenCandidates.isEmpty()) {
                    if (trustedIdProtectionTokenCandidates.size() != 1) {
                        throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s13", aConfig.getTrustedIdentity().toString(), Integer.toString(trustedIdProtectionTokenCandidates.size()));
                    }
                    ((AuthResult)trustedIdProtectionTokenCandidates.get(0)).setIsCallerToken();
                    trustedIdFound = true;
                }
            }
            if (trustedIdFound && callerIdFound) {
                isCallerMatch = true;
            }
        } else if (!callerIdSupportingTokenCandidates.isEmpty()) {
            if (callerIdSupportingTokenCandidates.size() != 1) {
                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s12", aConfig.getCallerIdentity().toString(), Integer.toString(callerIdSupportingTokenCandidates.size()));
            }
            ((AuthResult)callerIdSupportingTokenCandidates.get(0)).setIsCallerToken();
            isCallerMatch = true;
        } else if (!callerIdProtectionTokenCandidates.isEmpty()) {
            if (callerIdProtectionTokenCandidates.size() != 1) {
                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s13", aConfig.getCallerIdentity().toString(), Integer.toString(callerIdProtectionTokenCandidates.size()));
            }
            ((AuthResult)callerIdProtectionTokenCandidates.get(0)).setIsCallerToken();
            isCallerMatch = true;
        }
        return isCallerMatch;
    }

    private static void invokeLoginModule(CallerConfig config2, Map<Object, Object> context) throws SoapSecurityException {
        Subject sbj;
        Object obj;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invokeLoginModule(");
            buf.append("CallerConfig config[").append(config2).append("], ");
            buf.append("Map context)");
            Tr.entry(tc, buf.toString());
        }
        if ((obj = context.get("com.ibm.wsspi.wssecurity.core.subject")) == null || !(obj instanceof Subject)) {
            sbj = new Subject();
            context.put("com.ibm.wsspi.wssecurity.core.subject", sbj);
        } else {
            sbj = (Subject)obj;
        }
        SecurityTokenManagerImpl securityTokenManager = (SecurityTokenManagerImpl)context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        WSSContextManager manager = WSSContextManagerFactory.getInstance();
        if (manager == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "WSSContextManager object missing");
        }
        SubjectCache authCache = manager.getSubjectCache();
        Subject loginSubj = null;
        CacheableSubjectHelper subjectHelper = CacheableSubjectHelperFactory.getInstance();
        String identifier = subjectHelper.getIdentifier(sbj);
        if (identifier != null && !identifier.isEmpty() && (loginSubj = authCache.getSubjectFromAuthCacheByUniqueID(identifier)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found subject in AuthnCache with identifier and expiration time = " + identifier);
            }
            WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
            WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
            boolean isAuthnAuditRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS, context);
            if (isAuthnAuditRequired && !config2.useIdentityAssertion()) {
                String auditCallerName = ((Principal)loginSubj.getPrincipals().toArray()[0]).getName();
                MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                Map<String, Object> auditContext = wssAuditEventGenerator.setExtendedAuditData(context, "CachedUsername", auditCallerName);
                wssAuditEventGenerator.addProviderData(auditContext, config2.getJAASConfig(), "SUCCESS");
                wssAuditEventGenerator.addAuthnTypeData(auditContext, config2.getCallerIdentity().toString());
                wssAuditEventGenerator.setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
                wssAuditEventGenerator.sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
            }
            securityTokenManager.addToSubject(loginSubj);
            return;
        }
        final String jaasLoginConfigName = config2.getJAASConfig();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Subject not in CacheableTokenLocalCache, identifier = " + identifier);
            Tr.debug(tc, "JAAS config name is " + jaasLoginConfigName + ".");
        }
        if (jaasLoginConfigName == null) {
            throw SoapSecurityException.format("security.wssecurity.WSEC6834E", config2.toString());
        }
        context.put("com.ibm.wsspi.wssecurity.core.config.callerConfig.configKey", config2);
        context.putAll(config2.getJAASConfigProperties());
        CallbackHandlerConfig cbhconf = config2.getCallbackHandler();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandlerConfig [" + cbhconf + "].");
        }
        CallbackHandler myHandler = null;
        if (cbhconf != null) {
            myHandler = cbhconf.getInstance();
            if (myHandler == null) {
                block32: {
                    String cbhname = cbhconf.getClassName();
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Instantiating the callback handler [" + cbhname + "]...");
                        }
                        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        Class<?> cls = null;
                        if (loader != null) {
                            try {
                                cls = loader.loadClass(cbhname);
                            }
                            catch (Exception e) {
                                cls = Class.forName(cbhname);
                            }
                        } else {
                            cls = Class.forName(cbhname);
                        }
                        if (CallbackHandler.class.isAssignableFrom(cls)) {
                            HashMap<String, CallbackHandlerConfig> properties = new HashMap<String, CallbackHandlerConfig>();
                            properties.put("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey", cbhconf);
                            Constructor<?> con = cls.getConstructor(Map.class);
                            myHandler = (CallbackHandler)con.newInstance(properties);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Succeeded to Instantiate the callback handler [" + cbhname + "].");
                            }
                            break block32;
                        }
                        throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", cbhname, CallbackHandler.class.getName());
                    }
                    catch (SoapSecurityException e) {
                        Tr.processException(e, clsName + ".invoke", "797");
                        throw e;
                    }
                    catch (Exception e) {
                        Tr.processException(e, clsName + ".invoke", "800");
                        Tr.error(tc, "security.wssecurity.X509TokenGenerator.s01", new Object[]{cbhname});
                        throw SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s01", cbhname, (Throwable)e);
                    }
                }
                cbhconf.setInstance(myHandler);
            }
            context.putAll(cbhconf.getProperties());
        }
        final CommonCallbackHandler commonCBH = new CommonCallbackHandler(myHandler, context);
        final Subject subject = sbj;
        LoginContext lcontext = null;
        try {
            lcontext = (LoginContext)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws LoginException {
                    LoginContext lc = new LoginContext(jaasLoginConfigName, subject, commonCBH);
                    return lc;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Succeed to construct the login context.");
            }
            lcontext.login();
            loginSubj = lcontext.getSubject();
            Subject validatedSubject = null;
            try {
                validatedSubject = authCache.validateSubject(loginSubj);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no valid WebSphere security subject returned from Caller login.");
                }
                Tr.processException(e, clsName + ".invokeLoginModule", "844");
                Tr.error(tc, "security.wssecurity.LoginProcessor.s09", new Object[]{e});
                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s09");
            }
            if (validatedSubject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no valid WebSphere security subject returned from Caller login.");
                }
                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s09");
            }
            securityTokenManager.addToSubject(loginSubj);
            authCache.addSubjectToAuthCache(loginSubj, identifier);
        }
        catch (PrivilegedActionException pae) {
            LoginException le = (LoginException)pae.getCause();
            Tr.processException(le, clsName + ".invokeLoginModule", "873");
            Tr.error(tc, "security.wssecurity.X509TokenConsumer.s01", new Object[]{le});
            throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.FAILED_AUTHENTICATION, "security.wssecurity.X509TokenConsumer.s01", (Throwable)le);
        }
        catch (LoginException le) {
            Tr.processException(le, clsName + ".invokeLoginModule", "879");
            Tr.error(tc, "security.wssecurity.X509TokenConsumer.s02", new Object[]{le});
            throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.FAILED_AUTHENTICATION, "security.wssecurity.X509TokenConsumer.s02", (Throwable)le);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invokeLoginModule(");
            buf.append("CallerConfig, Map)");
            Tr.entry(tc, buf.toString());
        }
    }

    private void cacheInformation(SecurityToken token, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheInformation(Token token[" + token + "]," + "Map context)");
        }
        Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        WSSContextManager ctxMgr = WSSContextManagerFactory.getInstance();
        if (ctxMgr == null) {
            Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
        } else {
            ctxMgr.put("com.ibm.wsspi.wssecurity.username.initialSenderId", subject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initial Sender is set.");
            }
            X509Certificate cert = null;
            if (token != null && token instanceof X509Token) {
                cert = ((X509Token)token).getCertificate();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initial Cert is set.");
                }
            } else {
                Result[] results = ResultPool.get(context, AuthResult.class);
                HashSet<SecurityToken> callerIdentityCandidates = new HashSet<SecurityToken>();
                int resultsLength = results.length;
                for (int i = 0; i < resultsLength; ++i) {
                    AuthResult result = (AuthResult)results[i];
                    if (!result.isCallerIdentityCandidate()) continue;
                    SecurityTokenWrapper tokenWrapper = result.getTokenWrapper();
                    SecurityToken tok = tokenWrapper.getSecurityToken();
                    callerIdentityCandidates.add(tok);
                }
                final HashSet<SecurityToken> callerCandidates = callerIdentityCandidates;
                final Subject subj = subject;
                cert = (X509Certificate)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Set<SecurityToken> tokens = subj.getPrivateCredentials(SecurityToken.class);
                        for (SecurityToken obj : tokens) {
                            if (obj == null || !(obj instanceof X509Token) || !callerCandidates.contains(obj)) continue;
                            X509Token x509 = (X509Token)obj;
                            return x509.getCertificate();
                        }
                        return null;
                    }
                });
            }
            ctxMgr.put("com.ibm.wsspi.wssecurity.username.initialSenderCert", cert);
            if (cert != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Initial Cert is set:" + cert.getSubjectDN().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheInformation(Token token,Map context)");
        }
    }
}

