/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.token;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.config.KRBConfig;
import com.ibm.ws.wssecurity.config.KRBConfigException;
import com.ibm.ws.wssecurity.token.KRBCredentialsFactory;
import com.ibm.ws.wssecurity.util.KRB5Util;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KRBCredential {
    private static final String JGSS_PROP = "javax.security.auth.useSubjectCredsOnly";
    private static final Oid KRB5MECHANISMOID;
    private static final Oid SPNEGOMECHOID;
    private GSSManager gssManager;
    private GSSName gssName;
    private GSSCredential gssCred;
    private static TraceComponent tc;

    public KRBCredential(KRBConfig server) throws GSSException, KRBConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBCredential");
        }
        this.initialize(server);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBCredential");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(KRBConfig server) throws GSSException, KRBConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeServerCredential");
        }
        if (server == null) {
            Tr.error(tc, "kerberos.config.unexpected.condition", new Object[]{"KRBConfig==null"});
            throw new KRBConfigException(KRB5Util.getFormattedMessage(KRB5Util.getNLS(), "kerberos.config.unexpected.condition", new Object[]{"KRBConfig==null"}));
        }
        try {
            Object tmpObject;
            String spn = server.getServiceName();
            if (tc.isAuditEnabled()) {
                Tr.audit(tc, "kerberos.init.start", spn);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initializeServerCredential: creating GSSManager");
            }
            this.gssManager = KRBCredentialsFactory.getMgr();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initializeServerCredential: creating GSSName for " + spn);
            }
            if (server.getGssNameType() == GSSName.NT_USER_NAME) {
                this.gssName = this.gssManager.createName(spn, GSSName.NT_USER_NAME, KRB5MECHANISMOID);
            } else {
                if (tc.isAuditEnabled()) {
                    Tr.audit(tc, "kerberos.warn.hostbased");
                }
                this.gssName = this.gssManager.createName(spn, GSSName.NT_HOSTBASED_SERVICE);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initializeServerCredential: creating " + (this.gssName == null ? "default" : ((Object)this.gssName).toString()) + " credential");
            }
            int credType = server.getGssCredType();
            int credLifeTime = server.getGssCredDuration();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initializeServerCredential: adding credentials");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initializeServerCredential: gssName : " + this.gssName);
                Tr.debug(tc, "initializeServerCredential: credLifeTime : " + credLifeTime);
                Tr.debug(tc, "initializeServerCredential: KRB5MECHANISMOID : " + KRB5MECHANISMOID);
                Tr.debug(tc, "initializeServerCredential: credType : " + credType);
            }
            Object object = tmpObject = new Object();
            synchronized (object) {
                String useSubjectCredsOnly = System.getProperty(JGSS_PROP);
                Tr.debug(tc, "javax.security.auth.useSubjectCredsOnly: " + useSubjectCredsOnly);
                if (useSubjectCredsOnly == null || Boolean.valueOf(useSubjectCredsOnly).booleanValue()) {
                    System.setProperty(JGSS_PROP, "false");
                }
                this.gssCred = this.gssManager.createCredential(this.gssName, credLifeTime, KRB5MECHANISMOID, credType);
                if (useSubjectCredsOnly == null) {
                    System.clearProperty(JGSS_PROP);
                } else {
                    System.setProperty(JGSS_PROP, useSubjectCredsOnly);
                }
            }
            Tr.debug(tc, "javax.security.auth.useSubjectCredsOnly: " + System.getProperty(JGSS_PROP));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initializeServerCredential: credential added ");
            }
            int lifetime = this.gssCred.getRemainingLifetime();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initializeServerCredential: lifetime remaining on cred: " + lifetime + " secs");
            }
            Oid[] mechs = this.gssCred.getMechs();
            lifetime = this.gssCred.getRemainingAcceptLifetime(mechs[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initializeServerCredential: Accept lifetime remaining on cred for mech " + mechs[0] + ": " + lifetime + " secs");
                Tr.debug(tc, "initializeServerCredential: " + this.gssCred);
            }
            if (tc.isAuditEnabled()) {
                Tr.audit(tc, "kerberos.init.ok", spn);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeServerCredential");
            }
        }
        catch (GSSException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Received excpeption --> " + e.getMessage());
            }
            FFDCFilter.processException(e, KRBCredential.class.getName(), "1");
            Tr.error(tc, "kerberos.init.failed", new Object[]{e});
            throw e;
        }
        catch (Throwable e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Received excpeption --> " + e.getMessage());
            }
            FFDCFilter.processException(e, KRBCredential.class.getName(), "2");
            Tr.error(tc, "kerberos.unexpected.exception", new Object[]{e});
            throw new IllegalStateException("ServerCredentials.initialize - unexpected exception: " + e);
        }
    }

    public final GSSCredential getGssCred() {
        return this.gssCred;
    }

    static {
        Oid temp = null;
        try {
            temp = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException ex) {
            temp = null;
        }
        KRB5MECHANISMOID = temp;
        try {
            temp = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException ex) {
            temp = null;
        }
        SPNEGOMECHOID = temp;
    }
}

