/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.token;

import com.ibm.ws.wssecurity.token.CacheableSubjectHelper;
import com.ibm.ws.wssecurity.token.CacheableSubjectHelperFactory;
import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.ObjectOutputInputUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.security.auth.Subject;

public class CacheableSubject
implements CacheableToken {
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;
    private static final String VERSION_NUMBER = "1.0";
    private static final TraceComponent tc = Tr.register(CacheableSubject.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private short version = 1;
    private Subject subject = null;
    private long expiration = 0L;
    private transient String identifier = null;

    public CacheableSubject(Subject sub) {
        this.subject = sub;
        CacheableSubjectHelper subjectHelper = CacheableSubjectHelperFactory.getInstance();
        this.expiration = subjectHelper.getExpiration(this.subject);
    }

    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public String getIdentifier() {
        if (this.identifier == null) {
            CacheableSubjectHelper subjectHelper = CacheableSubjectHelperFactory.getInstance();
            this.identifier = subjectHelper.getIdentifier(this.subject);
        }
        return this.identifier;
    }

    public long getExpiration() {
        return this.expiration - System.currentTimeMillis();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String version;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readExternal(ObjectInput in)");
        }
        if (VERSION_NUMBER.equals(version = ObjectOutputInputUtil.readUTF(in, "CacheableSubject.version"))) {
            this.subject = (Subject)ObjectOutputInputUtil.readObject(in, "CacheableSubject.subject");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readExternal(ObjectInput in)=" + in.available());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeExternal(ObjectOutput out)");
        }
        ObjectOutputInputUtil.writeUTF(out, VERSION_NUMBER, "CacheableSubject.version");
        ObjectOutputInputUtil.writeObject(out, this.subject, "CacheableSubject.tokenName");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeExternal(ObjectOutput out)");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nversion:            " + this.version);
        sb.append("\nSubject:            " + this.subject.toString());
        return sb.toString();
    }
}

