/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.time;

import com.ibm.ws.wssecurity.common.Request;
import com.ibm.ws.wssecurity.common.RequestPool;
import com.ibm.ws.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.core.RequestMessagePool;
import com.ibm.ws.wssecurity.core.WSSGeneratorComponent;
import com.ibm.ws.wssecurity.time.TimestampRequest;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.wssecurity.util.XPathElementSelector;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class TimestampGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(TimestampGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMDocument doc, OMElement parent, Map<Object, Object> context) throws SoapSecurityException {
        OMNode firstChild;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "Map context)");
        }
        OMFactory factory = doc.getOMDocumentElement().getOMFactory();
        Object obj = context.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int soapVersion = 0;
        if (obj != null && obj instanceof Integer) {
            soapVersion = (Integer)obj;
        }
        String nsSoap = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[2][soapVersion];
        obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        if (parent == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s13", "wsu:Timestamp");
        }
        OMElement timestamp = NonceUtil.getTimestamp(parent, nsWsu);
        if (timestamp != null) {
            throw SoapSecurityException.format("security.wssecurity.TimestampGenerator.s01");
        }
        timestamp = NonceUtil.createTimestamp(factory, parent, nsWsu, null);
        TimestampGeneratorConfig config2 = (TimestampGeneratorConfig)context.remove("com.ibm.ws.wssecurity.impl.config.timestampGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TimestampGeneratorConfig [" + config2 + "].");
        }
        if (config2.getSOAPHeaderAttribute()) {
            TimestampGenerator.setAttributeForSOAPHeader(timestamp, soapVersion, nsSoap, config2.getTargetActor(), context);
        }
        if ((firstChild = parent.getFirstOMChild()) == null) {
            parent.addChild(timestamp);
        } else if (firstChild != timestamp) {
            firstChild.insertSiblingBefore(timestamp);
        }
        NonceUtil.addCreated(factory, timestamp, nsWsu);
        if (config2.getDuration() != null) {
            NonceUtil.addExpires(factory, timestamp, config2.getDuration(), nsWsu);
        }
        boolean isSigned = config2.toBeSigned();
        TimestampRequest trequest = new TimestampRequest(isSigned);
        trequest.setElement(timestamp);
        RequestPool.add(context, trequest);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMDocument, OMElement, Map)");
        }
    }

    private static void setAttributeForSOAPHeader(OMElement timestamp, int soapVersion, String nsSoap, String actor, Map<Object, Object> context) {
        boolean mustUnderstand;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributeForSOAPHeader(OMElement timestamp[" + DOMUtils.getDisplayName(timestamp) + "]," + "int soapVersion[" + soapVersion + "]," + "String nsSoap[" + nsSoap + "]," + "String actor[" + actor + "]," + "Map context)");
        }
        String prefix = DOMUtils.getNamespacePrefix(timestamp, nsSoap);
        if (actor != null) {
            String attName;
            String string = attName = soapVersion == 0 ? "actor" : "role";
            if (prefix == null || prefix.length() <= 0) {
                prefix = "env";
                timestamp.declareNamespace(nsSoap, prefix);
            }
            timestamp.addAttribute(attName, actor, timestamp.getOMFactory().createOMNamespace(nsSoap, prefix));
        }
        if (mustUnderstand = Axis2Util.getMustUnderstand(context)) {
            if (prefix == null || prefix.length() <= 0) {
                prefix = "env";
                timestamp.declareNamespace(nsSoap, prefix);
            }
            timestamp.addAttribute("mustUnderstand", "1", timestamp.getOMFactory().createOMNamespace(nsSoap, prefix));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributeForSOAPHeader(OMElement, int, String, String)");
        }
    }

    public static void moveTimestamp(OMDocument doc, TimestampGeneratorConfig config2, Map<Object, Object> selectors, Map<Object, Object> context) throws SoapSecurityException {
        ArrayList<OMNode> list;
        Request[] requests;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "moveTimestamp(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "TimestampGeneratorConfig config," + "Map selectors," + "Map context)");
        }
        if ((requests = RequestPool.get(context, TimestampRequest.class)) == null || requests.length == 0) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s13");
        }
        if (requests.length > 1) {
            throw SoapSecurityException.format("security.wssecurity.TimestampGenerator.s02");
        }
        TimestampRequest trequest = (TimestampRequest)requests[0];
        OMElement timestamp = trequest.getElement();
        RequestMessagePool.EncryptedObject eobj = RequestMessagePool.convertElement(context, timestamp, -1);
        if (eobj != null) {
            timestamp = eobj.getEncryptedData();
        }
        Map<Object, Object> properties = config2.getProperties();
        String dialect = (String)properties.get(Constants.WSSECURITY_TIMESTAMP_DIALECT);
        String keyword = (String)properties.get(Constants.WSSECURITY_TIMESTAMP_KEYWORD);
        boolean enforceStrictLayout = true;
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        String s1 = (String)gconfig.getProperties().get("com.ibm.ws.wssecurity.EnforceStrictLayout");
        if (s1 != null) {
            enforceStrictLayout = !s1.equals("false");
        }
        if (dialect == null) {
            dialect = com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS;
            keyword = config2.isSOAPHeaderElement() ? TimestampDialectElementSelector.WASDIALECTS[3] : (enforceStrictLayout ? TimestampDialectElementSelector.WASDIALECTS[0] : TimestampDialectElementSelector.WASDIALECTS[1]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Moving the Timestamp element to Dialect[" + dialect + "], " + "Keyword[" + keyword + "]...");
        }
        if ((list = TimestampGenerator.getTimestamp(doc, dialect, keyword, "move", trequest, eobj, timestamp, selectors, context)) != null && list.size() > 0) {
            if (list.size() > 1) {
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s14");
            }
            timestamp.detach();
            OMElement parent = (OMElement)list.get(0);
            parent.addChild(timestamp);
            if (eobj != null) {
                eobj.setEncryptedData(timestamp);
            } else {
                trequest.setElement(timestamp);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Succeed to move the Timestamp element to Dialect[" + dialect + "], " + "Keyword[" + keyword + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "moveTimestamp(OMDocument, TimestampGeneratorConfig, Map, Map)");
        }
    }

    public static ArrayList<OMNode> getTimestamp(OMDocument doc, String dialect, String keyword, String mode, TimestampRequest trequest, RequestMessagePool.EncryptedObject eobject, OMElement element, Map<Object, Object> selectors, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestamp(OMDocument doc[" + DOMUtils.getDisplayName(doc) + "]," + "String dialect[" + dialect + "]," + "String keyword[" + keyword + "]," + "String mode[" + mode + "]," + "TimestampRequest trequest[" + trequest + "]," + "EncryptedObject eobject[" + eobject + "]," + "OMElement element[" + DOMUtils.getDisplayName(element) + "]," + "Map selectors," + "Map context)");
        }
        HashMap<Object, Object> selectorMap = new HashMap<Object, Object>(context);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.dialect", dialect);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.keyword", keyword);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.operation", mode);
        selectorMap.put("com.ibm.ws.wssecurity.util.selector.element", new Object[]{element});
        ElementSelector esel = null;
        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(dialect)) {
            esel = (ElementSelector)selectors.get(TimestampDialectElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_FUNCTION.equals(dialect)) {
            esel = (ElementSelector)selectors.get(WSPFunctionElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(dialect)) {
            esel = (ElementSelector)selectors.get(XPathElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(dialect)) {
            esel = (ElementSelector)selectors.get(QNameHeaderSelector.class);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", dialect);
        }
        ArrayList<OMNode> list = esel.getElements(doc.getOMDocumentElement(), selectorMap);
        if (eobject != null) {
            Object[] objs = (Object[])selectorMap.get("com.ibm.ws.wssecurity.util.selector.element");
            eobject.setEncryptedData((OMElement)objs[0]);
        } else if (trequest != null) {
            Object[] objs = (Object[])selectorMap.get("com.ibm.ws.wssecurity.util.selector.element");
            trequest.setElement((OMElement)objs[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestamp(OMDocument, String, String, String,TimestampRequest, EncryptedObject, Element, Map, Map)");
        }
        return list;
    }
}

