/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.sc;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wssecurity.common.LocalNameConstants;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.impl.auth.callback.SCTCallback;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheHelper;
import com.ibm.ws.wssecurity.sc.util.SecureConversation;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSTokenUtil;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.ConstantsRetrieverFactory;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.PlatformContextUtil;
import com.ibm.ws.wssecurity.util.QuerySTSPluginProperty;
import com.ibm.ws.wssecurity.util.TokenHolder;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;

public class SecureConversationImpl
implements Serializable,
SecureConversation {
    private static final long serialVersionUID = 1242813010528764538L;
    private static final TraceComponent tc = Tr.register(SecureConversationImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SecureConversationImpl.class.getName();
    private static String tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT;
    private static long tokenTimeout = 0L;

    @Override
    public boolean isUsedForSigningAndEncryption(String uuid, MessageContext msgCtx) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsedForSigningAndEncryption(): uuid = " + uuid + ", MessageContext");
        }
        SCT sctoken = null;
        String sctuid = null;
        boolean isServer = false;
        try {
            isServer = Axis2Util.isServiceProvider(msgCtx);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage());
        }
        if (isServer) {
            HashMap wssMap = null;
            wssMap = (HashMap)msgCtx.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
            if (wssMap != null) {
                sctuid = (String)wssMap.get(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server side. Found the wss-ramp property map in the message context, sct uuid = " + sctuid);
                }
            } else {
                sctuid = TokenHolder.getTokenFromContext("com.ibm.ws.wssecurity.sc.InboundSCT", msgCtx);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server side. Getting SCToken uuid from message context and the key  is INBOUND_SCTOKEN, uuid = " + sctuid);
                }
                if (sctuid == null) {
                    sctuid = (String)msgCtx.getProperty(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server side. Getting SCToken uuid from message context and the key is sessionID, uuid = " + sctuid);
                    }
                }
            }
            if (sctuid != null && sctuid.equals(uuid)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isUsedForSigningAndEncryption() returnstrue");
                }
                return true;
            }
        } else {
            sctoken = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByContext(msgCtx);
            if (sctoken != null && sctoken.getUUID().equals(uuid)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client side. Found SCT in the cache. ");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isUsedForSigningAndEncryption() returnstrue");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsedForSigningAndEncryption() returnsfalse");
        }
        return false;
    }

    @Override
    public List getSignedParts(String uuid, MessageContext msgCtx) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignedParts(): uuid = " + uuid + ", MessageContext");
        }
        HashMap map = (HashMap)msgCtx.getProperty("SIGNED_ELEMENTS_MAP");
        ArrayList list = (ArrayList)map.get(uuid);
        if (tc.isEntryEnabled()) {
            if (list != null) {
                Tr.exit(tc, "getSignedParts() returns parts of " + list.size());
            } else {
                Tr.exit(tc, "getSignedParts() returns null");
            }
        }
        return list;
    }

    @Override
    public List getEncryptedParts(String uuid, MessageContext msgCtx) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEncryptionParts(): uuid = " + uuid + ", MessageContext");
        }
        HashMap map = (HashMap)msgCtx.getProperty("DECRYPTED_ELEMENTS_MAP");
        ArrayList list = (ArrayList)map.get(uuid);
        if (tc.isEntryEnabled()) {
            if (list != null) {
                Tr.exit(tc, "getEncryptionParts()) returns parts of " + list.size());
            } else {
                Tr.exit(tc, "getEncryptionParts() returns null");
            }
        }
        return list;
    }

    @Override
    public SecurityContextToken getSCToken(MessageContext msgCtx) throws SoapSecurityException {
        PrivateGeneratorConfig gCfg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSCTToken(): MessageContext");
        }
        if ((gCfg = SecureConversationImpl.parseMessageContext(msgCtx)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot get Policy/Binding information");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSCTToken(): MessageContext returns NULL");
            }
            return null;
        }
        if (!gCfg.isSCEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Secure Conversation is not enabled!");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSCTToken(): MessageContext returns NULL");
            }
            return null;
        }
        boolean isServer = false;
        try {
            isServer = Axis2Util.isServiceProvider(msgCtx);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage());
        }
        SecurityContextToken sctoken = null;
        if (!isServer) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "client side. Getting SCToken from global cache");
            }
            if ((sctoken = (SecurityContextToken)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByContext(msgCtx)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No SCT in the cache. Invoke callback handler");
                }
                if (gCfg != null && gCfg.isSCEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SC is in use");
                    }
                    Set<TokenGeneratorConfig> tokens = gCfg.getTokenGenerators();
                    Iterator<TokenGeneratorConfig> i = tokens.iterator();
                    String cbhname = null;
                    boolean isWSTrustCBH = false;
                    CallbackHandlerConfig cbhconf = null;
                    TokenGeneratorConfig tConfig = null;
                    while (i.hasNext()) {
                        tConfig = i.next();
                        cbhname = tConfig.getCallbackHandler().getClassName();
                        if (cbhname == null || !cbhname.equals("com.ibm.ws.wssecurity.impl.auth.callback.WSTrustCallbackHandler")) continue;
                        isWSTrustCBH = true;
                        cbhconf = tConfig.getCallbackHandler();
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "CallbackHandlerConfig [" + cbhconf + "].");
                        break;
                    }
                    if (isWSTrustCBH) {
                        CallbackHandler handler;
                        block49: {
                            handler = null;
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "About to Instantiate the callback handler [" + cbhname + "]...");
                                }
                                HashMap<String, CallbackHandlerConfig> properties = new HashMap<String, CallbackHandlerConfig>();
                                ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                                    public Object run() {
                                        return Thread.currentThread().getContextClassLoader();
                                    }
                                });
                                Class<?> cls = null;
                                if (loader != null) {
                                    try {
                                        cls = loader.loadClass(cbhname);
                                    }
                                    catch (Exception e) {
                                        cls = Class.forName(cbhname);
                                    }
                                } else {
                                    cls = Class.forName(cbhname);
                                }
                                if (CallbackHandler.class.isAssignableFrom(cls)) {
                                    properties.put("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey", cbhconf);
                                    Constructor<?> con = cls.getConstructor(Map.class);
                                    handler = (CallbackHandler)con.newInstance(properties);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Succeeded to Instantiate the callback handler [" + cbhname + "].");
                                    }
                                    break block49;
                                }
                                throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", cbhname, CallbackHandler.class.getName());
                            }
                            catch (Exception e) {
                                Tr.processException(e, clsName + ".invoke", "311");
                                Tr.error(tc, "security.wssecurity.X509TokenGenerator.s01", new Object[]{cbhname});
                                throw SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s01", cbhname, (Throwable)e);
                            }
                        }
                        HashMap<Object, Object> propertyMap = new HashMap<Object, Object>();
                        propertyMap.put("com.ibm.wsspi.wssecurity.core.messageContext", msgCtx);
                        propertyMap.put("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey", gCfg);
                        propertyMap.put("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey", tConfig);
                        SCTCallback sctCallback = new SCTCallback();
                        PropertyCallback propertyCallback = new PropertyCallback(propertyMap);
                        Callback[] callbacks = new Callback[]{sctCallback, propertyCallback};
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Invoking the callback handler [" + cbhname + "].");
                            }
                            handler.handle(callbacks);
                        }
                        catch (UnsupportedCallbackException e) {
                            Tr.processException(e, clsName + ".invoke", "379");
                            Tr.error(tc, "security.wssecurity.X509TokenGenerator.s02", new Object[]{cbhname});
                            SoapSecurityException sse = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", cbhname, (Throwable)e);
                            sse.initCause(e);
                            throw sse;
                        }
                        catch (IOException e) {
                            Throwable th = e;
                            if (e.getCause() != null) {
                                th = e.getCause();
                            }
                            Tr.processException(e, clsName + ".invoke", "388");
                            Tr.error(tc, "security.wssecurity.XTokenGenerator.s02", new Object[]{cbhname});
                            SoapSecurityException sse = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", cbhname, th);
                            sse.initCause(e);
                            throw sse;
                        }
                        sctoken = sctCallback.getToken();
                        cbhconf.setInstance(handler);
                        tokenType = sctoken.getValueType().getLocalPart();
                        long rmSeqTimeOut = Axis2Util.getRMSequenceInactivityTimeoutInterval(msgCtx);
                        if (tokenTimeout == 0L) {
                            this.getSCTokenTimeOut(null);
                        }
                        if (rmSeqTimeOut > tokenTimeout) {
                            Tr.warning(tc, "security.wssecurity.SecureConversationImpl.s02");
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SC is not used");
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Service side. Getting SCToken from message context");
            }
            String sctuid = null;
            HashMap wssMap = null;
            wssMap = (HashMap)msgCtx.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
            if (wssMap != null) {
                sctuid = (String)wssMap.get(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server side. Found the wss-ramp property map in the message context, sct uuid = " + sctuid);
                }
            } else {
                sctuid = TokenHolder.getTokenFromContext("com.ibm.ws.wssecurity.sc.InboundSCT", msgCtx);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server side. Getting SCToken uuid from message context and the key is INBOUND_SCTOKEN, uuid = " + sctuid);
                }
                if (sctuid == null) {
                    sctuid = (String)msgCtx.getProperty(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server side. Getting SCToken uuid from message context and the key is sessionID, uuid = " + sctuid);
                    }
                }
            }
            if (sctuid != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting the SecurityContextToken from the service side cache and the  uuid = " + sctuid);
                }
                try {
                    sctoken = (SecurityContextToken)((Object)STSTokenUtil.getToken(sctuid, tokenType));
                    if (sctoken != null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the SCToken from the service side cache sucessfully!");
                    }
                }
                catch (AxisFault af) {
                    Tr.processException(af.getCause(), clsName, "getSCToken(MessageContext)");
                    throw new SoapSecurityException(af.getMessage());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSCTToken() returns " + sctoken);
        }
        return sctoken;
    }

    @Override
    public SecurityContextToken getSCToken(String uuid) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSCTToken(uuid = " + uuid + ")");
        }
        SecurityContextToken sct = null;
        sct = (SecurityContextToken)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(uuid);
        if (sct == null) {
            block10: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not find the token in the client side cache. Try trust service cache..");
                }
                if (SCTHelper.getCache() != null) {
                    sct = (SCT)SCTHelper.getCache().getToken(uuid);
                }
                if (sct == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not find the token in the cache helper. Try trust service cache..");
                    }
                    try {
                        sct = (SCT)STSTokenUtil.getToken(uuid, tokenType);
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "Exception while getting SCT from trust service:" + e.getMessage());
                    }
                }
            }
            if (sct == null) {
                Tr.error(tc, "security.wssecurity.SecureConversationImpl.s01", new Object[]{uuid});
                throw SoapSecurityException.format("security.wssecurity.SecureConversationImpl.s01", uuid);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSCTToken() returns");
        }
        return sct;
    }

    @Override
    public byte[] getSCTokenBytes(String uuid) throws SoapSecurityException {
        SecurityContextToken scToken;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSCTTokenBytes(uuid = " + uuid + ")");
        }
        if ((scToken = this.getSCToken(uuid)) == null) {
            Tr.error(tc, "security.wssecurity.SecureConversationImpl.s01", new Object[]{uuid});
            throw SoapSecurityException.format("security.wssecurity.SecureConversationImpl.s01", uuid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSCTTokenBytes(String uuid) returns");
        }
        return ((SCT)scToken).getSerializationBytes();
    }

    @Override
    public SecurityContextToken getSCTokenFromBytes(byte[] token) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSCTTokenFromBytes(byte[] token)");
            Tr.exit(tc, "getSCTTokenFromBytes() returns");
        }
        SCT sct = new SCT();
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(token));
            sct.readExternal(in);
        }
        catch (Exception e) {
            Tr.error(tc, "Error deserializing SCT, encountered " + e.toString());
            sct = null;
            throw new SoapSecurityException(e.toString());
        }
        return sct;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public SecurityContextToken getSCTokenBySecurityTokenReference(OMElement STRElem, MessageContext msgCtx) throws SoapSecurityException {
        if (SecureConversationImpl.tc.isEntryEnabled()) {
            Tr.entry(SecureConversationImpl.tc, "getSCTTokenBySecurityTokenReference(OMElement, MessageContext)");
        }
        isServer = false;
        try {
            isServer = Axis2Util.isServiceProvider(msgCtx);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage());
        }
        elem = null;
        uri = null;
        id = null;
        uuid = null;
        sctoken = null;
        if (STRElem != null) {
            elem = DOMUtils.getChildElement(STRElem, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "Reference");
            uri = elem.getAttributeValue(new QName("", "URI"));
            if (SecureConversationImpl.tc.isDebugEnabled()) {
                Tr.debug(SecureConversationImpl.tc, "wsse:Reference URI in the RM supplied SecurityTokenReference element: " + uri);
            }
        } else if (SecureConversationImpl.tc.isDebugEnabled()) {
            Tr.debug(SecureConversationImpl.tc, "No Reference element found");
        }
        if (uri != null && uri.startsWith("#")) {
            uri = uri.substring(1);
            soapEnv = msgCtx.getEnvelope();
            soapHead = soapEnv.getHeader();
            doc = DOMUtil.getOwnerDocument(soapHead);
            if (SecureConversationImpl.tc.isDebugEnabled()) {
                Tr.debug(SecureConversationImpl.tc, "The original RM message to be processed : ");
                CommonLogUtils.logDebug(doc.getOMDocumentElement(), SecureConversationImpl.tc);
            }
            if ((elem1 = (idResolver = IdUtils.getInstance()).resolveID(doc, uri)) != null && LocalNameConstants.LocalNamesWSC.LN_SECURITY_CONTEXT_TOKEN.equals(elem1.getLocalName()) && com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC.equals(elem1.getNamespace().getNamespaceURI()) && (elem2 = DOMUtils.getChildElement(elem1, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Identifier")) != null) {
                uuid = DOMUtils.getStringValue(elem2);
                if (SecureConversationImpl.tc.isDebugEnabled()) {
                    Tr.debug(SecureConversationImpl.tc, "Found the matching SCT (Attached reference)for wsu:Id = " + uri + ", the uuid Identifier = " + uuid);
                }
            }
            if (uuid == null && SecureConversationImpl.tc.isDebugEnabled()) {
                Tr.debug(SecureConversationImpl.tc, "No SecurityContextToken element with the wsu:Id = " + uri + " Found.");
            }
        } else if (uri != null && uri.startsWith("uuid")) {
            uuid = uri;
            if (SecureConversationImpl.tc.isDebugEnabled()) {
                Tr.debug(SecureConversationImpl.tc, "Found the matching SCT (Unattached reference)for wsu:Id = " + uri + ", the uuid Identifier = " + uuid);
            }
        } else if (SecureConversationImpl.tc.isDebugEnabled()) {
            Tr.debug(SecureConversationImpl.tc, "No URI attribute found");
        }
        if (uuid != null) {
            if (!isServer) {
                sctoken = (SecurityContextToken)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(uuid);
            } else {
                try {
                    sctoken = (SecurityContextToken)STSTokenUtil.getToken(uuid, SecureConversationImpl.tokenType);
                    if (sctoken == null || !SecureConversationImpl.tc.isDebugEnabled()) ** GOTO lbl59
                    Tr.debug(SecureConversationImpl.tc, "Got the SecurityContextToken from the service side cache sucessfully!");
                }
                catch (AxisFault af) {
                    Tr.processException(af.getCause(), SecureConversationImpl.clsName, "getSCTokenBySecurityTokenReference(OMElement STRElem, MessageContext msgCtx)");
                    throw new SoapSecurityException(af.getMessage());
                }
            }
        } else if (SecureConversationImpl.tc.isDebugEnabled()) {
            Tr.debug(SecureConversationImpl.tc, "SCT referenced in the STR element(either direct reference by Identifier or indirect reference by wsu:Id) is NOT found in the message");
        }
lbl59:
        // 6 sources

        if (sctoken == null) {
            if (SecureConversationImpl.tc.isDebugEnabled()) {
                Tr.debug(SecureConversationImpl.tc, "SCT referenced by uuid = " + uuid + " not found");
            }
            Tr.error(SecureConversationImpl.tc, "security.wssecuritySCTConsumeLoginModule.invalidSCT03");
            throw SoapSecurityException.format("security.wssecuritySCTConsumeLoginModule.invalidSCT03");
        }
        if (SecureConversationImpl.tc.isEntryEnabled()) {
            Tr.exit(SecureConversationImpl.tc, "getSCTTokenBySecurityTokenReference(OMElement, MessageContext) returns " + sctoken);
        }
        return sctoken;
    }

    public static PrivateGeneratorConfig parseMessageContext(MessageContext msgCtxt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseMessageContext(MessageContext)");
        }
        PrivateGeneratorConfig gCfg = null;
        AxisOperation operation = msgCtxt.getAxisOperation();
        Parameter aParameter = null;
        Object obj = null;
        if (operation != null) {
            aParameter = operation.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey());
        }
        if (aParameter != null) {
            obj = aParameter.getValue();
        }
        PolicySetConfiguration psc = null;
        if (obj != null && obj instanceof PolicySetConfiguration) {
            psc = (PolicySetConfiguration)obj;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PolicySet from the operation context");
            }
        } else {
            AxisService service = msgCtxt.getAxisService();
            if (service != null) {
                aParameter = service.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey());
            }
            if (aParameter != null) {
                obj = aParameter.getValue();
            }
            if (obj != null && obj instanceof PolicySetConfiguration) {
                psc = (PolicySetConfiguration)obj;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PolicySet from the service context");
                }
            }
        }
        if (psc != null) {
            obj = psc.getPolicyTypeBinding(PrivateGeneratorConfig.class);
            if (obj != null && obj instanceof PrivateGeneratorConfig) {
                gCfg = (PrivateGeneratorConfig)obj;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "app policy = " + gCfg);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No PolicyType Binding");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No PolicySet configuration");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseMessageContext(MessageContext) returns " + gCfg);
        }
        return gCfg;
    }

    public static boolean cancelSCT(AxisService aService) throws WSSException {
        PrivateGeneratorConfig gCfg;
        SCT sctoken = null;
        Parameter par = aService.getParameter(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
        if (par != null) {
            String clientId = (String)par.getValue();
            sctoken = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(clientId);
        }
        if ((gCfg = SecureConversationImpl.getGeneratorConfigFromService(aService)) != null && gCfg.isSCEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "client side with security policy enabled. cancel SCT");
            }
            if (sctoken == null || sctoken.isCancelled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no SCT to cancel.");
                }
                return true;
            }
            Set<TokenGeneratorConfig> tokens = gCfg.getTokenGenerators();
            Iterator<TokenGeneratorConfig> i = tokens.iterator();
            String cbhname = null;
            while (i.hasNext() && ((cbhname = i.next().getCallbackHandler().getClassName()) == null || !cbhname.equals("com.ibm.ws.wssecurity.impl.auth.callback.WSTrustCallbackHandler"))) {
            }
            if (cbhname != null) {
                HashMap<Object, Object> properties;
                CallbackHandler handler;
                block24: {
                    handler = null;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SCT is not found. Instantiating the callback handler [" + cbhname + "]...");
                        }
                        properties = new HashMap<Object, Object>();
                        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        Class<?> cls = null;
                        if (loader != null) {
                            try {
                                cls = loader.loadClass(cbhname);
                            }
                            catch (Exception e) {
                                cls = Class.forName(cbhname);
                            }
                        } else {
                            cls = Class.forName(cbhname);
                        }
                        if (CallbackHandler.class.isAssignableFrom(cls)) {
                            Constructor<?> con = cls.getConstructor(Map.class);
                            handler = (CallbackHandler)con.newInstance(properties);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Succeeded to Instantiate the callback handler [" + cbhname + "].");
                            }
                            break block24;
                        }
                        throw SoapSecurityException.format("", cbhname, CallbackHandler.class.getName());
                    }
                    catch (Exception e) {
                        Tr.error(tc, "", new Object[]{cbhname, e});
                        return false;
                    }
                }
                properties = new HashMap();
                properties.put("com.ibm.ws.wssecurity.core.Constants.WSSECURITY_AXIS_SERVICE", aService);
                properties.put("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey", gCfg);
                properties.put("com.ibm.ws.wssecurity.sc.SCT.Cancel", "true");
                properties.put("com.ibm.ws.wssecurity.core.Constants.WSSECURITY_SCT", sctoken);
                PropertyCallback propertyCallback = new PropertyCallback(null);
                propertyCallback.setProperties(properties);
                Callback[] callbacks = new Callback[]{new SCTCallback(), propertyCallback};
                SCTCallback callback = null;
                try {
                    handler.handle(callbacks);
                }
                catch (UnsupportedCallbackException e) {
                    Tr.error(tc, "", new Object[]{cbhname, e});
                    SoapSecurityException sse = SoapSecurityException.format("", cbhname, (Throwable)e);
                    sse.initCause(e);
                    return false;
                }
                catch (IOException e) {
                    Throwable th = e;
                    if (e.getCause() != null) {
                        th = e.getCause();
                    }
                    Tr.error(tc, "", new Object[]{cbhname, th});
                    SoapSecurityException sse = SoapSecurityException.format("", cbhname, th);
                    sse.initCause(e);
                    return false;
                }
                callback = (SCTCallback)callbacks[0];
                sctoken = callback.getToken();
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cancel SCT using WSSAPI");
            }
            sctoken.cancel();
        }
        return true;
    }

    public static PrivateConsumerConfig getConsumerConfigFromService(AxisService axisService) {
        PrivateConsumerConfig cCfg = null;
        Object obj = null;
        PolicySetConfiguration psc = null;
        obj = axisService.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey()).getValue();
        if (obj != null && obj instanceof PolicySetConfiguration) {
            psc = (PolicySetConfiguration)obj;
        }
        if (psc != null && (obj = psc.getPolicyTypeBinding(PrivateConsumerConfig.class)) != null && obj instanceof PrivateConsumerConfig) {
            cCfg = (PrivateConsumerConfig)obj;
        }
        return cCfg;
    }

    public static PrivateGeneratorConfig getGeneratorConfigFromService(AxisService axisService) {
        PrivateGeneratorConfig gCfg = null;
        Object obj = null;
        PolicySetConfiguration psc = null;
        obj = axisService.getParameter(ConstantsRetrieverFactory.getInstance().getPolicySetKey()).getValue();
        if (obj != null && obj instanceof PolicySetConfiguration) {
            psc = (PolicySetConfiguration)obj;
        }
        if (psc != null && (obj = psc.getPolicyTypeBinding(PrivateGeneratorConfig.class)) != null && obj instanceof PrivateGeneratorConfig) {
            gCfg = (PrivateGeneratorConfig)obj;
        }
        return gCfg;
    }

    @Override
    public byte[] getWSSPropertyMapByteArray(MessageContext msgCtx) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSPropertyMapByteArray(MessageContext msgCtx)");
        }
        byte[] byteArray = new byte[]{};
        HashMap propertyMap = null;
        if (msgCtx != null) {
            propertyMap = (HashMap)msgCtx.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
            if (propertyMap == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not find property map in the current message context.");
                    Tr.debug(tc, "Look for it in the prev inbound message context.");
                }
                propertyMap = TokenHolder.getPropertyMapFromInboundMessageContext(msgCtx);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "MessageContext is null!");
        }
        if (propertyMap != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found property map in the message context.");
            }
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = new ObjectOutputStream(bos);
                objectOut.writeObject(propertyMap);
                byteArray = bos.toByteArray();
            }
            catch (IOException e) {
                Throwable th = e;
                if (e.getCause() != null) {
                    th = e.getCause();
                }
                Tr.error(tc, "", new Object[]{th});
                SoapSecurityException sse = SoapSecurityException.format("", th);
                sse.initCause(e);
                throw sse;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find property map in the message context.");
            }
            String instance = (String)msgCtx.getProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage");
            String uuid = (String)msgCtx.getProperty(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
            if (instance != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found instance in the message context: " + instance);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find instance in the message context.");
            }
            if (uuid != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found SCT uuid in the message context: " + uuid);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find SCT uuid in the message context.");
            }
        }
        if (tc.isDebugEnabled() && byteArray.length > 1) {
            Tr.debug(tc, "The WSS RAMP property map bytes = " + Base64.encode(byteArray));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSPropertyMapByteArray(MessageContext msgCtx) returns byte array");
        }
        return byteArray;
    }

    @Override
    public HashMap getWSSPropertyMapFromByteArray(byte[] wssmapbytes, MessageContext msgCtx) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSPropertyMapFromByteArray(byte[] wssmap, MessageContext msgCtx)");
        }
        HashMap propertyMap = null;
        if (wssmapbytes != null && wssmapbytes.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "valid wss propertymap bytes.");
            }
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(wssmapbytes);
                ObjectInputStream objectIn = new ObjectInputStream(bis);
                propertyMap = (HashMap)objectIn.readObject();
            }
            catch (IOException e) {
                Throwable th = e;
                if (e.getCause() != null) {
                    th = e.getCause();
                }
                Tr.error(tc, "", new Object[]{th});
                SoapSecurityException sse = SoapSecurityException.format("", th);
                sse.initCause(e);
                throw sse;
            }
            catch (ClassNotFoundException e) {
                Throwable th = e;
                if (e.getCause() != null) {
                    th = e.getCause();
                }
                Tr.error(tc, "", new Object[]{th});
                SoapSecurityException sse = SoapSecurityException.format("", th);
                sse.initCause(e);
                throw sse;
            }
        }
        if (propertyMap != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "valid wss propertymap");
                Tr.debug(tc, "Save the wss property map using com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP key");
            }
            msgCtx.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", propertyMap);
            String uuid = (String)propertyMap.get(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
            if (uuid != null) {
                try {
                    Parameter par;
                    if (msgCtx.getAxisService() != null && (par = msgCtx.getAxisService().getParameter(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER)) == null) {
                        par = new Parameter(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, uuid);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Add Client sessionId to AxisService = " + uuid);
                        }
                        msgCtx.getAxisService().addParameter(par);
                    }
                }
                catch (Exception e) {
                    Tr.debug(tc, "Unable to add client sessionId to AxisService. " + e.getMessage());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSPropertyMapFromByteArray(byte[] wssmap, MessageContext msgCtx) returns = " + propertyMap);
        }
        return propertyMap;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void restoreSCToken(byte[] token) throws SoapSecurityException {
        if (SecureConversationImpl.tc.isEntryEnabled()) {
            Tr.entry(SecureConversationImpl.tc, "restoreSCT(byte[] token)");
        }
        if (token == null) {
            if (SecureConversationImpl.tc.isEntryEnabled()) {
                Tr.exit(SecureConversationImpl.tc, "restoreSCT(byte[] token) returns, null token");
            }
            return;
        }
        if (SecureConversationImpl.tc.isDebugEnabled()) {
            Tr.debug(SecureConversationImpl.tc, "token bytes = " + Base64.encode(token));
        }
        sct = new SCT();
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(token));
            sct.readExternal(in);
            SecureConversationImpl.tokenType = sct.getValueType().getLocalPart();
        }
        catch (Exception e) {
            if (SecureConversationImpl.tc.isDebugEnabled()) {
                Tr.debug(SecureConversationImpl.tc, "Error when deserializing SCT. " + e.toString());
            }
            sct = null;
            throw new SoapSecurityException(e.toString());
        }
        if (PlatformContextUtil.isWebSphereServerProcess() && sct != null) {
            if (SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(sct.getUUID()) == null) {
                if (SecureConversationImpl.tc.isDebugEnabled()) {
                    Tr.debug(SecureConversationImpl.tc, "client cache does not have the SCT that is persisted. Update the cache");
                }
                SecureConversationCacheHelper.setSecurityContextTokenToCache(sct.getUUID(), null, sct, null);
            }
            if (SCTHelper.getCache() == null) {
                try {
                    if (STSTokenUtil.getToken(sct.getUUID(), SecureConversationImpl.tokenType) != null) ** GOTO lbl59
                    if (SecureConversationImpl.tc.isDebugEnabled()) {
                        Tr.debug(SecureConversationImpl.tc, "service cache does not have the SCT that is persisted. Update the cache");
                    }
                    STSTokenUtil.putToken(sct, SecureConversationImpl.tokenType);
                }
                catch (Exception e) {
                    Tr.error(SecureConversationImpl.tc, "error updating Service token cache");
                    throw new SoapSecurityException(e.toString());
                }
            } else if (SCTHelper.getCache().getToken(sct.getUUID()) == null) {
                if (SecureConversationImpl.tc.isDebugEnabled()) {
                    Tr.debug(SecureConversationImpl.tc, "Did not find the token in the service cache. But the STS config is completed. Update thru SCTHelper");
                }
                timeout = 0x6DDD00L;
                if (SCTHelper.getSCTConfigProperties() != null) {
                    props = SCTHelper.getSCTConfigProperties();
                    renewalWindowMinutesString = props.getProperty("renewalWindowMinutes", "120");
                    renewalWindowMSec = Integer.valueOf(renewalWindowMinutesString) * 60000;
                    instances = sct.getInstances();
                    latest = earliestDate = new Date(0L);
                    if (instances != null) {
                        for (i = 0; i < instances.length; ++i) {
                            currentInstance = instances[i];
                            currentExpiration = sct.getExpiration(currentInstance);
                            if (currentExpiration == null || !currentExpiration.after(latest)) continue;
                            latest = currentExpiration;
                        }
                        now = new Date();
                        if (!latest.equals(earliestDate)) {
                            timeout = latest.getTime() - now.getTime() + (long)renewalWindowMSec;
                        }
                    }
                }
                update = SCTHelper.getCache().cacheToken(sct.getUUID(), sct, timeout);
                if (SecureConversationImpl.tc.isDebugEnabled()) {
                    Tr.debug(SecureConversationImpl.tc, "Update the token in the service cache. result = " + update);
                }
            }
        }
lbl59:
        // 9 sources

        if (SecureConversationImpl.tc.isEntryEnabled()) {
            Tr.exit(SecureConversationImpl.tc, "restoreSCToken(byte[] token)");
        }
    }

    @Override
    public long getSCTokenTimeOut(ConfigurationContext cContext) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSCTokenTimeOut(ConfigurationContext cContext)");
        }
        if (tokenTimeout != 0L) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSCTokenTimeOut(ConfigurationContext cContext) returns token timeout = " + tokenTimeout);
            }
            return tokenTimeout;
        }
        if (PlatformContextUtil.isWebSphereServerProcess()) {
            if (SCTHelper.getSCTConfigProperties() != null) {
                Properties props = SCTHelper.getSCTConfigProperties();
                String lifeTimeInMinsString = props.getProperty("lifetimeMinutes", "120");
                tokenTimeout = Integer.valueOf(lifeTimeInMinsString) * 60 * 1000;
            } else {
                String lifeTimeInMinsString = (String)QuerySTSPluginProperty.query("lifetimeMinutes");
                if (lifeTimeInMinsString != null) {
                    tokenTimeout = Integer.valueOf(lifeTimeInMinsString) * 60 * 1000;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot determine SCT lifetime.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT lifetime = " + tokenTimeout);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSCTokenTimeOut(ConfigurationContext cContext)");
        }
        return tokenTimeout;
    }
}

