/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.security.impl;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.wssecurity.saml.common.util.IdUtils;
import com.ibm.ws.wssecurity.saml.security.impl.KeyInfoUtil;
import com.ibm.ws.wssecurity.util.CertificateUtil;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceObject;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureObject;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Validity;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertSelector;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXBuilder;

public class SAMLSignatureVerification {
    private static final TraceComponent tc = Tr.register(SAMLSignatureVerification.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SAMLSignatureVerification.class.getName();
    private static final QName ALGORITHM_Q = new QName("", "Algorithm");
    private static final QName TYPE_Q = new QName("", "Type");

    public static boolean verify(OMElement om, KeyStoreManager.KeyInformation keyInformation, KeyStore trustAnchor) throws SoapSecurityException {
        OMElement signature = DOMUtils.getOneChildElement(om, Constants.NS_DSIG, "Signature");
        OMElement keyInfoElement = KeyInfo.searchForKeyInfo(signature);
        X509Certificate cert = null;
        Key key = null;
        if (keyInformation != null) {
            key = KeyInfoUtil.getKey(keyInformation, keyInfoElement, true);
            cert = (X509Certificate)keyInformation.getCertificate();
        } else {
            key = KeyInfoUtil.extractKey(keyInfoElement, cert);
        }
        if (key == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Can not locate KeyInfo to verify SAML signature.");
            }
            return false;
        }
        if (keyInformation == null && trustAnchor != null) {
            SAMLSignatureVerification.validateX509(trustAnchor, cert);
        }
        WSSSignatureContext scontext = new WSSSignatureContext();
        AlgorithmFactory aFactory = AlgorithmFactory.getInstance();
        scontext.setAlgorithmFactory(aFactory);
        scontext.setIDResolver(IdUtils.getInstance());
        scontext.setResourceShower(ShowerImpl.getInstance());
        SignatureObject signatureObject = new SignatureObject();
        OMDocument doc = DOMUtils.createDocument();
        OMElement ass = om.cloneOMElement();
        if (ass.getParent() != null) {
            ass.detach();
            StAXBuilder aBuilder = (StAXBuilder)ass.getBuilder();
            if (aBuilder != null) {
                aBuilder.releaseParserOnClose(true);
            }
        }
        doc.setOMDocumentElement(ass);
        scontext.setDocument(doc);
        signature = DOMUtils.getOneChildElement(ass, Constants.NS_DSIG, "Signature");
        signatureObject.setOwnerDocument(doc);
        int hash = 0;
        String ns = null;
        String ln = null;
        OMElement el = DOMUtils.getFirstElement(signature);
        while (el != null) {
            ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_DS_SIGNEDINFO) {
                signatureObject.setSignedInfoElement(el);
                SAMLSignatureVerification.checkSignedInfo(doc, el, signatureObject, scontext.getIDResolver());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (hash == Constants.HASH_DS_KEYINFO) {
                signatureObject.setKey(el);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (hash == Constants.HASH_DS_SIGNATUREVALUE) {
                signatureObject.setSignatureValue(DOMUtil.getStringValue(el));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (hash == Constants.HASH_DS_OBJECT) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK. But this consumer ignores it.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(signature));
            }
            el = DOMUtils.getNextElement(el);
        }
        Validity validity = scontext.verify(signature, key, signatureObject);
        boolean coreValidity = validity.getCoreValidity();
        String errMsg = null;
        if (!coreValidity) {
            StringBuffer buf = new StringBuffer();
            buf.append("Core validity=");
            buf.append(coreValidity);
            buf.append(" Signed info validity=");
            buf.append(validity.getSignedInfoValidity());
            buf.append(" Signed info message='");
            buf.append(validity.getSignedInfoMessage());
            buf.append("'");
            int count = validity.getNumberOfReferences();
            for (int j = 0; j < count; ++j) {
                buf.append("(validity=");
                buf.append(validity.getReferenceValidity(j));
                buf.append(" message='");
                buf.append(validity.getReferenceMessage(j));
                buf.append("' uri='");
                buf.append(validity.getReferenceURI(j));
                buf.append("' type='");
                buf.append(validity.getReferenceType(j));
                buf.append("')");
            }
            errMsg = buf.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAML Assertion signature is verified." + errMsg);
            }
            if (coreValidity) {
                errMsg = null;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SAML Assertion signature is verified:" + coreValidity);
        }
        return coreValidity;
    }

    private static void checkSignedInfo(OMDocument doc, OMElement sinfo, SignatureObject signatureObject, IDResolver idResolver) throws SoapSecurityException {
        int hash = 0;
        OMElement el = DOMUtils.getFirstElement(sinfo);
        while (el != null) {
            String algorithm1;
            String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_DS_C14NMETHOD) {
                algorithm1 = DOMUtils.getAttribute(el, "Algorithm");
                signatureObject.setC14NMethod(algorithm1);
                signatureObject.setC14NMethodElement(el);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " [" + algorithm1 + "] is OK.");
                }
            } else if (hash == Constants.HASH_DS_SIGNATUREMETHOD) {
                algorithm1 = DOMUtils.getAttribute(el, "Algorithm");
                signatureObject.setSignatureMethod(algorithm1);
                signatureObject.setSignatureMethodElement(el);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " [" + algorithm1 + "] is OK.");
                }
            } else if (hash == Constants.HASH_DS_REFERENCE) {
                SAMLSignatureVerification.checkReference(doc, el, idResolver, signatureObject);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(sinfo));
            }
            el = DOMUtils.getNextElement(el);
        }
    }

    private static void checkReference(OMDocument doc, OMElement reference, IDResolver idResolver, SignatureObject signatureObject) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkReference(Document doc[" + DOMUtils.getDisplayName(doc) + "]," + "Element reference[" + DOMUtils.getDisplayName(reference) + "]," + "WSSConsumerConfig gconfig," + "SigningReferenceConfig config," + "IDResolver idResolver[" + idResolver + "]," + "SignatureObject signatureObject[" + signatureObject + "]," + "Map context)");
        }
        int hash = 0;
        OMElement object = null;
        ReferenceObject referenceObject = new ReferenceObject();
        OMElement el = DOMUtils.getFirstElement(reference);
        while (el != null) {
            String algorithm1;
            String ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_DS_TRANSFORMS) {
                referenceObject.setTransformsElement(el);
                OMElement el3 = DOMUtils.getFirstElement(el);
                while (el3 != null) {
                    ns = el3.getNamespace() == null ? null : el3.getNamespace().getNamespaceURI();
                    ln = el3.getLocalName();
                    hash = ns == null ? 0 : ns.hashCode() * 31;
                    if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_DS_TRANSFORM) {
                        algorithm1 = el3.getAttributeValue(ALGORITHM_Q);
                        referenceObject.addTransformAlgorithmAndParameter(algorithm1, DOMUtil.getFirstChildElement(el3));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, ln + " is OK.");
                        }
                    }
                    el3 = DOMUtils.getNextElement(el3);
                }
            } else if (hash == Constants.HASH_DS_DIGESTMETHOD) {
                algorithm1 = DOMUtils.getAttribute(el, "Algorithm");
                referenceObject.setDigestAlgorithm(algorithm1);
                referenceObject.setDigestMethod(el);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " [" + algorithm1 + "] is OK.");
                }
            } else if (hash == Constants.HASH_DS_DIGESTVALUE) {
                referenceObject.setDigestValue(DOMUtil.getStringValue(el));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ln + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(el), DOMUtils.getQualifiedName(reference)});
            }
            el = DOMUtils.getNextElement(el);
        }
        String refUri = DOMUtils.getAttribute(reference, "URI");
        referenceObject.setUriRef(refUri);
        String type = reference.getAttributeValue(TYPE_Q);
        referenceObject.setType(type);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing URI [" + refUri + "]...");
        }
        if (refUri.length() == 0) {
            object = doc.getOMDocumentElement();
        } else {
            if (refUri.length() < 2 || refUri.charAt(0) != '#') {
                throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s02", refUri);
            }
            refUri = refUri.substring(1);
            object = idResolver.resolveID(doc, refUri);
        }
        if (object == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The URI [" + refUri + "] is not supported." + "  Either the id is defined in the wrong namespace or no id's have a matching value.");
            }
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s02", refUri);
        }
        referenceObject.setOwnerDocument(signatureObject.getOwnerDocument());
        signatureObject.add(referenceObject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkReference(Document doc,Element reference,IDResolver idResolver,SignatureObject signatureObject");
        }
    }

    private static final boolean validateX509(KeyStore trustAnchor, X509Certificate cert) throws SoapSecurityException {
        PKIXBuilderParameters pkixBuilderParams = null;
        PKIXCertPathValidatorResult result = null;
        KeyStoreManager ksManager = KeyStoreManager.getInstance();
        try {
            X509CertSelector selector = new X509CertSelector();
            pkixBuilderParams = new PKIXBuilderParameters(trustAnchor, (CertSelector)selector);
            pkixBuilderParams.setDate(null);
        }
        catch (InvalidAlgorithmParameterException e) {
            Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s12", new String[]{e.getMessage()});
            String errorMes = ConfigUtil.getMessage("security.wssecurity.CommonReceiverConfig.s12", new String[]{e.getMessage()});
            throw new SoapSecurityException(errorMes);
        }
        catch (KeyStoreException e) {
            Tr.error(tc, ".CommonReceiverConfig.s12", new String[]{e.getMessage()});
            String errorMes = ConfigUtil.getMessage("security.wssecurity.CommonReceiverConfig.s12", new String[]{e.getMessage()});
            throw new SoapSecurityException(errorMes);
        }
        try {
            result = CertificateUtil.validateX509Certificate(cert, null, pkixBuilderParams);
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".validateX509", "916");
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        return true;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        @Override
        public void showSignedResource(OMElement owner, int count, String uri, String type, byte[] content, String encoding) {
            ByteArrayInputStream in = new ByteArrayInputStream(content);
            if (count < 0) {
                Tr.debug(tc, "ResourceShower logs verify-SignedInfo: ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else if (uri == null || uri.length() == 0) {
                Tr.debug(tc, "ResourceShower logs verify-resource_" + count + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else {
                Tr.debug(tc, "ResourceShower logs verify-" + uri + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }

        @Override
        public void showSignedResource(OMElement owner, int count, String uri, String type, byte[] content, int offset, int length, String encoding) {
            ByteArrayInputStream in = new ByteArrayInputStream(content, offset, length);
            if (count < 0) {
                Tr.debug(tc, "ResourceShower logs verify-SignedInfo: ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else if (uri == null || uri.length() == 0) {
                Tr.debug(tc, "ResourceShower logs verify-resource_" + count + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else {
                Tr.debug(tc, "ResourceShower logs verify-" + uri + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }
    }
}

