/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.security.impl;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.SimpleKey;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class ProcessKey {
    public static final String XMLDSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";

    public static Key createKey(OMElement keyValue) throws SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        OMNode node = DOMUtil.getFirstChild2(keyValue);
        while (node != null) {
            if (node.getType() == 1) {
                OMElement el = (OMElement)node;
                if (!ProcessKey.isDsigElement(el)) {
                    throw new SignatureStructureException("Unknown element: " + el.getQName());
                }
                if (ProcessKey.isDsigElement(el, "DSAKeyValue")) {
                    return ProcessKey.createDSAKey(el);
                }
                if (ProcessKey.isDsigElement(el, "RSAKeyValue")) {
                    return ProcessKey.createRSAKey(el);
                }
                throw new SignatureStructureException("Unknown element: " + el.getQName());
            }
            node = DOMUtil.getNextSibling2(node);
        }
        String valueString = DOMUtil.getStringValue(keyValue);
        return new SimpleKey(Base64.decode(valueString));
    }

    static Key createDSAKey(OMElement dsakv) throws SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger p = null;
        BigInteger q = null;
        BigInteger g = null;
        BigInteger y = null;
        OMNode node = DOMUtil.getFirstChild2(dsakv);
        while (node != null) {
            if (node.getType() == 1) {
                OMElement el = (OMElement)node;
                if (ProcessKey.isDsigElement(el, "P")) {
                    p = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(el)));
                } else if (ProcessKey.isDsigElement(el, "Q")) {
                    q = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(el)));
                } else if (ProcessKey.isDsigElement(el, "G")) {
                    g = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(el)));
                } else if (ProcessKey.isDsigElement(el, "Y")) {
                    y = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(el)));
                } else if (!(ProcessKey.isDsigElement(el, "J") || ProcessKey.isDsigElement(el, "Seed") || ProcessKey.isDsigElement(el, "PgenCounter"))) {
                    throw new SignatureStructureException("Unknown element: " + el.getQName());
                }
            }
            node = DOMUtil.getNextSibling2(node);
        }
        if (p == null) {
            throw new SignatureStructureException("No P element in the DSAKeyValue element.");
        }
        if (q == null) {
            throw new SignatureStructureException("No Q element in the DSAKeyValue element.");
        }
        if (g == null) {
            throw new SignatureStructureException("No G element in the DSAKeyValue element.");
        }
        if (y == null) {
            throw new SignatureStructureException("No Y element in the DSAKeyValue element.");
        }
        KeyFactory factory = KeyFactory.getInstance("DSA");
        return factory.generatePublic(new DSAPublicKeySpec(y, p, q, g));
    }

    static Key createRSAKey(OMElement rsakv) throws SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger modulus = null;
        BigInteger exponent = null;
        OMNode node = DOMUtil.getFirstChild2(rsakv);
        while (node != null) {
            if (node.getType() == 1) {
                OMElement el = (OMElement)node;
                if (ProcessKey.isDsigElement(el, "Modulus")) {
                    byte[] md = Base64.decode(DOMUtil.getStringValue(el));
                    modulus = new BigInteger(1, md);
                } else if (ProcessKey.isDsigElement(el, "Exponent")) {
                    exponent = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(el)));
                } else {
                    throw new SignatureStructureException("Unknown element: " + el.getQName());
                }
            }
            node = DOMUtil.getNextSibling2(node);
        }
        if (modulus == null) {
            throw new SignatureStructureException("No Modulus element in the RSAKeyValue element.");
        }
        if (exponent == null) {
            throw new SignatureStructureException("No Exponent element in the RSAKeyValue element.");
        }
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePublic(new RSAPublicKeySpec(modulus, exponent));
    }

    static final boolean isDsigElement(OMElement element) {
        String ns;
        String string = ns = element.getNamespace() == null ? null : element.getNamespace().getName();
        if (ns == null) {
            return false;
        }
        return ns.equals(XMLDSIG_NAMESPACE);
    }

    static final boolean isDsigElement(OMElement element, String localPart) {
        String ns;
        String string = ns = element.getNamespace() == null ? null : element.getNamespace().getName();
        if (ns == null) {
            return false;
        }
        return ns.equals(XMLDSIG_NAMESPACE) && element.getLocalName().equals(localPart);
    }
}

