/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.security.impl;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.saml.security.impl.ProcessKey;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

public class KeyInfoUtil {
    private static final TraceComponent tc = Tr.register(KeyInfoUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();
    public static final String Thumbprint = "Thumbprint";
    public static final String X509SKI = "X509SKI";
    public static final String X509SubjectName = "X509SubjectName";
    public static final String X509IssuerSerial = "X509IssuerSerial";
    public static final String X509Certificate = "X509Certificate";
    public static final String KeyValue = "KeyValue";

    public static OMElement createKeyInfo(String keyInfoType, KeyStoreManager.KeyInformation keyInformation, OMElement parent) throws SoapSecurityException {
        OMElement keyinfo = null;
        OMFactory factory = omFactory;
        if (parent != null) {
            factory = parent.getOMFactory();
        }
        if (parent == null) {
            keyinfo = factory.createOMElement("KeyInfo", "http://www.w3.org/2000/09/xmldsig#", "ds");
            keyinfo.declareNamespace("http://www.w3.org/2000/09/xmldsig#", "ds");
        } else {
            keyinfo = factory.createOMElement("KeyInfo", "http://www.w3.org/2000/09/xmldsig#", "ds");
        }
        OMElement om = KeyInfoUtil.createKeyInfoContent(keyInfoType, null, keyInformation, parent);
        keyinfo.addChild(om);
        return keyinfo;
    }

    public static OMElement createKeyInfoContent(String keyInfoType, Key inkey, KeyStoreManager.KeyInformation keyInformation, OMElement parent) throws SoapSecurityException {
        OMFactory factory = omFactory;
        if (parent != null) {
            factory = parent.getOMFactory();
        }
        OMElement insideKeyInfo = null;
        Key key = inkey;
        if (key == null) {
            key = keyInformation.getPublicOrSecretKey();
        }
        if (Thumbprint.equalsIgnoreCase(keyInfoType)) {
            int wssVersion = 0;
            String nsWsse = Constants.NAMESPACES[0][wssVersion];
            String pWsse = "wsse";
            insideKeyInfo = omFactory.createOMElement("SecurityTokenReference", nsWsse, pWsse);
            insideKeyInfo.declareNamespace(nsWsse, pWsse);
            OMElement kielem = omFactory.createOMElement("KeyIdentifier", nsWsse, pWsse);
            QName encodingType = Constants.BASE64_BINARY;
            DOMUtils.setQNameAttr(kielem, null, "EncodingType", encodingType, wssVersion);
            QName valueType = Constants.THUMBPRINTSHA1;
            DOMUtils.setQNameAttr(kielem, null, "ValueType", valueType, wssVersion);
            insideKeyInfo.addChild(kielem);
            String thumbprint = keyInformation.getB64Thumbprint();
            OMText text = omFactory.createOMText(thumbprint);
            kielem.addChild(text);
        } else if (KeyValue.equalsIgnoreCase(keyInfoType)) {
            OMElement keyValue = omFactory.createOMElement(KeyValue, "http://www.w3.org/2000/09/xmldsig#", "ds");
            if (!KeyInfoUtil.instanceOf(key, "java.security.interfaces.RSAPublicKey")) {
                Tr.error(tc, "Not a RSAPublicKey. Invalid Key type.");
                throw new RuntimeException("KeyValue Type Not Implemented.");
            }
            RSAPublicKey rkey = (RSAPublicKey)key;
            OMElement rsakv = omFactory.createOMElement("RSAKeyValue", "http://www.w3.org/2000/09/xmldsig#", "ds");
            String text = KeyInfoUtil.encodeBigInteger(rkey.getModulus());
            rsakv.addChild(DOMUtil.createTextElementNS(omFactory, rsakv, "Modulus", text));
            text = KeyInfoUtil.encodeBigInteger(rkey.getPublicExponent());
            rsakv.addChild(DOMUtil.createTextElementNS(omFactory, rsakv, "Exponent", text));
            keyValue.addChild(rsakv);
            insideKeyInfo = keyValue;
        } else if (X509IssuerSerial.equalsIgnoreCase(keyInfoType)) {
            String nsDs = Constants.NS_DSIG;
            String pDs = "ds";
            OMElement data = factory.createOMElement("X509Data", nsDs, pDs);
            OMElement issuer = factory.createOMElement(X509IssuerSerial, nsDs, pDs);
            data.addChild(issuer);
            OMElement name = factory.createOMElement("X509IssuerName", nsDs, pDs);
            issuer.addChild(name);
            String issuerDN = keyInformation.getIssuerDN();
            OMText tname = factory.createOMText(issuerDN);
            name.addChild(tname);
            OMElement number = factory.createOMElement("X509SerialNumber", nsDs, pDs);
            issuer.addChild(number);
            String issuerSerial = keyInformation.getIssuerSerial();
            OMText tsnum = factory.createOMText(issuerSerial);
            number.addChild(tsnum);
            insideKeyInfo = data;
        } else if (X509SKI.equalsIgnoreCase(keyInfoType)) {
            String nsDs = Constants.NS_DSIG;
            String pDs = "ds";
            OMElement data = factory.createOMElement("X509Data", nsDs, pDs);
            OMElement issuer = factory.createOMElement(X509SKI, nsDs, pDs);
            data.addChild(issuer);
            String issuerSerial = keyInformation.getB64KeyId();
            OMText tsnum = factory.createOMText(issuerSerial);
            issuer.addChild(tsnum);
            insideKeyInfo = data;
        } else if (X509SubjectName.equalsIgnoreCase(keyInfoType)) {
            String nsDs = Constants.NS_DSIG;
            String pDs = "ds";
            OMElement data = factory.createOMElement("X509Data", nsDs, pDs);
            OMElement issuer = factory.createOMElement(X509SubjectName, nsDs, pDs);
            data.addChild(issuer);
            String subjectname = keyInformation.getSubjectDN();
            OMText tsnum = factory.createOMText(subjectname);
            issuer.addChild(tsnum);
            insideKeyInfo = data;
        } else if (X509Certificate.equalsIgnoreCase(keyInfoType)) {
            String nsDs = Constants.NS_DSIG;
            String pDs = "ds";
            OMElement data = factory.createOMElement("X509Data", nsDs, pDs);
            OMElement issuer = factory.createOMElement(X509Certificate, nsDs, pDs);
            data.addChild(issuer);
            Certificate cert = keyInformation.getCertificate();
            try {
                OMText tsnum = factory.createOMText(Base64.encode(cert.getEncoded()));
                issuer.addChild(tsnum);
            }
            catch (Exception e) {
                throw new SoapSecurityException(e.getMessage());
            }
            insideKeyInfo = data;
        }
        return insideKeyInfo;
    }

    public static Key getKey(KeyStoreManager.KeyInformation keyInformation, OMElement keyInfoElm, boolean verify) throws SoapSecurityException {
        Key key = null;
        try {
            String thumbprint = keyInformation.getB64Thumbprint();
            String subjectKeyId = keyInformation.getB64KeyId();
            String subjectname = keyInformation.getSubjectDN();
            String issuer = keyInformation.getIssuerDN() + keyInformation.getIssuerSerial();
            Certificate cert = keyInformation.getCertificate();
            String x509Cert = Base64.encode(cert.getEncoded());
            String keyvalue = null;
            boolean match = false;
            OMNode ch = DOMUtil.getFirstChild2(keyInfoElm);
            while (ch != null) {
                block32: {
                    OMElement el;
                    block33: {
                        if (ch.getType() != 1) break block32;
                        el = (OMElement)ch;
                        if (KeyInfoUtil.isDsigElement(el)) break block33;
                        while (ch != null && !KeyInfoUtil.isDsigElement(el = (OMElement)(ch = el.getFirstOMChild()))) {
                        }
                        if (el == null || !KeyInfoUtil.isDsigElement(el)) break block32;
                    }
                    if (KeyInfoUtil.isDsigElement(el, KeyValue)) {
                        String B;
                        key = ProcessKey.createKey(el);
                        String A = Base64.encode(key.getEncoded());
                        if (A.equals(B = Base64.encode(keyInformation.getPublicOrSecretKey().getEncoded()))) {
                            match = true;
                            break;
                        }
                    } else if (KeyInfoUtil.isDsigElement(el, "X509Data")) {
                        OMElement x5data = el;
                        OMNode x5 = DOMUtil.getFirstChild2(x5data);
                        while (x5 != null) {
                            OMElement x5Element;
                            if (x5.getType() == 1 && KeyInfoUtil.isDsigElement(x5Element = (OMElement)x5)) {
                                if (KeyInfoUtil.isDsigElement(x5Element, X509Certificate)) {
                                    keyvalue = DOMUtils.getStringValue(x5Element);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "X509Certificate=" + keyvalue);
                                    }
                                    if (x509Cert.equals(keyvalue)) {
                                        match = true;
                                        break;
                                    }
                                } else if (KeyInfoUtil.isDsigElement(x5Element, X509IssuerSerial)) {
                                    keyvalue = DOMUtils.getStringValue(x5Element);
                                    keyvalue = DOMUtils.getStringValue(x5Element);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "X509IssuerSerial=" + keyvalue);
                                    }
                                    if (issuer.replace(" ", "").equals(keyvalue.replace(" ", ""))) {
                                        match = true;
                                        break;
                                    }
                                } else if (KeyInfoUtil.isDsigElement(x5Element, X509SKI)) {
                                    keyvalue = DOMUtils.getStringValue(x5Element);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "X509SKI=" + keyvalue);
                                    }
                                    if (subjectKeyId.equals(keyvalue)) {
                                        match = true;
                                        break;
                                    }
                                } else if (KeyInfoUtil.isDsigElement(x5Element, X509SubjectName)) {
                                    keyvalue = DOMUtils.getStringValue(x5Element);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "X509SubjectName=" + keyvalue);
                                    }
                                    if (subjectname.replace(" ", "").equals(keyvalue.replace(" ", ""))) {
                                        match = true;
                                        break;
                                    }
                                }
                            }
                            x5 = DOMUtil.getNextSibling2(x5);
                        }
                    } else {
                        ch = el.getFirstOMChild();
                    }
                }
                ch = DOMUtil.getNextSibling2(ch);
            }
            if (match) {
                key = verify ? keyInformation.getPublicOrSecretKey() : keyInformation.getPrivateOrSecretKey();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KeyInfo does not match Key defined in Bindings for " + keyInformation.getSubjectDN());
                }
                key = null;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to resolve KeyInfo:" + e.getMessage());
            }
            throw new SoapSecurityException(e.getMessage());
        }
        return key;
    }

    public static Key extractKey(OMElement keyInfoElm, X509Certificate cert) throws SoapSecurityException {
        Key key = null;
        try {
            OMNode ch = DOMUtil.getFirstChild2(keyInfoElm);
            while (ch != null) {
                block15: {
                    String ln;
                    OMElement el;
                    block16: {
                        if (ch.getType() != 1) break block15;
                        el = (OMElement)ch;
                        if (KeyInfoUtil.isDsigElement(el)) break block16;
                        while (ch != null && !KeyInfoUtil.isDsigElement(el = (OMElement)(ch = el.getFirstOMChild()))) {
                        }
                        if (el == null || !KeyInfoUtil.isDsigElement(el)) break block15;
                    }
                    if (KeyValue.equals(ln = el.getLocalName())) {
                        key = ProcessKey.createKey(el);
                    } else if ("X509Data".equals(ln)) {
                        OMNode x5 = DOMUtil.getFirstChild2(el);
                        while (x5 != null) {
                            OMElement x5Element;
                            if (x5.getType() == 1 && KeyInfoUtil.isDsigElement(x5Element = (OMElement)x5) && KeyInfoUtil.isDsigElement(x5Element, X509Certificate)) {
                                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                                byte[] certbytes = Base64.decode(DOMUtil.getStringValue(el));
                                ByteArrayInputStream bais = new ByteArrayInputStream(certbytes);
                                cert = (X509Certificate)certFactory.generateCertificate(bais);
                                KeyStoreManager ksManager = KeyStoreManager.getInstance();
                                KeyStoreManager.KeyInformation keyInformation = ksManager.getKeyInformation(cert);
                                key = keyInformation.getPublicOrSecretKey();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Extract key for " + cert.getSubjectDN().getName());
                                }
                            }
                            x5 = DOMUtil.getNextSibling2(x5);
                        }
                    } else {
                        ch = el.getFirstOMChild();
                    }
                }
                ch = DOMUtil.getNextSibling2(ch);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail  to resolve KeyInfo:" + e.getMessage());
            }
            throw new SoapSecurityException(e.getMessage());
        }
        return key;
    }

    public static final boolean isDsigElement(OMElement element) {
        String ns;
        String string = ns = element.getNamespace() == null ? null : element.getNamespace().getName();
        if (ns == null) {
            return false;
        }
        return ns.equals("http://www.w3.org/2000/09/xmldsig#");
    }

    static final boolean isDsigElement(OMElement element, String localPart) {
        String ns;
        String string = ns = element.getNamespace() == null ? null : element.getNamespace().getName();
        if (ns == null) {
            return false;
        }
        return ns.equals("http://www.w3.org/2000/09/xmldsig#") && element.getLocalName().equals(localPart);
    }

    private static boolean matchClass(Class cl, String className) {
        if (cl.getName().equals(className)) {
            return true;
        }
        Class superclass = cl.getSuperclass();
        if (superclass != null && KeyInfoUtil.matchClass(superclass, className)) {
            return true;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!KeyInfoUtil.matchClass(interfaces[i], className)) continue;
            return true;
        }
        return false;
    }

    private static boolean instanceOf(Object obj, String className) {
        return KeyInfoUtil.matchClass(obj.getClass(), className);
    }

    private static String encodeBigInteger(BigInteger bi) {
        byte[] data = bi.toByteArray();
        int off = 0;
        while (data[off] == 0) {
            ++off;
        }
        return Base64.encode(data, off, data.length - off);
    }
}

