/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.security.impl;

import com.ibm.ws.wssecurity.saml.security.HoKAssertion;
import com.ibm.ws.wssecurity.saml.security.impl.EncryptedKeyConsume;
import com.ibm.ws.wssecurity.saml.security.impl.EncryptedKeyGenerate;
import com.ibm.ws.wssecurity.saml.security.impl.KeyInfoUtil;
import com.ibm.ws.wssecurity.saml.security.impl.ProcessKey;
import com.ibm.ws.wssecurity.saml.security.impl.SAMLEncryptedKey;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class HoKAssertionImpl
implements HoKAssertion {
    private static final TraceComponent tc = Tr.register(HoKAssertionImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = HoKAssertionImpl.class.getName();
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private KeyStoreManager.KeyInformation keyInformation = null;
    private String thumbprint = null;
    private byte[] symmetricProofKey = null;
    private Key key = null;
    private Key privatekey = null;
    private SAMLEncryptedKey encryptedKey = null;
    private OMElement xml = null;
    private ProviderConfig issueCfg = null;
    private RequesterConfig requestData = null;
    private CredentialConfig cred = null;
    private ConsumerConfig assertionConsumingCfg = null;

    public HoKAssertionImpl() {
    }

    public HoKAssertionImpl(OMElement om) {
        this.xml = om;
    }

    public HoKAssertionImpl(ConsumerConfig ksCfg) {
        this.assertionConsumingCfg = ksCfg;
    }

    public HoKAssertionImpl(ProviderConfig conf, RequesterConfig requester, CredentialConfig cred) {
        this.issueCfg = conf;
        this.requestData = requester;
        this.cred = cred;
    }

    public void createHok() throws SoapSecurityException {
        String keyType = this.requestData.getRSTTProperties().get("wstrustClientKeyType");
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(keyType)) {
            this.createSymmetricKeyInfo();
        } else if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equals(keyType)) {
            this.createAsymmetricKeyInfo();
        } else if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer".equals(keyType)) {
            // empty if block
        }
    }

    public void createAsymmetricKeyInfo() throws SoapSecurityException {
        try {
            String storePath = this.issueCfg.getTrustStoreConfig().getPath();
            String storeType = this.issueCfg.getTrustStoreConfig().getType();
            char[] storePassword = this.issueCfg.getTrustStoreConfig().getPassword().toCharArray();
            String keyStoreRef = this.issueCfg.getTrustStoreConfig().getKsRef();
            String alias = this.requestData.getKeyAliasForRequester();
            char[] keyPassword = null;
            String keyName = "";
            KeyStoreManager ksManager = KeyStoreManager.getInstance();
            this.keyInformation = ksManager.getKeyInformation(storePath, storeType, storePassword, keyStoreRef, alias, keyPassword, keyName);
            this.key = this.keyInformation.getPublicOrSecretKey();
            this.privatekey = null;
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
    }

    public void createSymmetricKeyInfo() throws SoapSecurityException {
        String alias = null;
        String dn = "";
        alias = this.requestData.getKeyAliasForAppliesTo();
        if (alias != null) {
            KeyStoreManager ksManager = KeyStoreManager.getInstance();
            try {
                this.keyInformation = ksManager.getKeyInformation(this.issueCfg.getTrustStoreConfig().getPath(), this.issueCfg.getTrustStoreConfig().getType(), this.issueCfg.getTrustStoreConfig().getPassword().toCharArray(), this.issueCfg.getTrustStoreConfig().getKsRef(), alias, null, dn);
            }
            catch (Exception e) {
                throw new SoapSecurityException(e.getMessage(), e.getCause());
            }
            this.encryptedKey = EncryptedKeyGenerate.generateEncryptedKey(this.requestData, this.keyInformation, false);
            this.symmetricProofKey = this.encryptedKey.getClearKey().getEncoded();
            this.privatekey = this.key = this.encryptedKey.getClearKey();
        }
    }

    public byte[] getSymmetricProofKey() {
        return this.symmetricProofKey;
    }

    @Override
    public Key getPrivateOrSharedKey() {
        return this.privatekey;
    }

    public void setPrivateKey(Key pkey) {
        this.privatekey = pkey;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        if (this.xml != null) {
            return this.xml;
        }
        return this.marshal(null);
    }

    @Override
    public void setXML(OMElement om) {
        this.xml = om;
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        if (this.xml != null) {
            return this.xml;
        }
        OMElement keyinfo = null;
        if (parent == null) {
            keyinfo = omFactory.createOMElement("KeyInfo", "http://www.w3.org/2000/09/xmldsig#", "ds");
            keyinfo.declareNamespace("http://www.w3.org/2000/09/xmldsig#", "ds");
        } else {
            keyinfo = parent.getOMFactory().createOMElement("KeyInfo", "http://www.w3.org/2000/09/xmldsig#", "ds");
        }
        String keyType = this.requestData.getRSTTProperties().get("wstrustClientKeyType");
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(keyType)) {
            OMElement encKey = this.encryptedKey.getEncryptedKeyElement();
            keyinfo.addChild(encKey);
        } else if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equals(keyType)) {
            OMElement keyValue = null;
            try {
                keyValue = KeyInfoUtil.createKeyInfoContent(this.requestData.getHolderOfKeyKeyInfoType(), this.key, this.keyInformation, null);
                keyinfo.addChild(keyValue);
            }
            catch (Exception e) {
                throw new SoapSecurityException(e.getMessage(), e.getCause());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no proof key generated for Keyless Assertion.");
        }
        this.xml = keyinfo;
        return keyinfo;
    }

    @Override
    public void unMarshal(OMElement keyInfo) throws SoapSecurityException {
        this.xml = keyInfo;
        if (this.assertionConsumingCfg == null) {
            return;
        }
        OMNode ch = DOMUtil.getFirstChild2(keyInfo);
        while (ch != null) {
            if (ch.getType() == 1) {
                OMElement el = (OMElement)ch;
                String ln = el.getLocalName();
                if ("KeyValue".equals(ln)) {
                    try {
                        this.key = ProcessKey.createKey(el);
                        this.privatekey = null;
                    }
                    catch (Exception e) {
                        throw new SoapSecurityException(e.getMessage(), e.getCause());
                    }
                }
                if ("X509Data".equals(ln)) {
                    this.privatekey = null;
                    try {
                        OMNode x5 = DOMUtil.getFirstChild2(el);
                        while (x5 != null) {
                            OMElement x5Element;
                            if (x5.getType() == 1 && KeyInfoUtil.isDsigElement(x5Element = (OMElement)x5) && KeyInfoUtil.isDsigElement(x5Element, "X509Certificate")) {
                                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                                byte[] certbytes = Base64.decode(DOMUtil.getStringValue(el));
                                ByteArrayInputStream bais = new ByteArrayInputStream(certbytes);
                                X509Certificate cert = (X509Certificate)certFactory.generateCertificate(bais);
                                KeyStoreManager ksManager = KeyStoreManager.getInstance();
                                KeyStoreManager.KeyInformation keyInformation = ksManager.getKeyInformation(cert);
                                this.key = keyInformation.getPublicOrSecretKey();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Holder-of-key for " + cert.getSubjectDN().getName());
                                }
                            }
                            x5 = DOMUtil.getNextSibling2(x5);
                        }
                    }
                    catch (Exception e) {
                        throw new SoapSecurityException(e.getMessage(), e.getCause());
                    }
                }
                if ("EncryptedKey".equals(ln)) {
                    try {
                        this.key = EncryptedKeyConsume.decryptEncryptedKey(el, this.assertionConsumingCfg);
                        this.symmetricProofKey = this.key.getEncoded();
                        this.privatekey = this.key;
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fail to decrypt EncryptedKey:" + e.getMessage());
                        }
                        throw new RuntimeException("Fail to decrypt EncryptedKey");
                    }
                }
            }
            ch = DOMUtil.getNextSibling2(ch);
        }
    }

    @Override
    public void create() throws SoapSecurityException {
        this.createHok();
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        return true;
    }

    private static boolean matchClass(Class cl, String className) {
        if (cl.getName().equals(className)) {
            return true;
        }
        Class superclass = cl.getSuperclass();
        if (superclass != null && HoKAssertionImpl.matchClass(superclass, className)) {
            return true;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!HoKAssertionImpl.matchClass(interfaces[i], className)) continue;
            return true;
        }
        return false;
    }

    private static boolean instanceOf(Object obj, String className) {
        return HoKAssertionImpl.matchClass(obj.getClass(), className);
    }

    private static String encodeBigInteger(BigInteger bi) {
        byte[] data = bi.toByteArray();
        int off = 0;
        while (data[off] == 0) {
            ++off;
        }
        return Base64.encode(data, off, data.length - off);
    }
}

