/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.security.impl;

import com.ibm.ws.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.wssecurity.saml.common.util.IdUtils;
import com.ibm.ws.wssecurity.saml.security.EnvelopedSignatureAssertion;
import com.ibm.ws.wssecurity.saml.security.impl.KeyInfoUtil;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Reference;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TemplateGenerator;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.io.ByteArrayInputStream;
import java.security.Key;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class EnvelopedSignatureAssertionImpl
implements EnvelopedSignatureAssertion {
    private static final TraceComponent tc = Tr.register(EnvelopedSignatureAssertionImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String ENVELOPED_SIGN = "http://www.w3.org/2000/09/xmldsig#enveloped-signature".intern();
    private static final String DIGEST_METHOD = "http://www.w3.org/2000/09/xmldsig#sha1";
    private static final String TRANSFORM_METHOD = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private KeyStoreManager.KeyInformation keyInformation = null;
    private OMElement unsignedOM = null;
    private OMElement signatureOM = null;
    private String id = null;
    private RequesterConfig requesterData = null;
    private String keyInfoType = null;

    public EnvelopedSignatureAssertionImpl() {
    }

    public EnvelopedSignatureAssertionImpl(RequesterConfig requesterData, KeyStoreManager.KeyInformation keyInformation, OMElement unsignedOM, String assertionID) {
        this.keyInformation = keyInformation;
        this.id = assertionID;
        this.unsignedOM = unsignedOM;
        this.requesterData = requesterData;
        this.keyInfoType = this.requesterData.getSignatureKeyInfoType();
    }

    @Override
    public OMElement marshal(OMElement parent) {
        if (this.signatureOM != null) {
            return this.signatureOM;
        }
        try {
            return this.createSignatureElement(this.keyInformation, this.unsignedOM, this.id, this.keyInfoType);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void unMarshal(OMElement om) {
    }

    public OMElement createSignatureElement(KeyStoreManager.KeyInformation keyInformation, OMElement unsignedOM, String id, String keyValueType) throws SoapSecurityException {
        OMFactory omFactory = unsignedOM.getOMFactory();
        TemplateGenerator gen = new TemplateGenerator(omFactory, null, TRANSFORM_METHOD, "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        gen.setPrefix("ds");
        Reference ref = gen.createReference("#" + id);
        ref.setDigestMethod(DIGEST_METHOD);
        ref.addTransform(ENVELOPED_SIGN);
        ref.addTransform(TRANSFORM_METHOD);
        gen.addReference(ref);
        AlgorithmFactory aFactory = AlgorithmFactory.getInstance();
        OMElement signature = null;
        try {
            signature = gen.getSignatureElement(aFactory);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getCause());
        }
        OMElement keyinfo = omFactory.createOMElement("KeyInfo", "http://www.w3.org/2000/09/xmldsig#", "ds");
        OMElement keyinfoCont = KeyInfoUtil.createKeyInfoContent(keyValueType, null, keyInformation, null);
        keyinfo.addChild(keyinfoCont);
        signature.addChild(keyinfo);
        unsignedOM.addChild(signature);
        Key signKey = keyInformation.getPrivateOrSecretKey();
        WSSSignatureContext scontext = new WSSSignatureContext();
        scontext.setAlgorithmFactory(aFactory);
        scontext.setIDResolver(IdUtils.getInstance());
        OMDocument doc = DOMUtils.createDocument();
        doc.addChild(unsignedOM);
        scontext.setDocument(doc);
        scontext.setResourceShower(ShowerImpl.getInstance());
        try {
            signature = scontext.sign(signature, signKey);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getCause());
        }
        this.signatureOM = signature;
        return signature;
    }

    @Override
    public String getDigestAlgorithm() {
        return null;
    }

    @Override
    public String getSignatureAlgorithm() {
        return null;
    }

    @Override
    public String getKeyValueType() {
        return null;
    }

    @Override
    public OMElement getXML() {
        if (this.signatureOM == null) {
            this.signatureOM = this.marshal(null);
        }
        return this.signatureOM;
    }

    @Override
    public void create() throws SoapSecurityException {
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        return true;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        @Override
        public void showSignedResource(OMElement owner, int count, String uri, String type, byte[] content, String encoding) {
            ByteArrayInputStream in = new ByteArrayInputStream(content);
            if (count < 0) {
                Tr.debug(tc, "ResourceShower logs verify-SignedInfo: ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else if (uri == null || uri.length() == 0) {
                Tr.debug(tc, "ResourceShower logs verify-resource_" + count + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else {
                Tr.debug(tc, "ResourceShower logs verify-" + uri + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }

        @Override
        public void showSignedResource(OMElement owner, int count, String uri, String type, byte[] content, int offset, int length, String encoding) {
            ByteArrayInputStream in = new ByteArrayInputStream(content, offset, length);
            if (count < 0) {
                Tr.debug(tc, "ResourceShower logs verify-SignedInfo: ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else if (uri == null || uri.length() == 0) {
                Tr.debug(tc, "ResourceShower logs verify-resource_" + count + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            } else {
                Tr.debug(tc, "ResourceShower logs verify-" + uri + ": ");
                CommonLogUtils.logDebug(in, encoding, tc);
            }
            try {
                in.close();
            }
            catch (Exception e) {
                Tr.debug(tc, "Caugh exception closing input stream: e=" + e.getMessage());
            }
        }
    }
}

