/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.security.impl;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.saml.security.impl.KeyInfoUtil;
import com.ibm.ws.wssecurity.saml.security.impl.SAMLEncryptedKey;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSNonceGenerator;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMText;

public class EncryptedKeyGenerate {
    private static final TraceComponent tc = Tr.register(EncryptedKeyGenerate.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName;
    private static final OMFactory omFactory;
    private static final WSSAlgorithmFactory _algorithmFactory;
    protected static final String algorithmKwAes128 = "http://www.w3.org/2001/04/xmlenc#kw-aes128-cbc";
    protected static final String algorithmKwAes192 = "http://www.w3.org/2001/04/xmlenc#kw-aes192-cbc";
    protected static final String algorithmKwAes256 = "http://www.w3.org/2001/04/xmlenc#kw-aes256-cbc";
    protected static final String algorithmKwTripleDes = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    protected static final String algorithmKwRsaOaep = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    protected static final String algorithmKwRsa15 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";

    public static SAMLEncryptedKey generateEncryptedKey(RequesterConfig requester, KeyStoreManager.KeyInformation keyInformation, boolean isSymmetric) throws SoapSecurityException {
        String dataEncAlgorithm = requester.getRSTTProperties().get("wstrustClientEncryptionAlgorithm");
        String encAlgorithm = EncryptedKeyGenerate.getKeyWrapAlgorithm(dataEncAlgorithm, isSymmetric);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Key wrap Encryption Algorithm : " + encAlgorithm);
        }
        EncryptionContext econtext = new EncryptionContext();
        econtext.setAlgorithmFactory(_algorithmFactory);
        econtext.setEncAlgorithm(encAlgorithm);
        OMElement el = null;
        SecretKeySpec dek = null;
        SAMLEncryptedKey ek = new SAMLEncryptedKey();
        ek.setEncryptionMethod(EncryptedKeyGenerate.createEncryptionMethod(encAlgorithm, _algorithmFactory));
        ek.setCipherData(EncryptedKeyGenerate.createCipherData());
        try {
            String sKeySize;
            OMElement keyinfo = KeyInfoUtil.createKeyInfoContent(requester.getEncryptionKeyInfoType(), null, keyInformation, null);
            ek.setKeyInfo(EncryptedKeyGenerate.createKeyInfo(keyinfo));
            el = ek.createElement(omFactory, null);
            Key kek = keyInformation.getPublicOrSecretKey();
            EncryptedData ed = new EncryptedData();
            ed.setEncryptionMethod(EncryptedKeyGenerate.createEncryptionMethod(dataEncAlgorithm, _algorithmFactory));
            ed.setCipherData(EncryptedKeyGenerate.createCipherData());
            econtext.setEncryptedType(ed.createElement(omFactory, null), null, null, null);
            int iKeySize = 16;
            Map<String, String> map = requester.getRSTTProperties();
            if (map != null && (sKeySize = map.get("wstrustClientKeySize")) != null) {
                iKeySize = Integer.parseInt(sKeySize) / 8;
            }
            byte[] nonce = WSSNonceGenerator.generateBytes(iKeySize);
            dek = new SecretKeySpec(nonce, dataEncAlgorithm);
            econtext.setEncryptedType(el, null, null, null);
            econtext.setData(dek);
            econtext.setKey(kek);
            econtext.encrypt();
            ek.setClearKey(dek);
            ek.setEncryptedKeyElement(el);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        return ek;
    }

    private static KeyInfo createKeyInfo(OMElement keyInfo) {
        KeyInfo ki = new KeyInfo();
        ki.addElement(keyInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyInfo(Document doc) returns KeyInfo[" + ki + "]");
        }
        return ki;
    }

    private static OMElement getKeyInfo(KeyStoreManager.KeyInformation keyInformation) {
        OMElement strelem = null;
        try {
            int wssVersion = 0;
            String nsWsse = Constants.NAMESPACES[0][wssVersion];
            String pWsse = "wsse";
            strelem = omFactory.createOMElement("SecurityTokenReference", nsWsse, pWsse);
            strelem.declareNamespace(nsWsse, pWsse);
            OMElement kielem = omFactory.createOMElement("KeyIdentifier", nsWsse, pWsse);
            QName encodingType = Constants.BASE64_BINARY;
            DOMUtils.setQNameAttr(kielem, null, "EncodingType", encodingType, wssVersion);
            QName valueType = Constants.THUMBPRINTSHA1;
            DOMUtils.setQNameAttr(kielem, null, "ValueType", valueType, wssVersion);
            strelem.addChild(kielem);
            String thumbprint = keyInformation.getB64Thumbprint();
            OMText text = omFactory.createOMText(thumbprint);
            kielem.addChild(text);
        }
        catch (Exception e) {
            Tr.error(tc, "Fail to generate keyInfo for the EncryptedKey.");
        }
        return strelem;
    }

    private static CipherData createCipherData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCipherData()");
        }
        CipherValue cv = new CipherValue();
        CipherData cd = new CipherData();
        cd.setCipherValue(cv);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCipherData() returns CipherData[" + cd + "]");
        }
        return cd;
    }

    public static EncryptionMethod createEncryptionMethod(String encAlgorithm, WSSAlgorithmFactory factory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptionMethod(AlgorithmConfig encAlgorithm[" + encAlgorithm + "]," + "WSSAlgorithmFactory factory[" + factory + "])");
        }
        EncryptionMethod em = new EncryptionMethod();
        em.setAlgorithm(encAlgorithm);
        try {
            AlgorithmParameterSpec spec = factory.convertParameter(encAlgorithm, new HashMap());
            if (spec != null) {
                em.setParameterSpec(factory, spec);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptionMethod(AlgorithmConfig aconfig,WSSAlgorithmFactory factory) returns EncryptionMethod[" + em + "]");
        }
        return em;
    }

    public static String getKeyWrapAlgorithm(String algorithmSuite, boolean isSymmetric) {
        String algorithm = null;
        algorithm = isSymmetric ? (algorithmSuite.contains("Basic256") ? algorithmKwAes256 : (algorithmSuite.contains("Basic192") ? algorithmKwAes192 : (algorithmSuite.contains("Basic128") ? algorithmKwAes128 : algorithmKwTripleDes))) : (algorithmSuite.contains("Rsa15") ? algorithmKwRsa15 : algorithmKwRsaOaep);
        return algorithm;
    }

    static {
        omFactory = OMAbstractFactory.getOMFactory();
        _algorithmFactory = (WSSAlgorithmFactory)WSSAlgorithmFactory.getInstance();
    }
}

