/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.security.impl;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.saml.security.impl.EncryptedKeyGenerate;
import com.ibm.ws.wssecurity.saml.security.impl.KeyInfoUtil;
import com.ibm.ws.wssecurity.saml.security.impl.ProcessKey;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import java.security.Key;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class EncryptedKeyConsume {
    private static final TraceComponent tc = Tr.register(EncryptedKeyConsume.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName;
    private static final WSSAlgorithmFactory _algorithmFactory;

    public static Key decryptEncryptedKey(OMElement enckey, ConsumerConfig keyStoreCfg) throws SoapSecurityException {
        String algorithm = keyStoreCfg.getAlgorithmSuite();
        Key kek = null;
        OMElement keyInfoElm = null;
        OMElement el = DOMUtils.getFirstElement(enckey);
        while (el != null) {
            String ln = el.getLocalName();
            if ("KeyInfo".equals(ln)) {
                keyInfoElm = el;
                break;
            }
            el = DOMUtils.getNextElement(el);
        }
        OMNode ch = DOMUtil.getFirstChild2(keyInfoElm);
        while (ch != null) {
            OMElement el2;
            String ln;
            if (ch.getType() == 1 && "KeyValue".equals(ln = (el2 = (OMElement)ch).getLocalName())) {
                try {
                    kek = ProcessKey.createKey(el2);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ch = DOMUtil.getNextSibling2(ch);
        }
        if (kek == null) {
            KeyStoreManager.KeyInformation keyInformation = null;
            KeyStoreManager ksManager = KeyStoreManager.getInstance();
            keyInformation = ksManager.getKeyInformation(keyStoreCfg.getKeyStoreConfig().getPath(), keyStoreCfg.getKeyStoreConfig().getType(), keyStoreCfg.getKeyStoreConfig().getPassword().toCharArray(), keyStoreCfg.getKeyStoreConfig().getKsRef(), keyStoreCfg.getKeyInformationConfig().getAlias(), keyStoreCfg.getKeyInformationConfig().getKeyPass().toCharArray(), keyStoreCfg.getKeyInformationConfig().getName());
            kek = KeyInfoUtil.getKey(keyInformation, keyInfoElm, false);
        }
        DecryptionContext dcontext = new DecryptionContext();
        dcontext.setIdResolver(IdUtils.getInstance());
        dcontext.setAlgorithmFactory(_algorithmFactory);
        Key dek = null;
        try {
            dcontext.setEncryptedType(enckey, null, null, null);
            OMElement encMethod = null;
            encMethod = DOMUtils.getChildElement(enckey, Constants.NS_ENC, "EncryptionMethod");
            QName attrQname = new QName("", "Algorithm");
            String encAlgorithm = encMethod.getAttributeValue(attrQname);
            dcontext.setEncAlgorithm(encAlgorithm);
            EncryptionMethod em = EncryptedKeyGenerate.createEncryptionMethod(algorithm, _algorithmFactory);
            dcontext.setEncryptionMethod(em.createElement(encMethod.getOMFactory(), null));
            dcontext.setKey(kek);
            dcontext.decrypt();
            dek = (Key)dcontext.getData();
            dcontext.setEncryptionMethod((OMElement)null);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception from decrypting the key: ", e);
            }
            Tr.processException(e, clsName + ".decryptEncryptedKey", "793");
            Tr.error(tc, "security.wssecurity.EncryptionConsumer.s11", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s11", new String[]{e.getMessage()}, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptEncryptedKey(OMElement enckey,DecryptionContext dcontext,Key kek,OMElement encdata) returns Key[" + dek + "]");
        }
        return dek;
    }

    static {
        _algorithmFactory = (WSSAlgorithmFactory)WSSAlgorithmFactory.getInstance();
    }
}

