/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.security.impl;

import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.security.impl.EncryptedKeyConsume;
import com.ibm.ws.wssecurity.saml.security.impl.ProcessKey;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DecryptionContext;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import java.security.Key;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class EncryptedDataConsumer {
    private static final TraceComponent tc = Tr.register(EncryptedDataConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = EncryptedDataConsumer.class.getName();
    private static final WSSAlgorithmFactory _algorithmFactory = (WSSAlgorithmFactory)WSSAlgorithmFactory.getInstance();
    private static final String Default_Data_Encryption_Algorithm = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";

    public static OMElement DecryptEncryptedData(OMElement om, ConsumerConfig assertionConsumingCfg) throws SoapSecurityException {
        String encAlgorithm = assertionConsumingCfg.getAlgorithmSuite();
        if (encAlgorithm == null || encAlgorithm.isEmpty()) {
            encAlgorithm = Default_Data_Encryption_Algorithm;
        }
        Key key = null;
        OMElement clearData = null;
        OMElement el = OMUtil.getFirstElement(om);
        while (el != null) {
            String ln = el.getLocalName();
            if ("EncryptionMethod".equals(ln)) {
                QName QAttr = new QName(null, "Algorithm");
                encAlgorithm = el.getAttributeValue(QAttr);
                assertionConsumingCfg.setAlgorithmSuite(encAlgorithm);
            } else if ("KeyInfo".equals(ln)) {
                key = EncryptedDataConsumer.decryptKey(el, assertionConsumingCfg);
            } else if ("CipherData".equals(ln)) {
                clearData = EncryptedDataConsumer.decryptCipherData(om, key, encAlgorithm);
            }
            el = OMUtil.getNextElement(el);
        }
        return clearData;
    }

    public static Key decryptKey(OMElement keyInfo, ConsumerConfig assertionConsumingCfg) throws SoapSecurityException {
        Key key = null;
        OMNode ch = DOMUtil.getFirstChild2(keyInfo);
        while (ch != null) {
            if (ch.getType() == 1) {
                OMElement el = (OMElement)ch;
                String ln = el.getLocalName();
                if ("KeyValue".equals(ln)) {
                    try {
                        key = ProcessKey.createKey(el);
                    }
                    catch (Exception e) {
                        throw new SoapSecurityException(e.getMessage(), e.getCause());
                    }
                }
                if ("EncryptedKey".equals(ln)) {
                    try {
                        key = EncryptedKeyConsume.decryptEncryptedKey(el, assertionConsumingCfg);
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fail to decrypt EncryptedKey:" + e.getMessage());
                        }
                        throw new RuntimeException("Fail to decrypt EncryptedKey");
                    }
                }
            }
            ch = DOMUtil.getNextSibling2(ch);
        }
        return key;
    }

    public static OMElement decryptCipherData(OMElement encdata, Key dek, String encAlgorithm) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptEncryptedData(OMElement encdata[" + DOMUtils.getDisplayName(encdata) + "]," + "Key kek[" + dek + "]");
        }
        OMElement dpart = null;
        DecryptionContext dcontext = new DecryptionContext();
        dcontext.setIdResolver(IdUtils.getInstance());
        dcontext.setAlgorithmFactory(_algorithmFactory);
        try {
            dcontext.setEncryptedType(encdata, null, null, null);
            QName attrQname = new QName("", "Algorithm");
            dcontext.setEncAlgorithm(encAlgorithm);
            dcontext.setKey(dek);
            dcontext.decrypt();
            Iterator it = dcontext.getDataAsNodeList();
            if (it.hasNext()) {
                dpart = (OMElement)it.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Decrypted SAML Assertion: ", dpart);
                }
            }
            dcontext.setEncryptionMethod((OMElement)null);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception from decrypting the key: ", e);
            }
            Tr.processException(e, clsName + ".decryptEncryptedKey", "793");
            Tr.error(tc, "security.wssecurity.EncryptionConsumer.s11", new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s11", new String[]{e.getMessage()}, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptEncryptedData(OMElement encdata,DecryptionContext dcontext,Key dek,");
        }
        return dpart;
    }
}

