/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.utils;

import com.ibm.ws.wssecurity.saml.saml20.assertion.Assertion;
import com.ibm.ws.wssecurity.saml.security.impl.SAMLSignatureVerification;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import java.security.KeyStore;
import java.util.Date;
import org.apache.axiom.om.OMElement;

public class SAMLVerifier {
    private static final TraceComponent tc = Tr.register(SAMLVerifier.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SAMLVerifier.class.getName();

    public static boolean verifySAMLHeader(Assertion as) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifySAMLHeader(Assertion)");
        }
        boolean verified = true;
        if (as.getID() == null || as.getID().trim().length() == 0) {
            verified = false;
        }
        if (as.getIssueInstant() == null) {
            verified = false;
        }
        if (as.getIssuer() == null || as.getIssuer().getValue() == null || as.getIssuer().getValue().length() == 0) {
            verified = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifySAMLHeader(Assertion): " + new Boolean(verified).toString());
        }
        return verified;
    }

    public static boolean verifySAMLCondition(Assertion as) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifySAMLCondition(Assertion)");
        }
        Date notBefore = as.getConditions().getNotBefore();
        Date notAfter = as.getConditions().getNotOnOrAfter();
        Date now = new Date();
        if (now.getTime() + 180000L < notBefore.getTime()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAML issued in future time.");
            }
            return false;
        }
        if (now.getTime() - 180000L > notAfter.getTime()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAML issued in future time.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "verifySAMLCondition(Assertion) : returning false");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifySAMLCondition(Assertion) : returning true");
        }
        return true;
    }

    public static boolean verifySAMLAssertion(OMElement om, ConsumerConfig samlCfg) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifySAMLAssertion(OMElement, ConsumerConfig)");
        }
        KeyStoreManager.KeyInformation keyInformation = null;
        KeyStoreManager ksManager = KeyStoreManager.getInstance();
        if (samlCfg.getKeyInformationConfig() != null && samlCfg.getKeyInformationConfig().getAlias() != null && !samlCfg.getKeyInformationConfig().getAlias().isEmpty()) {
            keyInformation = ksManager.getKeyInformation(samlCfg.getTrustStoreConfig().getPath(), samlCfg.getTrustStoreConfig().getType(), samlCfg.getTrustStoreConfig().getPassword().toCharArray(), samlCfg.getTrustStoreConfig().getKsRef(), samlCfg.getKeyInformationConfig().getAlias(), null, samlCfg.getKeyInformationConfig().getName());
        }
        KeyStore trustAnchor = null;
        boolean verified = SAMLSignatureVerification.verify(om, keyInformation, trustAnchor);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifySAMLAssertion(OMElement, ConsumerConfig): " + new Boolean(verified).toString());
        }
        return verified;
    }
}

