/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.utils;

import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.ws.wssecurity.saml.assertion.wssapi.SAMLAssertionParser;
import com.ibm.ws.wssecurity.saml.common.SAMLAssertion;
import com.ibm.ws.wssecurity.saml.common.SAMLObjectElement;
import com.ibm.ws.wssecurity.saml.common.util.Base64;
import com.ibm.ws.wssecurity.saml.common.util.KeyUtils;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Assertion;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Attribute;
import com.ibm.ws.wssecurity.saml.saml20.assertion.AttributeStatement;
import com.ibm.ws.wssecurity.saml.saml20.assertion.AudienceRestriction;
import com.ibm.ws.wssecurity.saml.saml20.assertion.AuthnStatement;
import com.ibm.ws.wssecurity.saml.saml20.assertion.ConditionAbstract;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Conditions;
import com.ibm.ws.wssecurity.saml.saml20.assertion.NameID;
import com.ibm.ws.wssecurity.saml.saml20.assertion.StatementAbstract;
import com.ibm.ws.wssecurity.saml.saml20.assertion.SubjectConfirmationData;
import com.ibm.ws.wssecurity.saml.security.HoKAssertion;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAML20TokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAMLTokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactoryFactory;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.data.SAMLAttribute;
import com.ibm.wsspi.wssecurity.saml.data.SAMLNameID;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;

public class SAMLTokenBuilder {
    private static final TraceComponent tc = Tr.register(SAMLTokenBuilder.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName("com.ibm.ws.wssecurity.platform.SAML20Token");
    private static TokenFactory _tokenFactory = TokenFactoryFactory.getTokenFactory(_factoryKey);

    public static SAML20TokenImpl createSAMLToken(SAMLAssertion samlAssertion) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSAMLToken(SAMLAssertion)");
        }
        Assertion saml = (Assertion)samlAssertion;
        SAML20TokenImpl samlToken = (SAML20TokenImpl)_tokenFactory.getToken(true);
        samlToken.setAssertionQName(saml.getAssertionQName());
        samlToken.setConfirmationMethod(saml.getConfirmationMethod());
        NameID nameId = saml.getIssuer();
        if (nameId != null) {
            samlToken.setSAMLIssuerName(nameId.getValue());
        }
        boolean symmetricHok = false;
        if (saml.getSubject() != null) {
            HoKAssertion hok;
            SubjectConfirmationData subj;
            if (saml.getSubject().getNameID() != null) {
                String name = saml.getSubject().getNameID().getValue();
                String format = saml.getSubject().getNameID().getFormat();
                String qualifier = saml.getSubject().getNameID().getNameQualifier();
                String spID = saml.getSubject().getNameID().getSPProvidedID();
                String spQ = saml.getSubject().getNameID().getSPNameQualifier();
                samlToken.setPrincipal(name);
                SAMLNameID samlNameId = new SAMLNameID(name, format, qualifier, spQ, spID);
                samlToken.setSAMLNameID(samlNameId);
            }
            if (saml.getSubject().getSubjectConfirmation() != null && (subj = saml.getSubject().getSubjectConfirmation().getSubjectConfirmationData()) != null && (hok = subj.getKeyInfoAssertion()) != null && hok.getPrivateOrSharedKey() != null) {
                symmetricHok = true;
            }
        }
        List<StatementAbstract> statements = saml.getStatementOrAuthnStatementOrAuthzDecisionStatement();
        int length = statements.size();
        for (StatementAbstract obj : statements) {
            if (obj instanceof AttributeStatement) {
                AttributeStatement attState = (AttributeStatement)obj;
                ArrayList<Attribute> atts = attState.getAttributeOrEncryptedAttribute();
                Iterator<Attribute> it = atts.iterator();
                ArrayList<SAMLAttribute> samlAtts = new ArrayList<SAMLAttribute>();
                HashMap<String, String> simpleAtts = new HashMap<String, String>();
                while (it.hasNext()) {
                    int x;
                    Attribute att = it.next();
                    String name = att.getName();
                    int size = att.getAttributeValue().size();
                    List<Object> values = att.getAttributeValue();
                    String ns = att.getAttributeNamespace();
                    String format = att.getNameFormat();
                    String friend = att.getFriendlyName();
                    ArrayList<XMLStructure> xmlList = new ArrayList<XMLStructure>();
                    ArrayList<String> stringList = new ArrayList<String>();
                    for (Object obj2 : values) {
                        if (obj2 instanceof String) {
                            stringList.add((String)obj2);
                            continue;
                        }
                        if (!(obj2 instanceof XMLStructure)) continue;
                        xmlList.add((XMLStructure)obj2);
                    }
                    String[] stringAttributeValues = null;
                    XMLStructure[] xmlAttributeValues = null;
                    if (!stringList.isEmpty()) {
                        stringAttributeValues = new String[stringList.size()];
                        for (x = 0; x < stringAttributeValues.length; ++x) {
                            stringAttributeValues[x] = (String)stringList.get(x);
                        }
                    }
                    if (!xmlList.isEmpty()) {
                        xmlAttributeValues = new XMLStructure[xmlList.size()];
                        for (x = 0; x < xmlAttributeValues.length; ++x) {
                            xmlAttributeValues[x] = (XMLStructure)xmlList.get(x);
                        }
                    }
                    SAMLAttribute samlAtt = new SAMLAttribute(name, stringAttributeValues, xmlAttributeValues, ns, format, friend);
                    samlAtts.add(samlAtt);
                    if (size != 1 || SAMLTokenBuilder.hasValue(ns) || SAMLTokenBuilder.hasValue(format) || SAMLTokenBuilder.hasValue(friend) || !(values.get(0) instanceof String)) continue;
                    simpleAtts.put(name, (String)values.get(0));
                }
                samlToken.setSAMLAttributes(samlAtts);
                samlToken.setStringAttributes(simpleAtts);
                continue;
            }
            if (!(obj instanceof AuthnStatement)) continue;
            AuthnStatement authnSt = (AuthnStatement)obj;
            if (authnSt.getSubjectLocality() != null) {
                samlToken.setSubjectIPAddress(authnSt.getSubjectLocality().getAddress());
                samlToken.setSubjectDNS(authnSt.getSubjectLocality().getDNSName());
            }
            if (authnSt.getAuthnContext() == null) continue;
            samlToken.setAuthenticationMethod(authnSt.getAuthnContext().getAuthnContextClassRef());
            samlToken.setAuthenticationInstant(authnSt.getAuthnInstant());
        }
        if (saml.getConditions() != null) {
            Conditions con = saml.getConditions();
            samlToken.setSamlCreated(con.getNotBefore());
            samlToken.setSamlExpires(con.getNotOnOrAfter());
            if (con.getConditionOrAudienceRestrictionOrOneTimeUse() != null) {
                for (ConditionAbstract condition : con.getConditionOrAudienceRestrictionOrOneTimeUse()) {
                    if (!(condition instanceof AudienceRestriction)) continue;
                    List<String> audiences = ((AudienceRestriction)condition).getAudience();
                    samlToken.setAudienceRestriction(audiences);
                }
            }
        }
        if (saml.getHolderOfKey() != null) {
            if (symmetricHok) {
                byte[] entropy = saml.getHolderOfKey().getEncoded();
                samlToken.setHolderOfKeyBytes(entropy);
                Key key = KeyUtils.genertaeEncryptionKey(entropy, "AES");
                samlToken.setKey(62, key);
                samlToken.setKey(64, key);
                key = KeyUtils.genertaeSigningKey(entropy, null);
                samlToken.setKey(61, key);
                samlToken.setKey(63, key);
                samlToken.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey");
            } else {
                samlToken.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey");
                samlToken.setKey(63, saml.getHolderOfKey());
                samlToken.setKey(62, saml.getHolderOfKey());
            }
        } else {
            samlToken.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        }
        samlToken.setKeyIdentifier(saml.getSamlID());
        samlToken.setKeyIdentifierValueType(SAMLTokenImpl.saml20KeyIdentifierValueType);
        samlToken.setSamlID(saml.getSamlID());
        samlToken.setXML(new OMStructure(saml.getXML()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSAMLToken(SAMLAssertion)");
        }
        return samlToken;
    }

    public static SAML20TokenImpl createSAMLToken(Map rstrProperties, Map publicRSTRProperties, OMElement samlOM) throws SoapSecurityException {
        SAML20TokenImpl samlToken = SAMLTokenBuilder.createSAMLToken(rstrProperties, samlOM);
        if (publicRSTRProperties != null) {
            samlToken.setProperties(publicRSTRProperties);
        }
        return samlToken;
    }

    public static SAML20TokenImpl createSAMLToken(Map map, OMElement samlOM) throws SoapSecurityException {
        OMElement proofToken;
        SAML20TokenImpl samlToken;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createEncryptedSAMLToken(Map, OMElement)");
            }
            samlToken = (SAML20TokenImpl)_tokenFactory.getToken(true);
            if (!samlOM.getLocalName().equals("EncryptedData") && !samlOM.getLocalName().equals("EncryptedAssertion")) {
                SAMLAssertion newSAML = null;
                final OMElement samlXMLPriv = samlOM;
                try {
                    newSAML = (SAMLAssertion)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws SoapSecurityException {
                            return SAMLAssertionParser.parseSAML(samlXMLPriv);
                        }
                    });
                    samlToken = SAMLTokenBuilder.createSAMLToken(newSAML);
                }
                catch (PrivilegedActionException pae) {
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug(tc, "caught exception calling doPrivileged method: " + pae.getException().getMessage());
                }
            }
        }
        if ((proofToken = (OMElement)map.get("RequestedProofTokenXML")) != null) {
            OMElement sec2 = OMUtil.getFirstElement(proofToken);
            String sec1 = sec2.getText();
            byte[] entropy = Base64.decode(sec1);
            try {
                samlToken.setHolderOfKeyBytes(entropy);
                Key key = KeyUtils.genertaeEncryptionKey(entropy, "AES");
                samlToken.setKey(62, key);
                samlToken.setKey(64, key);
                key = KeyUtils.genertaeSigningKey(entropy, null);
                samlToken.setKey(61, key);
                samlToken.setKey(63, key);
                samlToken.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey");
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fail to extract proofKey from RSTR", e.getMessage());
                }
                throw new SoapSecurityException(e.getMessage());
            }
        } else {
            String keyType = (String)map.get("KeyType");
            if (keyType != null) {
                // empty if block
            }
        }
        samlToken.setXML(new OMStructure(samlOM));
        if (samlToken.getSamlCreated() == null) {
            Date created = (Date)map.get("LifetimeCreated");
            samlToken.setSamlCreated(created);
        }
        if (samlToken.getSamlExpires() == null) {
            Date expires = (Date)map.get("LifetimeExpires");
            samlToken.setSamlExpires(expires);
        }
        samlToken.setAssertionQName(SAMLObjectElement._saml2_ns_qname);
        String samlId = null;
        OMElement samlIDRef = (OMElement)map.get("RequestedUnattachedReferenceXML");
        if (samlIDRef == null) {
            samlIDRef = (OMElement)map.get("RequestedAttachedReferenceXML");
        }
        OMElement el = DOMUtils.getFirstElement(samlIDRef);
        while (el != null) {
            OMElement keyID;
            String ln = el.getLocalName();
            if ("SecurityTokenReference".equals(ln) && (keyID = DOMUtils.getFirstElement(el)) != null && "KeyIdentifier".equals(keyID.getLocalName())) {
                samlId = keyID.getText();
            }
            el = DOMUtils.getNextElement(el);
        }
        samlToken.setKeyIdentifier(samlId);
        samlToken.setKeyIdentifierValueType(SAMLTokenImpl.saml20KeyIdentifierValueType);
        samlToken.setSamlID(samlId);
        samlToken.setXML(new OMStructure(samlOM));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptedSAMLToken(Map, OMElement)");
        }
        return samlToken;
    }

    public static boolean hasValue(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasValue(" + value + ")");
        }
        if (value == null || value.isEmpty()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "hasValue(" + value + ") returning false");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasValue(" + value + ") returning true");
        }
        return true;
    }
}

