/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.utils;

import com.ibm.ws.wssecurity.saml.saml20.assertion.Assertion;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Subject;
import com.ibm.ws.wssecurity.saml.saml20.assertion.SubjectConfirmation;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.AssertionImpl;
import com.ibm.ws.wssecurity.saml.security.HoKAssertion;
import com.ibm.ws.wssecurity.saml.security.impl.HoKAssertionImpl;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import java.security.Key;
import org.apache.axiom.om.OMElement;

public class SAMLParser {
    private static final TraceComponent tc = Tr.register(SAMLParser.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SAMLParser.class.getName();

    public static Assertion parseSAML(OMElement aOM) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSAML(OMElement): " + (aOM == null ? null : ((Object)aOM).toString()));
        }
        Assertion as = SAMLParser.parseSAML(aOM, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSAML(OMElement)");
        }
        return as;
    }

    public static Assertion parseSAML(OMElement aOM, ConsumerConfig decryptingKeyStoreCfg) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSAML(OMElement aOM, ConsumerConfig): " + (aOM == null ? null : ((Object)aOM).toString()));
        }
        AssertionImpl as = new AssertionImpl(aOM, decryptingKeyStoreCfg);
        as.unMarshal(aOM);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSAML(OMElement aOM, ConsumerConfig)");
        }
        return as;
    }

    public static Key unMarshalHoKKey(Assertion saml, ConsumerConfig decryptingKeyStoreCfg) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unMarshalHoKKey(Assertion, ConsumerConfig)");
        }
        Key key = SAMLParser.getHoKAssertion(saml, decryptingKeyStoreCfg).getKey();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unMarshalHoKKey(Assertion, ConsumerConfig)");
        }
        return key;
    }

    public static HoKAssertion getHoKAssertion(Assertion saml, ConsumerConfig decryptingKeyStoreCfg) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHoKAssertion(Assertion, ConsumerConfig)");
        }
        HoKAssertionImpl keyInfoAss = new HoKAssertionImpl(decryptingKeyStoreCfg);
        OMElement aOM = SAMLParser.gethokElement(saml);
        keyInfoAss.unMarshal(aOM);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHoKAssertion(Assertion, ConsumerConfig)");
        }
        return keyInfoAss;
    }

    public static Key getKey(Assertion assertion, ConsumerConfig decryptingKeyStoreCfg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey(Assertion, ConsumerConfig)");
        }
        Assertion as = assertion;
        Subject sj = null;
        SubjectConfirmation sc = null;
        HoKAssertion kia = null;
        Key key = null;
        sj = as.getSubject();
        if (sj != null && (sc = sj.getSubjectConfirmation()) != null && (kia = sc.getSubjectConfirmationData().getKeyInfoAssertion()) != null) {
            key = kia.getKey();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey(Assertion, ConsumerConfig)");
        }
        return key;
    }

    private static OMElement gethokElement(Assertion assertion) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "gethokElement(Assertion)");
        }
        Assertion as = assertion;
        Subject sj = null;
        SubjectConfirmation sc = null;
        Object kia = null;
        OMElement keyInfo = null;
        sj = as.getSubject();
        if (sj != null && (sc = sj.getSubjectConfirmation()) != null) {
            keyInfo = sc.getSubjectConfirmationData().getKeyInfoElement();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "gethokElement(Assertion)");
        }
        return keyInfo;
    }
}

