/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.utils;

import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.AssertionModifierCallback;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.CallbackHandler;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.SamlCallbackHandlerLoader;
import com.ibm.ws.wssecurity.saml.common.SAMLAssertion;
import com.ibm.ws.wssecurity.saml.config.impl.SamlConfigUtil;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Assertion;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.AssertionImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.AttributeStatementImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.AuthnStatementImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.ConditionsImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.IssuerImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.SubjectImpl;
import com.ibm.ws.wssecurity.saml.security.impl.SamlSignatureUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import org.apache.axiom.om.OMElement;

public class SAMLBuilder {
    private static final TraceComponent tc = Tr.register(SAMLBuilder.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SAMLBuilder.class.getName();

    public static Assertion createUnsignedAssertion(ProviderConfig issueCfg, RequesterConfig requesterData, CredentialConfig cred) throws SoapSecurityException {
        boolean createArttibuteStatement;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createUnsignedAssertion(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        Assertion assertion = null;
        IssuerImpl issuer = null;
        ConditionsImpl conditions = null;
        SubjectImpl subj = null;
        assertion = new AssertionImpl(issueCfg, requesterData, cred);
        assertion.create();
        issuer = new IssuerImpl(issueCfg, requesterData, cred);
        issuer.create();
        assertion.setIssuer(issuer);
        conditions = new ConditionsImpl(issueCfg, requesterData, cred);
        conditions.create();
        assertion.setConditions(conditions);
        subj = new SubjectImpl(issueCfg, requesterData, cred);
        subj.create();
        assertion.setSubject(subj);
        boolean createAuthnStatement = SamlConfigUtil.createAuthnStatement(cred, requesterData, issueCfg);
        if (createAuthnStatement) {
            AuthnStatementImpl authnStatemn = new AuthnStatementImpl(issueCfg, requesterData, cred);
            authnStatemn.create();
            assertion.addStatement(authnStatemn);
        }
        if (createArttibuteStatement = SamlConfigUtil.createAttributeStatement(cred, requesterData, issueCfg)) {
            AttributeStatementImpl attrStatemn = new AttributeStatementImpl(issueCfg, requesterData, cred);
            attrStatemn.create();
            assertion.addStatement(attrStatemn);
        }
        if (issueCfg.getSamlModifier() != null && !issueCfg.getSamlModifier().isEmpty()) {
            AssertionModifierCallback acb = new AssertionModifierCallback(issueCfg, requesterData, cred, assertion);
            CallbackHandler handler = SamlCallbackHandlerLoader.getCallbackHandler(issueCfg.getSamlModifier());
            handler.handle(acb);
            assertion = (Assertion)acb.getAssertion();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createUnsignedAssertion(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        return assertion;
    }

    public static OMElement getSignedSAMLAssertion(ProviderConfig issue, RequesterConfig requesterData, SAMLAssertion unSignedAssertion) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignedSAMLAssertion(ProviderConfig, RequesterConfig, SAMLAssertion)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignedSAMLAssertion(ProviderConfig, RequesterConfig, SAMLAssertion)");
        }
        return SamlSignatureUtils.getSignedSAML(issue, requesterData, unSignedAssertion);
    }

    public static OMElement getSignedSAMLAssertion(ProviderConfig issue, RequesterConfig requesterData, OMElement unsignedSamlOm, String samlID) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignedSAMLAssertion(ProviderConfig, RequesterConfig, OMElement)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignedSAMLAssertion(ProviderConfig, RequesterConfig, OMElement)");
        }
        return SamlSignatureUtils.getSignedSAML(issue, requesterData, unsignedSamlOm, samlID);
    }

    public static Assertion createSignedAssertion(ProviderConfig issue, RequesterConfig requesterData, CredentialConfig cred) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSignedAssertion(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        Assertion unSignedAssertion = SAMLBuilder.createUnsignedAssertion(issue, requesterData, cred);
        OMElement om = SamlSignatureUtils.getSignedSAML(issue, requesterData, unSignedAssertion);
        if (unSignedAssertion instanceof AssertionImpl) {
            ((AssertionImpl)unSignedAssertion).setXML(om);
            ((AssertionImpl)unSignedAssertion).setSigned();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSignedAssertion(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        return unSignedAssertion;
    }
}

