/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.impl;

import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.CallbackHandler;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.NameIDCallback;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.SamlCallbackHandlerLoader;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml20.assertion.NameID;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Subject;
import com.ibm.ws.wssecurity.saml.saml20.assertion.SubjectConfirmation;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.NameIDImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.SubjectConfirmationImpl;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import com.ibm.wsspi.wssecurity.saml.data.SAMLNameID;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class SubjectImpl
implements Subject {
    private static final TraceComponent tc = Tr.register(SubjectImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SubjectImpl.class.getName();
    private ProviderConfig issueCfg = null;
    private RequesterConfig requesterData = null;
    private CredentialConfig cred = null;
    private NameID nameId = null;
    private SubjectConfirmation subConfirm = null;
    private ConsumerConfig assertionConsumingCfg = null;
    protected List content;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public SubjectImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SubjectImpl()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SubjectImpl()");
        }
    }

    public SubjectImpl(ConsumerConfig cfg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SubjectImpl(ConsumerConfig)");
        }
        this.assertionConsumingCfg = cfg;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SubjectImpl(ConsumerConfig)");
        }
    }

    public SubjectImpl(ProviderConfig issueCfg, RequesterConfig requestData, CredentialConfig cred) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SubjectImpl(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        this.issueCfg = issueCfg;
        this.requesterData = requestData;
        this.cred = cred;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SubjectImpl(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
    }

    private NameID createSimpleSubjectNameID(ProviderConfig issueCfg, RequesterConfig requestData, CredentialConfig cred) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSimpleSubjectNameID(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        NameIDImpl nId = new NameIDImpl();
        if (this.issueCfg.getNameIDProvider() != null && !this.issueCfg.getNameIDProvider().isEmpty()) {
            NameIDCallback idCallback = new NameIDCallback(this.issueCfg, this.requesterData, this.cred);
            CallbackHandler handler = SamlCallbackHandlerLoader.getCallbackHandler(this.issueCfg.getNameIDProvider());
            handler.handle(idCallback);
            SAMLNameID nameID = idCallback.getSAMLNameID();
            if (nameID != null) {
                nId.setFormat(nameID.getFormat());
                nId.setNameQualifier(nameID.getNameQualifier());
                nId.setValue(nameID.getValue());
                nId.setSPNameQualifier(nameID.getSPNameQualifier());
                nId.setSPProvidedID(nameID.getSPProvidedID());
            }
        } else if (cred.getSAMLNameID() != null && cred.getSAMLNameID().getValue() != null) {
            nId.setFormat(cred.getSAMLNameID().getFormat());
            nId.setNameQualifier(cred.getSAMLNameID().getNameQualifier());
            nId.setValue(cred.getSAMLNameID().getValue());
            nId.setSPNameQualifier(cred.getSAMLNameID().getSPNameQualifier());
            nId.setSPProvidedID(cred.getSAMLNameID().getSPProvidedID());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSimpleSubjectNameID(ProviderConfig, RequesterConfig, CredentialConfig): " + nId);
        }
        return nId;
    }

    @Override
    public NameID getNameID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNameID()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNameID(): " + this.nameId);
        }
        return this.nameId;
    }

    @Override
    public void setNameID(NameID id) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNameID(" + id + ")");
        }
        this.nameId = id;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNameID(" + id + ")");
        }
    }

    @Override
    public SubjectConfirmation getSubjectConfirmation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectConfirmation()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectConfirmation()");
        }
        return this.subConfirm;
    }

    @Override
    public List getContent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContent()");
        }
        if (this.content == null) {
            this.content = new ArrayList();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContent()");
        }
        return this.content;
    }

    @Override
    public OMElement getXML() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXML()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXML()");
        }
        return null;
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        OMElement scOm;
        OMElement idOm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshal(OMElement parent): " + (parent == null ? null : ((Object)parent).toString()));
        }
        OMElement subj = null;
        if (parent == null) {
            subj = omFactory.createOMElement("Subject", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
            subj.declareNamespace(SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
        } else {
            subj = parent.getOMFactory().createOMElement("Subject", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
        }
        if (this.nameId != null && (idOm = this.nameId.marshal(subj)) != null) {
            subj.addChild(idOm);
        }
        if (this.subConfirm != null && (scOm = this.subConfirm.marshal(subj)) != null) {
            subj.addChild(scOm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshal(OMElement parent): " + (subj == null ? null : ((Object)subj).toString()));
        }
        return subj;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unMarshal (OMElement om): " + (om == null ? null : ((Object)om).toString()));
        }
        OMElement el = OMUtil.getFirstElement(om);
        while (el != null) {
            String ns;
            String ln = el.getLocalName();
            String string = ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
            if ("NameID".equals(ln)) {
                this.nameId = new NameIDImpl();
                this.nameId.unMarshal(el);
            } else if ("SubjectConfirmation".equals(el.getLocalName())) {
                this.subConfirm = new SubjectConfirmationImpl(this.assertionConsumingCfg);
                this.subConfirm.unMarshal(el);
            }
            el = OMUtil.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unMarshal (OMElement om)");
        }
    }

    @Override
    public void create() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create()");
        }
        this.subConfirm = new SubjectConfirmationImpl(this.issueCfg, this.requesterData, this.cred);
        this.subConfirm.create();
        this.nameId = this.createSimpleSubjectNameID(this.issueCfg, this.requesterData, this.cred);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create()");
        }
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        if (this.nameId != null && !this.nameId.validate()) {
            return false;
        }
        if (this.subConfirm != null && !this.subConfirm.validate()) {
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        return true;
    }
}

