/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.impl;

import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.config.impl.SamlConfigUtil;
import com.ibm.ws.wssecurity.saml.saml20.assertion.BaseIDAbstract;
import com.ibm.ws.wssecurity.saml.saml20.assertion.NameID;
import com.ibm.ws.wssecurity.saml.saml20.assertion.SubjectConfirmation;
import com.ibm.ws.wssecurity.saml.saml20.assertion.SubjectConfirmationData;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.SubjectConfirmationDataImpl;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class SubjectConfirmationImpl
implements SubjectConfirmation {
    private static final TraceComponent tc = Tr.register(SubjectConfirmationImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SubjectConfirmationImpl.class.getName();
    private BaseIDAbstract baseID;
    private NameID nameID;
    private SubjectConfirmationData subjectConfirmationData;
    private String method;
    private ProviderConfig issueCfg = null;
    private RequesterConfig reqData = null;
    private CredentialConfig cred = null;
    private ConsumerConfig assertionConsumingCfg = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public SubjectConfirmationImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SubjectConfirmationImpl()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SubjectConfirmationImpl()");
        }
    }

    public SubjectConfirmationImpl(ConsumerConfig storeCfg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SubjectConfirmationImpl(ConsumerConfig)");
        }
        this.assertionConsumingCfg = storeCfg;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SubjectConfirmationImpl(ConsumerConfig)");
        }
    }

    public SubjectConfirmationImpl(ProviderConfig conf, RequesterConfig reqData, CredentialConfig cred) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SubjectConfirmationImpl(ConsumerConfig, RequesterConfig, CredentialConfig)");
        }
        this.issueCfg = conf;
        this.reqData = reqData;
        this.cred = cred;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SubjectConfirmationImpl(ConsumerConfig, RequesterConfig, CredentialConfig)");
        }
    }

    @Override
    public BaseIDAbstract getBaseID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBaseID()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBaseID()");
        }
        return this.baseID;
    }

    @Override
    public void setBaseID(BaseIDAbstract value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setBaseID(BaseIDAbstract value)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setBaseID(BaseIDAbstract value)");
        }
        this.baseID = value;
    }

    @Override
    public NameID getNameID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNameID()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNameID(): " + this.nameID);
        }
        return this.nameID;
    }

    @Override
    public void setNameID(NameID value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNameID(" + value + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNameID(" + value + ")");
        }
        this.nameID = value;
    }

    @Override
    public SubjectConfirmationData getSubjectConfirmationData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectConfirmationData()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectConfirmationData()");
        }
        return this.subjectConfirmationData;
    }

    @Override
    public void setSubjectConfirmationData(SubjectConfirmationData value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSubjectConfirmationData(SubjectConfirmationData value)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSubjectConfirmationData(SubjectConfirmationData value)");
        }
        this.subjectConfirmationData = value;
    }

    @Override
    public String getMethod() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMethod()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMethod(): " + this.method);
        }
        return this.method;
    }

    @Override
    public void setMethod(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMethod(" + value + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMethod(" + value + ")");
        }
        this.method = value;
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXML()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXML()");
        }
        return null;
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        OMElement idOm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshal(OMElement parent): " + (parent == null ? null : ((Object)parent).toString()));
        }
        OMElement subj = null;
        if (parent != null) {
            subj = omFactory.createOMElement("SubjectConfirmation", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
            subj.declareNamespace(SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
        } else {
            subj = parent.getOMFactory().createOMElement("SubjectConfirmation", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
        }
        subj.addAttribute("Method", this.method, null);
        if (this.subjectConfirmationData != null && (idOm = this.subjectConfirmationData.marshal(subj)) != null) {
            subj.addChild(idOm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshal(OMElement parent): " + (subj == null ? null : ((Object)subj).toString()));
        }
        return subj;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unMarshal (OMElement om): " + (om == null ? null : ((Object)om).toString()));
        }
        QName QAttr = new QName(null, "Method");
        this.method = om.getAttributeValue(QAttr);
        OMElement el = OMUtil.getFirstElement(om);
        if (el != null && "SubjectConfirmationData".equals(el.getLocalName())) {
            this.subjectConfirmationData = new SubjectConfirmationDataImpl(this.assertionConsumingCfg);
            this.subjectConfirmationData.unMarshal(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unMarshal (OMElement om)");
        }
    }

    @Override
    public void create() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create()");
        }
        this.method = SamlConfigUtil.getConfirmationMethod(this.reqData, this.issueCfg);
        if ("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(this.method)) {
            this.subjectConfirmationData = new SubjectConfirmationDataImpl(this.issueCfg, this.reqData, this.cred);
            this.subjectConfirmationData.create();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create()");
        }
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        if (this.method == null || this.method.isEmpty()) {
            return false;
        }
        if (this.subjectConfirmationData != null && !this.subjectConfirmationData.validate()) {
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate()");
        }
        return true;
    }
}

