/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.impl;

import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml20.assertion.SubjectConfirmationData;
import com.ibm.ws.wssecurity.saml.security.HoKAssertion;
import com.ibm.ws.wssecurity.saml.security.impl.HoKAssertionImpl;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class SubjectConfirmationDataImpl
implements SubjectConfirmationData {
    private static final TraceComponent tc = Tr.register(SubjectConfirmationDataImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SubjectConfirmationDataImpl.class.getName();
    protected List<Object> content;
    protected Date notBefore;
    protected Date notOnOrAfter;
    protected String recipient;
    protected String inResponseTo;
    protected String address;
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();
    private HoKAssertion keyInfoAssertion = null;
    private OMElement keyInfoElm = null;
    private ProviderConfig issueCfg = null;
    private RequesterConfig reqData = null;
    private CredentialConfig cred = null;
    private OMElement xml;
    private ConsumerConfig assertionConfigCfg = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public SubjectConfirmationDataImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SubjectConfirmationDataImpl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SubjectConfirmationDataImpl");
        }
    }

    public SubjectConfirmationDataImpl(ConsumerConfig ksCfg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SubjectConfirmationDataImpl(ConsumerConfig)");
        }
        this.assertionConfigCfg = ksCfg;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SubjectConfirmationDataImpl(ConsumerConfig)");
        }
    }

    public SubjectConfirmationDataImpl(ProviderConfig cfg, RequesterConfig data, CredentialConfig cred) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SubjectConfirmationDataImpl(ConsumerConfig, RequesterConfig, CredentialConfig)");
        }
        this.issueCfg = cfg;
        this.reqData = data;
        this.cred = cred;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SubjectConfirmationDataImpl(ConsumerConfig, RequesterConfig, CredentialConfig)");
        }
    }

    @Override
    public List<Object> getContent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContent()");
        }
        if (this.content == null) {
            this.content = new ArrayList<Object>();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContent()");
        }
        return this.content;
    }

    @Override
    public Date getNotBefore() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNotBefore()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNotBefore(): " + (this.notBefore == null ? null : this.notBefore.toString()));
        }
        return this.notBefore;
    }

    @Override
    public void setNotBefore(Date value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNotBefore(): " + (value == null ? null : value.toString()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNotBefore(): " + (value == null ? null : value.toString()));
        }
        this.notBefore = value;
    }

    @Override
    public Date getNotOnOrAfter() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNotOnOrAfter()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNotOnOrAfter(): " + (this.notOnOrAfter == null ? null : this.notOnOrAfter.toString()));
        }
        return this.notOnOrAfter;
    }

    @Override
    public void setNotOnOrAfter(Date value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNotOnOrAfter(): " + (value == null ? null : value.toString()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNotOnOrAfter(): " + (value == null ? null : value.toString()));
        }
        this.notOnOrAfter = value;
    }

    @Override
    public String getRecipient() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecipient()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecipient(): " + this.recipient);
        }
        return this.recipient;
    }

    @Override
    public void setRecipient(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRecipient(): " + value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRecipient(): " + value);
        }
        this.recipient = value;
    }

    @Override
    public String getInResponseTo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInResponseTo()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInResponseTo(): " + this.inResponseTo);
        }
        return this.inResponseTo;
    }

    @Override
    public void setInResponseTo(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInResponseTo(" + value + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInResponseTo(" + value + ")");
        }
        this.inResponseTo = value;
    }

    @Override
    public String getAddress() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAddress()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAddress(): " + this.address);
        }
        return this.address;
    }

    @Override
    public void setAddress(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAddress(" + value + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAddress(" + value + ")");
        }
        this.address = value;
    }

    @Override
    public Map<QName, String> getOtherAttributes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOtherAttributes()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOtherAttributes()");
        }
        return this.otherAttributes;
    }

    @Override
    public HoKAssertion getKeyInfoAssertion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfoAssertion()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInfoAssertion()");
        }
        return this.keyInfoAssertion;
    }

    @Override
    public void setKeyInfoAssertion(HoKAssertion keyInfoassertion) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyInfoAssertion()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeyInfoAssertion()");
        }
        this.keyInfoAssertion = keyInfoassertion;
    }

    @Override
    public OMElement getKeyInfoElement() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfoElement()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInfoElement()");
        }
        return this.keyInfoElm;
    }

    @Override
    public void setKeyInfoElement(OMElement keyInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyInfoElement()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeyInfoElement()");
        }
        this.keyInfoElm = keyInfo;
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXML()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXML()");
        }
        return null;
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshal(OMElement parent): " + (parent == null ? null : ((Object)parent).toString()));
        }
        if (this.xml != null) {
            return this.xml;
        }
        if (this.notBefore == null && this.notOnOrAfter == null && this.address == null && this.inResponseTo == null && this.recipient == null && this.keyInfoAssertion == null && this.keyInfoElm == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "marshal(OMElement parent): returning null");
            }
            return null;
        }
        if (parent == null) {
            this.xml = omFactory.createOMElement("SubjectConfirmationData", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
            this.xml.declareNamespace(SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
        } else {
            this.xml = parent.getOMFactory().createOMElement("SubjectConfirmationData", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
        }
        if (this.notBefore != null) {
            this.xml.addAttribute("NotBefore", UTC.format(this.notBefore), null);
        }
        if (this.notOnOrAfter != null) {
            this.xml.addAttribute("NotOnOrAfter", UTC.format(this.notOnOrAfter), null);
        }
        if (this.address != null) {
            this.xml.addAttribute("Address", this.address, null);
        }
        if (this.inResponseTo != null) {
            this.xml.addAttribute("InResponseTo", this.inResponseTo, null);
        }
        if (this.recipient != null) {
            this.xml.addAttribute("Recipient", this.recipient, null);
        }
        if (this.keyInfoAssertion != null) {
            OMElement kiOm = this.keyInfoAssertion.marshal(this.xml);
            if (kiOm != null) {
                this.xml.addChild(kiOm);
            }
        } else if (this.keyInfoElm != null) {
            this.xml.addChild(this.keyInfoElm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshal(OMElement parent): " + (this.xml == null ? null : ((Object)this.xml).toString()));
        }
        return this.xml;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        QName QAttr;
        String date;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unMarshal(OMElement om): " + (om == null ? null : ((Object)om).toString()));
        }
        if ((date = om.getAttributeValue(QAttr = new QName(null, "NotBefore"))) != null) {
            try {
                this.notBefore = UTC.parse(date);
            }
            catch (Exception e) {
                throw new SoapSecurityException(e.getMessage(), e.getCause());
            }
        }
        if ((date = om.getAttributeValue(QAttr = new QName(null, "NotOnOrAfter"))) != null) {
            try {
                this.notOnOrAfter = UTC.parse(date);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        QAttr = new QName(null, "InResponseTo");
        this.inResponseTo = om.getAttributeValue(QAttr);
        QAttr = new QName(null, "Recipient");
        this.recipient = om.getAttributeValue(QAttr);
        OMElement el = OMUtil.getFirstElement(om);
        while (el != null) {
            String ln = el.getLocalName();
            if ("KeyInfo".equalsIgnoreCase(ln)) {
                this.keyInfoElm = el;
                this.keyInfoAssertion = new HoKAssertionImpl(this.assertionConfigCfg);
                this.keyInfoAssertion.unMarshal(el);
            }
            el = OMUtil.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unMarshal(OMElement om)");
        }
    }

    @Override
    public void create() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create()");
        }
        this.keyInfoAssertion = new HoKAssertionImpl(this.issueCfg, this.reqData, this.cred);
        this.keyInfoAssertion.create();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create()");
        }
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate()");
        }
        return true;
    }
}

