/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.impl;

import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.MessageHelper;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml20.assertion.ConditionAbstract;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Conditions;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.AudienceRestrictionImpl;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class ConditionsImpl
implements Conditions {
    private static final TraceComponent tc = Tr.register(ConditionsImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = ConditionsImpl.class.getName();
    private ArrayList<ConditionAbstract> conditionOrAudienceRestrictionOrOneTimeUse = new ArrayList();
    private Date notBefore;
    private Date notOnOrAfter;
    private ProviderConfig issueCfg = null;
    private RequesterConfig requesterData = null;
    private CredentialConfig cred = null;
    private OMElement xml = null;
    private ConsumerConfig assertionConsumingCfg = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public ConditionsImpl(ConsumerConfig consumer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConditionsImpl()");
        }
        this.assertionConsumingCfg = consumer;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConditionsImpl()");
        }
    }

    public ConditionsImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConditionsImpl()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConditionsImpl()");
        }
    }

    public ConditionsImpl(ProviderConfig issueCfg, RequesterConfig requestData, CredentialConfig cred) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConditionsImpl(ProviderConfig, RequesterConfig , CredentialConfig)");
        }
        this.issueCfg = issueCfg;
        this.requesterData = requestData;
        this.cred = cred;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConditionsImpl(ProviderConfig, RequesterConfig , CredentialConfig)");
        }
    }

    @Override
    public List<ConditionAbstract> getConditionOrAudienceRestrictionOrOneTimeUse() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConditionOrAudienceRestrictionOrOneTimeUse()");
        }
        if (this.conditionOrAudienceRestrictionOrOneTimeUse == null) {
            this.conditionOrAudienceRestrictionOrOneTimeUse = new ArrayList();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConditionOrAudienceRestrictionOrOneTimeUse()");
        }
        return this.conditionOrAudienceRestrictionOrOneTimeUse;
    }

    @Override
    public Date getNotBefore() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNotBefore()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNotBefore(): " + (this.notBefore == null ? null : this.notBefore.toString()));
        }
        return this.notBefore;
    }

    @Override
    public void setNotBefore(Date value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNotBefore(Date value): " + (value == null ? null : value.toString()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNotBefore(Date value)");
        }
        this.notBefore = value;
    }

    @Override
    public Date getNotOnOrAfter() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNotOnOrAfter()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNotOnOrAfter: " + (this.notOnOrAfter == null ? null : this.notOnOrAfter.toString()));
        }
        return this.notOnOrAfter;
    }

    @Override
    public void setNotOnOrAfter(Date value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNotOnOrAfter(Date value): " + (value == null ? null : value.toString()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNotBefore(Date value)");
        }
        this.notOnOrAfter = value;
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXML()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXML(): " + (this.xml == null ? null : ((Object)this.xml).toString()));
        }
        return this.xml;
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshal(OMElement parent): " + (parent == null ? null : ((Object)parent).toString()));
        }
        OMElement cond = null;
        if (parent == null) {
            cond = omFactory.createOMElement("Conditions", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
            cond.declareNamespace(SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
        } else {
            cond = parent.getOMFactory().createOMElement("Conditions", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
        }
        cond.addAttribute("NotBefore", UTC.format(this.notBefore), null);
        cond.addAttribute("NotOnOrAfter", UTC.format(this.notOnOrAfter), null);
        if (!this.getConditionOrAudienceRestrictionOrOneTimeUse().isEmpty()) {
            for (ConditionAbstract obj : this.getConditionOrAudienceRestrictionOrOneTimeUse()) {
                OMElement om2 = obj.marshal(cond);
                cond.addChild(om2);
            }
        }
        this.xml = cond;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshal(OMElement parent): " + (cond == null ? null : ((Object)cond).toString()));
        }
        return cond;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unMarshal (OMElement om): " + (om == null ? null : ((Object)om).toString()));
        }
        this.xml = om;
        QName QAttr = new QName(null, "NotBefore");
        String date = om.getAttributeValue(QAttr);
        try {
            this.notBefore = UTC.parse(date);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        QAttr = new QName(null, "NotOnOrAfter");
        date = om.getAttributeValue(QAttr);
        try {
            this.notOnOrAfter = UTC.parse(date);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        OMElement el = OMUtil.getFirstElement(om);
        while (el != null) {
            String ln = el.getLocalName();
            if ("AudienceRestrictionCondition".equals(ln)) {
                AudienceRestrictionImpl adudience = new AudienceRestrictionImpl();
                adudience.unMarshal(el);
                this.getConditionOrAudienceRestrictionOrOneTimeUse().add(adudience);
            } else {
                if ("OneTimeUse".equals(ln)) {
                    throw new SoapSecurityException(MessageHelper.getMessage("security.wssecurity.WSSML0000E"));
                }
                if ("ProxyRestriction".equals(ln)) {
                    throw new SoapSecurityException(MessageHelper.getMessage("security.wssecurity.WSSML0000E"));
                }
            }
            el = OMUtil.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unMarshal (OMElement om)");
        }
    }

    @Override
    public void create() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create()");
        }
        this.notBefore = new Date();
        this.notOnOrAfter = new Date(this.notBefore.getTime() + this.issueCfg.getTimeToLive());
        String appliesTo = this.requesterData.getRSTTProperties().get("wstrustClientAppliesToAddress");
        if (appliesTo != null && !appliesTo.isEmpty()) {
            AudienceRestrictionImpl audience = new AudienceRestrictionImpl(this.issueCfg, this.requesterData, this.cred);
            audience.create();
            this.getConditionOrAudienceRestrictionOrOneTimeUse().add(audience);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create()");
        }
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        long time;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        long clockskew = 180000L;
        if (this.assertionConsumingCfg != null) {
            clockskew = this.assertionConsumingCfg.getClockSkew();
        }
        if ((time = clockskew + new Date().getTime()) < this.notBefore.getTime()) {
            return false;
        }
        time = new Date().getTime() - clockskew;
        if (time > this.notOnOrAfter.getTime()) {
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate()");
        }
        return true;
    }
}

