/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.impl;

import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.MessageHelper;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.common.util.UUIDGenerator;
import com.ibm.ws.wssecurity.saml.saml20.assertion.AuthnContext;
import com.ibm.ws.wssecurity.saml.saml20.assertion.AuthnStatement;
import com.ibm.ws.wssecurity.saml.saml20.assertion.SubjectLocality;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.AuthnContextImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.StatementAbstractImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.SubjectLocalityImpl;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class AuthnStatementImpl
extends StatementAbstractImpl
implements AuthnStatement {
    private static final TraceComponent tc = Tr.register(AuthnStatementImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = AuthnStatementImpl.class.getName();
    private SubjectLocality subjectLocality;
    private AuthnContext authnContext;
    private Date authnInstant;
    private String authnInstantUTC = null;
    private String sessionIndex;
    private Date sessionNotOnOrAfter;
    private OMElement xml = null;
    private ProviderConfig issueCfg;
    private RequesterConfig requestData;
    private CredentialConfig cred = null;
    private ConsumerConfig assertionConsumingCfg = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public AuthnStatementImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthnStatementImpl()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthnStatementImpl()");
        }
    }

    public AuthnStatementImpl(ConsumerConfig consumer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthnStatementImpl()");
        }
        this.assertionConsumingCfg = consumer;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthnStatementImpl()");
        }
    }

    public AuthnStatementImpl(ProviderConfig cfg, RequesterConfig requestData, CredentialConfig cred) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthnStatementImpl(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        this.issueCfg = cfg;
        this.requestData = requestData;
        this.cred = cred;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthnStatementImpl(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
    }

    private AuthnContext createAuthnContext(ProviderConfig cfg, RequesterConfig requestData, CredentialConfig cred) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthnContext(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        AuthnContextImpl authnCtx = new AuthnContextImpl(cfg, requestData, cred);
        authnCtx.createAuthnContext();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAuthnContext(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        return authnCtx;
    }

    @Override
    public SubjectLocality getSubjectLocality() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectLocality()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectLocality()");
        }
        return this.subjectLocality;
    }

    @Override
    public void setSubjectLocality(SubjectLocality value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSubjectLocality");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSubjectLocality");
        }
        this.subjectLocality = value;
    }

    @Override
    public AuthnContext getAuthnContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthnContext()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthnContext()");
        }
        return this.authnContext;
    }

    @Override
    public void setAuthnContext(AuthnContext value) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAuthnContext(AuthnContext value):" + (value == null ? null : value.getAuthnContextClassRef()));
        }
        if (value == null) {
            throw new SoapSecurityException(MessageHelper.getMessage("security.wssecurity.WSSML6008E"));
        }
        this.authnContext = value;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAuthnContext");
        }
    }

    @Override
    public Date getAuthnInstant() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthnInstant()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthnInstant()");
        }
        return this.authnInstant;
    }

    @Override
    public void setAuthnInstant(Date value) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAuthnInstant(" + value.toString() + ")");
        }
        if (value == null) {
            throw new SoapSecurityException(MessageHelper.getMessage("security.wssecurity.WSSML6009E"));
        }
        this.authnInstant = value;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAuthnInstant(Date date)");
        }
    }

    @Override
    public String getSessionIndex() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSessionIndex()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessionIndex()");
        }
        return this.sessionIndex;
    }

    @Override
    public void setSessionIndex(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSessionIndex(" + value + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSessionIndex(" + value + ")");
        }
        this.sessionIndex = value;
    }

    @Override
    public Date getSessionNotOnOrAfter() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSessionNotOnOrAfter()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessionNotOnOrAfter(): " + (this.sessionNotOnOrAfter == null ? null : this.sessionNotOnOrAfter.toString()));
        }
        return this.sessionNotOnOrAfter;
    }

    @Override
    public void setSessionNotOnOrAfter(Date value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSessionNotOnOrAfter(Date value): " + (value == null ? null : value.toString()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSessionNotOnOrAfter(Date value): " + (value == null ? null : value.toString()));
        }
        this.sessionNotOnOrAfter = value;
    }

    @Override
    public QName getQName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQName()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQName(): " + (AuthnStatement.qName == null ? null : AuthnStatement.qName.toString()));
        }
        return AuthnStatement.qName;
    }

    @Override
    public String getLocalName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalName()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalName(): AuthnStatement");
        }
        return "AuthnStatement";
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXML()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXML()");
        }
        return null;
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshal(OMElement parent): " + (parent == null ? null : ((Object)parent).toString()));
        }
        if (this.authnContext.getAuthnContextClassRef() == null) {
            return null;
        }
        OMElement om = null;
        OMElement subj = null;
        try {
            if (parent == null) {
                subj = omFactory.createOMElement("AuthnStatement", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
                subj.declareNamespace(SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
            } else {
                subj = parent.getOMFactory().createOMElement("AuthnStatement", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
            }
            subj.addAttribute("AuthnInstant", this.authnInstantUTC, null);
            if (this.sessionIndex != null && this.sessionIndex.length() > 0) {
                subj.addAttribute("SessionIndex", this.sessionIndex, null);
            }
            if ((om = this.authnContext.marshal(subj)) != null) {
                subj.addChild(om);
            }
            if (this.subjectLocality != null) {
                OMElement subjElm = this.subjectLocality.marshal(subj);
                subj.addChild(subjElm);
            }
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        this.xml = subj;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshal(OMElement parent): " + (subj == null ? null : ((Object)subj).toString()));
        }
        return subj;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshal(OMElement parent): " + (om == null ? null : ((Object)om).toString()));
        }
        this.xml = om;
        QName QAttr = new QName(null, "AuthnInstant");
        this.authnInstantUTC = om.getAttributeValue(QAttr);
        if (this.authnInstantUTC != null) {
            try {
                this.authnInstant = UTC.parse(this.authnInstantUTC);
            }
            catch (Exception e) {
                throw new SoapSecurityException(e.getMessage(), e.getCause());
            }
        }
        OMElement el = OMUtil.getFirstElement(om);
        while (el != null) {
            String ln = el.getLocalName();
            if ("AuthnContext".equals(ln)) {
                this.authnContext = new AuthnContextImpl();
                this.authnContext.unMarshal(el);
            } else if ("SubjectLocality".equals(ln)) {
                this.subjectLocality = new SubjectLocalityImpl();
                this.subjectLocality.unMarshal(el);
            }
            el = OMUtil.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshal(OMElement parent): " + (om == null ? null : ((Object)om).toString()));
        }
    }

    @Override
    public void create() throws SoapSecurityException {
        Date date;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create()");
        }
        this.authnInstant = new Date();
        if (this.cred != null && this.cred.getProperties() != null && (date = (Date)this.cred.getProperties().get("AuthenticationInstant")) != null) {
            this.authnInstant = date;
        }
        this.authnInstantUTC = UTC.format(this.authnInstant);
        if (this.requestData.isSessionIndexEnabled()) {
            this.sessionIndex = UUIDGenerator.generateUUID();
        }
        if (this.requestData.getRequesterIPAddress() != null && !this.requestData.getRequesterIPAddress().isEmpty()) {
            this.subjectLocality = new SubjectLocalityImpl(this.issueCfg, this.requestData, this.cred);
            this.subjectLocality.create();
        }
        this.authnContext = this.createAuthnContext(this.issueCfg, this.requestData, this.cred);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create()");
        }
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        long time;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        if (this.authnInstant == null) {
            return false;
        }
        long clockskew = 180000L;
        if (this.assertionConsumingCfg != null) {
            clockskew = this.assertionConsumingCfg.getClockSkew();
        }
        if ((time = clockskew + new Date().getTime()) < this.authnInstant.getTime()) {
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate()");
        }
        return true;
    }

    @Override
    public boolean isSupported() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSupported()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSupported(): " + new Boolean(true).toString());
        }
        return true;
    }
}

