/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.impl;

import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.MessageHelper;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml20.assertion.AuthnContext;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class AuthnContextImpl
implements AuthnContext {
    private static final TraceComponent tc = Tr.register(AuthnContextImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = AuthnContextImpl.class.getName();
    private List content;
    private String authnContextClassRef;
    private String authnContextDecl;
    private String authnContextDeclRef;
    private ProviderConfig issueCfg;
    private RequesterConfig requestData;
    private CredentialConfig cred = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public AuthnContextImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthnContextImpl()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthnContextImpl()");
        }
    }

    public AuthnContextImpl(ProviderConfig cfg, RequesterConfig requestData, CredentialConfig cred) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthnContextImpl(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        this.issueCfg = cfg;
        this.requestData = requestData;
        this.cred = cred;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthnContextImpl(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
    }

    @Override
    public void createAuthnContext() {
        String amethod;
        String newMethod;
        String method;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthnContext()");
        }
        if ((method = this.requestData.getAuthenticationMethod()) != null && method.length() > 0 && (newMethod = ValidAuthnMethod.authnMap.get(method)) != null && newMethod.length() > 0) {
            this.authnContextClassRef = newMethod;
        }
        if (this.authnContextClassRef == null && this.cred != null && this.cred.getProperties() != null && (amethod = (String)this.cred.getProperties().get("AuthenticationMethod")) != null && !amethod.isEmpty()) {
            this.authnContextClassRef = amethod;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAuthnContext()");
        }
    }

    public List getContent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContent()");
        }
        if (this.content == null) {
            this.content = new ArrayList();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContent()");
        }
        return this.content;
    }

    @Override
    public OMElement marshal(OMElement parent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshal(OMElement parent): " + (parent == null ? null : ((Object)parent).toString()));
        }
        if (this.authnContextClassRef == null && this.authnContextClassRef.length() == 0) {
            return null;
        }
        OMElement om = null;
        if (parent == null) {
            om = omFactory.createOMElement("AuthnContext", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
            om.declareNamespace(SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
        } else {
            om = parent.getOMFactory().createOMElement("AuthnContext", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
        }
        OMElement om1 = om.getOMFactory().createOMElement("AuthnContextClassRef", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
        om1.setText(this.authnContextClassRef);
        om.addChild(om1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshal(OMElement parent): " + (om == null ? null : ((Object)om).toString()));
        }
        return om;
    }

    @Override
    public void unMarshal(OMElement om) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unMarshal(OMElement parent): " + (om == null ? null : ((Object)om).toString()));
        }
        OMElement el = OMUtil.getFirstElement(om);
        while (el != null) {
            String ln = el.getLocalName();
            if ("AuthnContextClassRef".equals(ln)) {
                this.authnContextClassRef = el.getText();
            }
            el = OMUtil.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unMarshal(OMElement parent): ");
        }
    }

    @Override
    public String getAuthnContextClassRef() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthnContextClassRef()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthnContextClassRef()");
        }
        return this.authnContextClassRef;
    }

    @Override
    public String getAuthnContextDecl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthnContextDecl()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthnContextDecl()");
        }
        return this.authnContextDecl;
    }

    @Override
    public String getAuthnContextDeclRef() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthnContextDeclRef()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthnContextDeclRef()");
        }
        return this.authnContextDeclRef;
    }

    public void setAuthnContextClassRef(String ref) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAuthnContextClassRef(" + ref + ")");
        }
        if (ref == null || ref.isEmpty() || ValidAuthnMethod.authnMap.get(ref) == null) {
            throw new SoapSecurityException(MessageHelper.getMessage("security.wssecurity.WSSML6007E"));
        }
        this.authnContextClassRef = ref;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAuthnContextClassRef(" + ref + ")");
        }
    }

    public void setAuthnContextDecl(String decl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAuthnContextDecl(" + decl + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAuthnContextDecl(" + decl + ")");
        }
        this.authnContextDecl = decl;
    }

    public void setAuthnContextDeclRef(String ref) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAuthnContextDeclref(" + ref + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAuthnContextDeclRef(" + ref + ")");
        }
        this.authnContextDeclRef = ref;
    }

    @Override
    public OMElement getXML() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXML()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXML()");
        }
        return null;
    }

    @Override
    public void create() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create()");
        }
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate()");
        }
        return true;
    }

    public static class ValidAuthnMethod {
        public static Map<String, String> authnMap = new HashMap<String, String>();

        static {
            authnMap.put("Internet", "urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocol");
            authnMap.put("Password", "urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
            authnMap.put("PasswordProtectedTransport", "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
            authnMap.put("Kerberos", "urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
            authnMap.put("XMLDSig", "urn:oasis:names:tc:SAML:2.0:ac:classes:XMLDSig");
            authnMap.put("unspecified", "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
            authnMap.put("urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocol", "urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocol");
            authnMap.put("urn:oasis:names:tc:SAML:2.0:ac:classes:Password", "urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
            authnMap.put("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport", "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
            authnMap.put("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos", "urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
            authnMap.put("urn:oasis:names:tc:SAML:2.0:ac:classes:XMLDSig", "urn:oasis:names:tc:SAML:2.0:ac:classes:XMLDSig");
            authnMap.put("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified", "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
        }
    }
}

