/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.impl;

import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml20.assertion.AudienceRestriction;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.ConditionAbstractImpl;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class AudienceRestrictionImpl
extends ConditionAbstractImpl
implements AudienceRestriction {
    private static final TraceComponent tc = Tr.register(AudienceRestrictionImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = AudienceRestrictionImpl.class.getName();
    private ProviderConfig conf = null;
    private RequesterConfig req = null;
    private CredentialConfig cred = null;
    private ArrayList<String> audiences = new ArrayList();
    private OMElement xml = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public AudienceRestrictionImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AudienceRestrictionImpl()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AudienceRestrictionImpl()");
        }
    }

    public AudienceRestrictionImpl(ProviderConfig issueCfg, RequesterConfig requestData, CredentialConfig cred) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AudienceRestrictionImpl(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
        this.conf = issueCfg;
        this.req = requestData;
        this.cred = cred;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AudienceRestrictionImpl(ProviderConfig, RequesterConfig, CredentialConfig)");
        }
    }

    @Override
    public List<String> getAudience() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAudience()");
        }
        if (this.audiences == null) {
            this.audiences = new ArrayList();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAudience()");
        }
        return this.audiences;
    }

    @Override
    public void addAudience(String aud) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addAudience(" + aud + ")");
        }
        if (this.audiences == null) {
            this.audiences = new ArrayList();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addAudience(" + aud + ")");
        }
        this.audiences.add(aud);
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshal(OMElement parent)" + (parent == null ? null : ((Object)parent).toString()));
        }
        OMElement om = null;
        if (!this.audiences.isEmpty()) {
            if (parent == null) {
                om = omFactory.createOMElement("AudienceRestriction", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
                om.declareNamespace(SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
            } else {
                om = parent.getOMFactory().createOMElement("AudienceRestriction", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
            }
            for (String audience : this.audiences) {
                OMElement om1 = om.getOMFactory().createOMElement("Audience", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
                om1.setText(audience);
                om.addChild(om1);
            }
        }
        this.xml = om;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshal(OMElement parent): " + (om == null ? null : ((Object)om).toString()));
        }
        return om;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unMarshal (OMElement om)" + (om == null ? null : ((Object)om).toString()));
        }
        this.xml = om;
        OMElement el = OMUtil.getFirstElement(om);
        while (el != null) {
            String ln = el.getLocalName();
            if ("Audience".equals(ln)) {
                String adudience = el.getText();
                this.audiences.add(adudience);
            }
            el = OMUtil.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unMarshal (OMElement om)");
        }
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXML()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXML()" + (this.xml == null ? null : ((Object)this.xml).toString()));
        }
        return this.xml;
    }

    @Override
    public void create() throws SoapSecurityException {
        String appliesTo;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create()");
        }
        if ((appliesTo = this.req.getRSTTProperties().get("wstrustClientAppliesToAddress")) != null && !appliesTo.isEmpty()) {
            this.getAudience().add(appliesTo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create()");
        }
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate()");
        }
        return true;
    }
}

