/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.impl;

import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.CallbackHandler;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.Saml20AttributeCallback;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.SamlCallbackHandlerLoader;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Attribute;
import com.ibm.ws.wssecurity.saml.saml20.assertion.AttributeStatement;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.AttributeImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.StatementAbstractImpl;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import com.ibm.wsspi.wssecurity.saml.data.SAMLAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class AttributeStatementImpl
extends StatementAbstractImpl
implements AttributeStatement {
    private static final TraceComponent tc = Tr.register(AttributeStatementImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private ArrayList<Attribute> attributeOrEncryptedAttribute;
    private ProviderConfig issueCfg = null;
    private RequesterConfig requestData = null;
    private CredentialConfig cred = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public AttributeStatementImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AttributeStatementImpl()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AttributeStatementImpl()");
        }
    }

    public AttributeStatementImpl(ProviderConfig confg, RequesterConfig requesterdata, CredentialConfig cred) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AttributeStatementImpl(ProviderConfig, RequesterConfig CredentialConfig)");
        }
        this.issueCfg = confg;
        this.requestData = requesterdata;
        this.cred = cred;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AttributeStatementImpl(ProviderConfig, RequesterConfig CredentialConfig)");
        }
    }

    private ArrayList<Attribute> createSAMLAttributes(List<SAMLAttribute> simpleAtts) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSAMLAttributes(List<SAMLAttribute> simpleAtts)");
        }
        if (simpleAtts != null && !simpleAtts.isEmpty()) {
            for (SAMLAttribute simpleAtt : simpleAtts) {
                String fn;
                String nf;
                int i;
                String key = simpleAtt.getName();
                String[] stringValues = simpleAtt.getStringAttributeValue();
                XMLStructure[] xmlValues = simpleAtt.getXMLAttributeValue();
                ArrayList<Object> attValue = new ArrayList<Object>();
                if (stringValues != null) {
                    for (i = 0; i < stringValues.length; ++i) {
                        attValue.add(stringValues[i]);
                    }
                }
                if (xmlValues != null) {
                    for (i = 0; i < xmlValues.length; ++i) {
                        attValue.add(xmlValues[i]);
                    }
                }
                if (attValue.isEmpty()) continue;
                AttributeImpl attribute = new AttributeImpl();
                attribute.setName(key);
                attribute.setAttributeValue(attValue);
                String ns = simpleAtt.getAttributeNamespace();
                if (ns != null && !ns.isEmpty()) {
                    attribute.setAttributeNamespace(ns);
                }
                if ((nf = simpleAtt.getNameFormat()) != null && !nf.isEmpty()) {
                    attribute.setNameFormat(nf);
                }
                if ((fn = simpleAtt.getNameFormat()) != null && !fn.isEmpty()) {
                    attribute.setFriendlyName(fn);
                }
                this.getAttributeOrEncryptedAttribute().add(attribute);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSAMLAttributes(List<SAMLAttribute> simpleAtts)");
        }
        return this.getAttributeOrEncryptedAttribute();
    }

    @Override
    public ArrayList<Attribute> getAttributeOrEncryptedAttribute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeOrEncryptedAttribute()");
        }
        if (this.attributeOrEncryptedAttribute == null) {
            this.attributeOrEncryptedAttribute = new ArrayList();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeOrEncryptedAttribute()");
        }
        return this.attributeOrEncryptedAttribute;
    }

    @Override
    public void addAttributeOrEncryptedAttribute(ArrayList<Attribute> atts) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addAttributeOrEncryptedAttribute(ArrayList<Attribute> atts)");
        }
        if (atts != null && !atts.isEmpty()) {
            for (Attribute at : atts) {
                this.getAttributeOrEncryptedAttribute().add(at);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addAttributeOrEncryptedAttribute(ArrayList<Attribute> atts)");
        }
    }

    @Override
    public QName getQName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQName()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQName(): " + (AttributeStatement.qName == null ? null : AttributeStatement.qName.toString()));
        }
        return AttributeStatement.qName;
    }

    @Override
    public String getLocalName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalName()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalName(): AttributeStatement");
        }
        return "AttributeStatement";
    }

    @Override
    public OMElement getXML() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXML()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXML()");
        }
        return null;
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshal(OMElement parent)");
        }
        OMElement om = null;
        if (this.attributeOrEncryptedAttribute != null && !this.attributeOrEncryptedAttribute.isEmpty()) {
            if (parent == null) {
                om = omFactory.createOMElement("AttributeStatement", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
                om.declareNamespace(SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
            } else {
                om = parent.getOMFactory().createOMElement("AttributeStatement", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
            }
            ArrayList<Attribute> atts = this.attributeOrEncryptedAttribute;
            for (Attribute att : atts) {
                OMElement om2 = att.marshal(om);
                om.addChild(om2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "marshal(OMElement parent)");
            }
            return om;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshal(OMElement parent) returns null");
        }
        return null;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unMarshal(OMElement om)");
        }
        OMElement el = OMUtil.getFirstElement(om);
        while (el != null) {
            String ln = el.getLocalName();
            if ("Attribute".equals(ln)) {
                AttributeImpl att = new AttributeImpl();
                att.unMarshal(el);
                this.getAttributeOrEncryptedAttribute().add(att);
            }
            el = OMUtil.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unMarshal(OMElement om)");
        }
    }

    @Override
    public void create() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unMarshal(OMElement om");
        }
        List<SAMLAttribute> preAtts = this.cred.getSAMLAttributes();
        this.createSAMLAttributes(preAtts);
        if (this.issueCfg.getAttributeProvider() != null && !this.issueCfg.getAttributeProvider().isEmpty()) {
            Saml20AttributeCallback acb = new Saml20AttributeCallback(this.issueCfg, this.requestData, this.cred);
            CallbackHandler handler = SamlCallbackHandlerLoader.getCallbackHandler(this.issueCfg.getAttributeProvider());
            handler.handle(acb);
            if (acb.isSAMLAttributeTypeOnly()) {
                ArrayList<SAMLAttribute> attris = acb.getSAMLAttributes();
                this.createSAMLAttributes(attris);
            } else {
                ArrayList<Attribute> saml20Attributes = null;
                saml20Attributes = acb.getSaml20Attribute();
                this.addAttributeOrEncryptedAttribute(saml20Attributes);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unMarshal(OMElement om");
        }
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate() ");
        }
        return true;
    }

    @Override
    public boolean isSupported() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSupported()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSupported(): " + new Boolean(true).toString());
        }
        return true;
    }
}

