/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.impl;

import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.MessageHelper;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Attribute;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class AttributeImpl
implements Attribute {
    private static final TraceComponent tc = Tr.register(AttributeImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = AttributeImpl.class.getName();
    protected List<Object> attributeValue;
    protected String name;
    protected String nameFormat;
    protected String friendlyName;
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();
    protected OMElement attributeElement;
    private String attributeNamespace;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    @Override
    public List<Object> getAttributeValue() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeValue()");
        }
        if (this.attributeValue == null) {
            this.attributeValue = new ArrayList<Object>();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeValue()");
        }
        return this.attributeValue;
    }

    @Override
    public String getName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getName() about to return: " + this.name);
        }
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setName(" + value + ")");
        }
        this.name = value;
    }

    @Override
    public void setAttributeValue(List<Object> value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributeValue(List<Object> value)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributeValue(List<Object> value)");
        }
        this.attributeValue = value;
    }

    @Override
    public String getNameFormat() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNameFormat()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNameFormat(): " + this.nameFormat);
        }
        return this.nameFormat;
    }

    @Override
    public void setNameFormat(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNameFormat(" + value + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNameFormat(String value)");
        }
        this.nameFormat = value;
    }

    @Override
    public String getFriendlyName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFriendlyName()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFriendlyName(): " + this.friendlyName);
        }
        return this.friendlyName;
    }

    @Override
    public void setFriendlyName(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFriendlyName(" + value + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFriendlyName(" + value + ")");
        }
        this.friendlyName = value;
    }

    @Override
    public Map<QName, String> getOtherAttributes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOtherAttributes()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOtherAttributes()");
        }
        return this.otherAttributes;
    }

    @Override
    public OMElement getXML() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXML()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXML()");
        }
        return null;
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshal(OMElement parent)");
        }
        if (this.name == null) {
            return null;
        }
        OMElement om = null;
        if (parent == null) {
            om = omFactory.createOMElement("Attribute", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
            om.declareNamespace(SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
        } else {
            om = parent.getOMFactory().createOMElement("Attribute", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
        }
        om.addAttribute("Name", this.name, null);
        if (this.attributeNamespace != null && this.attributeNamespace.length() > 0) {
            om.addAttribute("AttributeNamespace", this.attributeNamespace, null);
        }
        if (this.nameFormat != null) {
            if ("NameFormat".length() > 0) {
                om.addAttribute("NameFormat", "NameFormat", null);
            }
        }
        OMElement om2 = null;
        if (this.attributeValue != null && !this.attributeValue.isEmpty()) {
            for (Object obj : this.attributeValue) {
                if (obj == null) continue;
                om2 = om.getOMFactory().createOMElement("AttributeValue", SAMLCommonConstants._saml2_ns, SAMLCommonConstants._saml2_prefix);
                if (obj instanceof String) {
                    om2.setText((String)obj);
                } else if (obj instanceof OMElement) {
                    om2.addChild((OMElement)obj);
                } else if (obj instanceof OMStructure) {
                    OMElement om3 = ((OMStructure)obj).getNode();
                    om2.addChild(om3);
                } else {
                    throw new SoapSecurityException(MessageHelper.getMessage("security.wssecurity.WSSML6006E"));
                }
                om.addChild(om2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshal(OMElement parent)");
        }
        return om;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unMarshal(OMElement om)");
        }
        QName QAttr = new QName(null, "Name");
        this.name = om.getAttributeValue(QAttr);
        QAttr = new QName(null, "NameFormat");
        this.nameFormat = om.getAttributeValue(QAttr);
        OMElement el = OMUtil.getFirstElement(om);
        while (el != null) {
            String ln = el.getLocalName();
            if ("AttributeValue".equals(ln)) {
                if (el.getText() != null && !el.getText().trim().isEmpty()) {
                    this.getAttributeValue().add(el.getText().trim());
                }
                if (OMUtil.getFirstElement(el) != null) {
                    this.getAttributeValue().add(new OMStructure(OMUtil.getFirstElement(el)));
                }
            }
            el = OMUtil.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unMarshal(OMElement om)");
        }
    }

    @Override
    public void create() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create()");
        }
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate(): " + new Boolean(false).toString());
        }
        return true;
    }

    @Override
    public String getAttributeNamespace() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeNamespace()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeNamespace())");
        }
        return this.attributeNamespace;
    }

    @Override
    public void setAttributeNamespace(String ns) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributeNamespace");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributeNamespace");
        }
        this.attributeNamespace = ns;
    }
}

