/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml20.assertion.impl;

import com.ibm.ws.wssecurity.saml.common.impl.SAMLAssertionImpl;
import com.ibm.ws.wssecurity.saml.common.util.MessageHelper;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.common.util.UTC;
import com.ibm.ws.wssecurity.saml.common.util.UUIDGenerator;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Advice;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Assertion;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Conditions;
import com.ibm.ws.wssecurity.saml.saml20.assertion.NameID;
import com.ibm.ws.wssecurity.saml.saml20.assertion.StatementAbstract;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Subject;
import com.ibm.ws.wssecurity.saml.saml20.assertion.SubjectConfirmation;
import com.ibm.ws.wssecurity.saml.saml20.assertion.SubjectConfirmationData;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.AdviceImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.AttributeStatementImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.AuthnStatementImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.ConditionsImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.IssuerImpl;
import com.ibm.ws.wssecurity.saml.saml20.assertion.impl.SubjectImpl;
import com.ibm.ws.wssecurity.saml.security.EnvelopedSignatureAssertion;
import com.ibm.ws.wssecurity.saml.security.HoKAssertion;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.security.Key;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class AssertionImpl
extends SAMLAssertionImpl
implements Assertion {
    private static final TraceComponent tc = Tr.register(AssertionImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = AssertionImpl.class.getName();
    protected NameID issuer;
    protected EnvelopedSignatureAssertion signature;
    protected Subject subject;
    protected Conditions conditions;
    protected Advice advice;
    protected List<StatementAbstract> statementOrAuthnStatementOrAuthzDecisionStatement;
    protected String version;
    protected Date issueInstant;
    protected String issueInstantUTC = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private ConsumerConfig assertionConsumingCfg = null;
    private OMElement xml = null;
    private String confirmMethod;
    private Key holderOfKey = null;
    private boolean isSigned = false;
    private ProviderConfig issue = null;
    private RequesterConfig request = null;
    private CredentialConfig cred = null;

    public AssertionImpl(ProviderConfig issueCfg, RequesterConfig requesterData, CredentialConfig cred) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AssertionImpl( issueCfg, requesterData, cred)");
        }
        this.issue = issueCfg;
        this.request = requesterData;
        this.cred = cred;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AssertionImpl( issueCfg, requesterData, cred)");
        }
    }

    public AssertionImpl(OMElement om, ConsumerConfig keyStoreCfg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AssertionImpl(OMElement om, ConsumerConfig keyStoreCfg)");
        }
        this.initVersion();
        this.xml = om;
        this.assertionConsumingCfg = keyStoreCfg;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AssertionImpl(OMElement om, ConsumerConfig keyStoreCfg)");
        }
    }

    private void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize()");
        }
        this.id = UUIDGenerator.generateUUID();
        this.issueInstant = new Date();
        this.issueInstantUTC = UTC.format(this.issueInstant);
        this.version = "2.0";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize()");
        }
    }

    private void initVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initVersion()");
        }
        this.assertionVersion = Assertion._saml2_ns_qname;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initVersion()");
        }
    }

    @Override
    public NameID getIssuer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIssuer() to return: " + this.issuer);
        }
        return this.issuer;
    }

    @Override
    public void setIssuer(NameID value) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIssuer(" + value.toString() + ")");
        }
        if (value == null || value.getValue() == null || value.getValue().isEmpty()) {
            throw new SoapSecurityException(MessageHelper.getMessage("security.wssecurity.WSSML6001E"));
        }
        this.issuer = value;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setIssuer(NameID value): " + value.getValue());
        }
    }

    @Override
    public EnvelopedSignatureAssertion getSignature() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignature() to return the signature object");
        }
        return this.signature;
    }

    @Override
    public void setSignature(EnvelopedSignatureAssertion value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignature(EnvelopedSignatureAssertion value)");
        }
        this.signature = value;
    }

    @Override
    public Subject getSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject() to return the subject");
        }
        return this.subject;
    }

    @Override
    public void setSubject(Subject value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSubject(Subject value)");
        }
        this.subject = value;
    }

    @Override
    public Conditions getConditions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConditions() to return the conditions");
        }
        return this.conditions;
    }

    @Override
    public void setConditions(Conditions value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConditions(Conditions value)");
        }
        this.conditions = value;
    }

    @Override
    public Advice getAdvice() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdvice() to return advice");
        }
        return this.advice;
    }

    @Override
    public void setAdvice(Advice value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAdvice()");
        }
        this.advice = value;
    }

    @Override
    public List<StatementAbstract> getStatementOrAuthnStatementOrAuthzDecisionStatement() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatementOrAuthnStatementOrAuthzDecisionStatement()");
        }
        if (this.statementOrAuthnStatementOrAuthzDecisionStatement == null) {
            this.statementOrAuthnStatementOrAuthzDecisionStatement = new ArrayList<StatementAbstract>();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatementOrAuthnStatementOrAuthzDecisionStatement() to return");
        }
        return this.statementOrAuthnStatementOrAuthzDecisionStatement;
    }

    @Override
    public void addStatement(StatementAbstract statement) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addStatement(StatementAbstract statement)");
        }
        if (!statement.isSupported()) {
            throw new SoapSecurityException(MessageHelper.getMessage("security.wssecurity.WSSML6002E"));
        }
        this.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(statement);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addStatement(StatementAbstract statement)");
        }
    }

    @Override
    public String getVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVersion() to return: " + this.version);
        }
        return this.version;
    }

    @Override
    public void setVersion(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVersion(" + value + ")");
        }
        this.version = value;
    }

    @Override
    public String getID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getID() to return: " + this.id);
        }
        return this.id;
    }

    @Override
    public void setID(String value) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setID(" + value + ")");
        }
        if (value == null || value.isEmpty()) {
            throw new SoapSecurityException(MessageHelper.getMessage("security.wssecurity.WSSML6003E"));
        }
        this.id = value;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setID(" + value + ")");
        }
    }

    @Override
    public Date getIssueInstant() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIssueInstant() about to return: " + this.issueInstant.toString());
        }
        return this.issueInstant;
    }

    @Override
    public void setIssueInstant(Date value) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIssueInstant(Date value): " + (value == null ? null : value.toString()));
        }
        if (value == null) {
            throw new SoapSecurityException(MessageHelper.getMessage("security.wssecurity.WSSML6004E"));
        }
        this.issueInstant = value;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setIssueInstant(Date value): " + value.toString());
        }
    }

    @Override
    public List<StatementAbstract> getStatements(QName qName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatements(QName qName): " + qName.toString());
        }
        if (qName == null) {
            return null;
        }
        ArrayList<StatementAbstract> sal = new ArrayList<StatementAbstract>();
        List<StatementAbstract> l = this.getStatementOrAuthnStatementOrAuthzDecisionStatement();
        ListIterator<StatementAbstract> it = l.listIterator();
        while (it.hasNext()) {
            StatementAbstract sa = (StatementAbstract)it.next();
            if (!qName.equals(sa.getQName())) continue;
            sal.add(sa);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatements(QName qName): " + qName.toString());
        }
        return sal;
    }

    @Override
    public String getConfirmationMethod() {
        SubjectConfirmation sc;
        Subject sub;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfirmationMethod()");
        }
        if (this.confirmMethod == null && (sub = this.subject) != null && (sc = sub.getSubjectConfirmation()) != null) {
            this.confirmMethod = sc.getMethod();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfirmationMethod(): " + this.confirmMethod);
        }
        return this.confirmMethod;
    }

    @Override
    public Date getSamlExpirationTime() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSamlExpirationTime() to return the expiration time");
        }
        return this.conditions.getNotOnOrAfter();
    }

    public boolean isSigned() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSigned() to return: " + new Boolean(this.isSigned).toString());
        }
        return this.isSigned;
    }

    public void setSigned() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSigned() to set isSigned to true");
        }
        this.isSigned = true;
    }

    @Override
    public void create() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create()");
        }
        this.initVersion();
        this.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create()");
        }
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        if (this.issueInstant.before(new Date())) {
            long time;
            long clockskew = 180000L;
            if (this.assertionConsumingCfg != null) {
                clockskew = this.assertionConsumingCfg.getClockSkew();
            }
            if ((time = clockskew + new Date().getTime()) < this.issueInstant.getTime()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validate() to return: " + new Boolean(false).toString());
                }
                return false;
            }
        }
        if (this.id == null || this.id.isEmpty()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate() to return: " + new Boolean(false).toString());
            }
            return false;
        }
        if (this.issuer != null && !this.issuer.validate()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate() to return: " + new Boolean(false).toString());
            }
            return false;
        }
        if (this.subject != null && !this.subject.validate()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate() to return: " + new Boolean(false).toString());
            }
            return false;
        }
        if (this.conditions != null && !this.conditions.validate()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate() to return: " + new Boolean(false).toString());
            }
            return false;
        }
        if (this.advice != null && !this.advice.validate()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate() to return: " + new Boolean(false).toString());
            }
            return false;
        }
        int iSize = 0;
        StatementAbstract[] allStms = null;
        if (this.getStatementOrAuthnStatementOrAuthzDecisionStatement() != null) {
            iSize = this.getStatementOrAuthnStatementOrAuthzDecisionStatement().size();
            allStms = new StatementAbstract[iSize];
            this.getStatementOrAuthnStatementOrAuthzDecisionStatement().toArray(allStms);
            if (allStms != null) {
                int length = allStms.length;
                for (int i = 0; i < length; ++i) {
                    if (allStms[i].validate()) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validate() to return: " + new Boolean(false).toString());
                    }
                    return false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate() to return: " + new Boolean(true).toString());
        }
        return true;
    }

    @Override
    public Key getHolderOfKey() {
        HoKAssertion hok;
        SubjectConfirmationData scd;
        SubjectConfirmation sc;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHolderOfKey())");
        }
        if (this.holderOfKey != null) {
            return this.holderOfKey;
        }
        Subject subj = this.getSubject();
        if (subj != null && (sc = subj.getSubjectConfirmation()) != null && (scd = sc.getSubjectConfirmationData()) != null && (hok = scd.getKeyInfoAssertion()) != null) {
            this.holderOfKey = hok.getKey();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHolderOfKey() about to return)");
        }
        return this.holderOfKey;
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXML()");
        }
        if (this.xml != null || this.isSigned) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getXML() about to return: " + this.xml);
            }
            return this.xml;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXML() about to return marshal(null)");
        }
        return this.marshal(null);
    }

    public void setXML(OMElement om) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setXML(): " + om);
        }
        if (this.isSigned) {
            throw new SoapSecurityException(MessageHelper.getMessage("security.wssecurity.WSSML6005E"));
        }
        this.xml = om;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setXML()");
        }
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        OMElement sub;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshal(OMElement parent): " + parent);
        }
        if (this.isSigned) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "marshal(OMElement parent): case of signed assertion: about to return this.xml");
            }
            return this.xml;
        }
        OMElement as = null;
        if (parent == null) {
            as = omFactory.createOMElement("Assertion", _saml2_ns, _saml2_prefix);
            as.declareNamespace(_saml2_ns, _saml2_prefix);
        } else {
            as = parent.getOMFactory().createOMElement("Assertion", _saml2_ns, _saml2_prefix);
        }
        as.addAttribute("ID", this.id, null);
        as.addAttribute("IssueInstant", UTC.format(this.issueInstant), null);
        if (this.issuer != null) {
            OMElement issu = this.issuer.marshal(as);
            as.addChild(issu);
        }
        if (this.subject != null && (sub = this.subject.marshal(as)) != null) {
            as.addChild(sub);
        }
        if (this.conditions != null) {
            OMElement cond = this.conditions.marshal(as);
            as.addChild(cond);
        }
        if (this.advice != null) {
            OMElement adv = this.advice.marshal(as);
            as.addChild(adv);
        }
        int iSize = 0;
        StatementAbstract[] allStms = null;
        if (this.getStatementOrAuthnStatementOrAuthzDecisionStatement() != null) {
            iSize = this.getStatementOrAuthnStatementOrAuthzDecisionStatement().size();
            allStms = new StatementAbstract[iSize];
            this.getStatementOrAuthnStatementOrAuthzDecisionStatement().toArray(allStms);
            if (allStms != null) {
                int length = allStms.length;
                for (int i = 0; i < length; ++i) {
                    OMElement om1 = allStms[i].marshal(as);
                    if (om1 == null) continue;
                    as.addChild(om1);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshal(OMElement parent) about to return: " + as);
        }
        this.xml = as;
        return as;
    }

    @Override
    public void unMarshal(OMElement aOM) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unMarshal (OMElement aOM): " + aOM);
        }
        this.xml = aOM;
        QName QAttr = new QName(null, "ID");
        this.id = aOM.getAttributeValue(QAttr);
        QAttr = new QName(null, "IssueInstant");
        this.issueInstantUTC = aOM.getAttributeValue(QAttr);
        try {
            this.issueInstant = UTC.parse(this.issueInstantUTC);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            OMElement el = OMUtil.getFirstElement(aOM);
            while (el != null) {
                String ln = el.getLocalName();
                if ("Issuer".equals(ln)) {
                    this.issuer = new IssuerImpl();
                    this.issuer.unMarshal(el);
                } else if ("Conditions".equals(ln)) {
                    this.conditions = new ConditionsImpl();
                    this.conditions.unMarshal(el);
                } else if ("Advice".equals(ln)) {
                    this.advice = new AdviceImpl();
                    this.advice.unMarshal(el);
                } else if ("AttributeStatement".equals(ln)) {
                    AttributeStatementImpl attrStatement = new AttributeStatementImpl();
                    attrStatement.unMarshal(el);
                    this.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(attrStatement);
                } else if ("AuthnStatement".equals(ln)) {
                    AuthnStatementImpl authStatement = new AuthnStatementImpl(this.assertionConsumingCfg);
                    authStatement.unMarshal(el);
                    this.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(authStatement);
                } else if ("Subject".equals(ln)) {
                    this.subject = new SubjectImpl(this.assertionConsumingCfg);
                    this.subject.unMarshal(el);
                }
                el = OMUtil.getNextElement(el);
            }
        }
        catch (Exception ex) {
            throw new SoapSecurityException(ex.getMessage(), ex.getCause());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unMarshal (OMElement aOM)");
        }
    }
}

