/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.utils;

import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion;
import com.ibm.ws.wssecurity.saml.security.impl.SAMLSignatureVerification;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import java.security.KeyStore;
import java.util.Date;
import org.apache.axiom.om.OMElement;

public class SAMLVerifier {
    private static final TraceLog log = new TraceLog(SAMLVerifier.class);

    public static boolean verifySAMLSignature(OMElement om, ConsumerConfig samlCfg) throws SoapSecurityException {
        log.entry("verifySAMLSignature(OMElement, ConsumerConfig)");
        KeyStoreManager.KeyInformation keyInformation = null;
        KeyStoreManager ksManager = KeyStoreManager.getInstance();
        if (samlCfg.getKeyInformationConfig() != null && samlCfg.getKeyInformationConfig().getAlias() != null && !samlCfg.getKeyInformationConfig().getAlias().isEmpty()) {
            keyInformation = ksManager.getKeyInformation(samlCfg.getTrustStoreConfig().getPath(), samlCfg.getTrustStoreConfig().getType(), samlCfg.getTrustStoreConfig().getPassword().toCharArray(), samlCfg.getTrustStoreConfig().getKsRef(), samlCfg.getKeyInformationConfig().getAlias(), null, samlCfg.getKeyInformationConfig().getName());
        }
        KeyStore trustAnchor = null;
        boolean verified = SAMLSignatureVerification.verify(om, keyInformation, trustAnchor);
        log.exit("verifySAMLSignature(OMElement, ConsumerConfig)");
        return verified;
    }

    public static boolean verifySAMLCondition(Assertion as) {
        log.entry("verifySAMLCondition(Assertion)");
        Date notBefore = as.getConditions().getNotBefore();
        Date notAfter = as.getConditions().getNotOnOrAfter();
        Date now = new Date();
        boolean verified = true;
        if (now.getTime() + 180000L < notBefore.getTime()) {
            log.debug("SAML issued in future time.");
            verified = false;
        }
        if (now.getTime() - 180000L > notAfter.getTime()) {
            log.debug("SAML is already expired.");
            verified = false;
        }
        log.exit("verifySAMLCondition(Assertion)");
        return verified;
    }

    public static boolean verifySAMLAssertion(Assertion assertion) throws SoapSecurityException {
        return assertion.validate();
    }
}

