/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.utils;

import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.assertion.wssapi.SAMLAssertionParser;
import com.ibm.ws.wssecurity.saml.common.SAMLAssertion;
import com.ibm.ws.wssecurity.saml.common.SAMLObjectElement;
import com.ibm.ws.wssecurity.saml.common.util.Base64;
import com.ibm.ws.wssecurity.saml.common.util.KeyUtils;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Attribute;
import com.ibm.ws.wssecurity.saml.saml11.assertion.AttributeStatement;
import com.ibm.ws.wssecurity.saml.saml11.assertion.AudienceRestrictionCondition;
import com.ibm.ws.wssecurity.saml.saml11.assertion.AuthenticationStatement;
import com.ibm.ws.wssecurity.saml.saml11.assertion.ConditionAbstract;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Conditions;
import com.ibm.ws.wssecurity.saml.saml11.assertion.StatementAbstract;
import com.ibm.ws.wssecurity.saml.saml11.assertion.SubjectLocality;
import com.ibm.ws.wssecurity.saml.security.HoKAssertion;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAML11TokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAMLTokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactoryFactory;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.data.SAMLAttribute;
import com.ibm.wsspi.wssecurity.saml.data.SAMLNameID;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;

public class SAMLTokenBuilder {
    private static final TraceLog log = new TraceLog(SAMLTokenBuilder.class);
    private static String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName("com.ibm.ws.wssecurity.platform.SAML11Token");
    private static TokenFactory _tokenFactory = TokenFactoryFactory.getTokenFactory(_factoryKey);

    public static SAML11TokenImpl createSAMLToken(SAMLAssertion samlAssertion) throws SoapSecurityException {
        log.entry("createSAMLToken(SAMLAssertion)");
        Assertion saml = (Assertion)samlAssertion;
        SAML11TokenImpl samlToken = (SAML11TokenImpl)_tokenFactory.getToken(true);
        samlToken.setAssertionQName(saml.getAssertionQName());
        samlToken.setConfirmationMethod(saml.getConfirmationMethod());
        samlToken.setSAMLIssuerName(saml.getIssuer());
        boolean symmetricHok = false;
        StatementAbstract[] statements = saml.getAllStatements();
        int length = statements.length;
        for (int i = 0; i < length; ++i) {
            if (statements[i] instanceof AttributeStatement) {
                HoKAssertion hok;
                AttributeStatement attState = (AttributeStatement)statements[i];
                ArrayList<Attribute> atts = attState.getAttribute();
                Iterator<Attribute> it = atts.iterator();
                ArrayList<SAMLAttribute> samlAtts = new ArrayList<SAMLAttribute>();
                HashMap<String, String> simpleAtts = new HashMap<String, String>();
                while (it.hasNext()) {
                    int x;
                    Attribute att = it.next();
                    String name = att.getName();
                    int size = att.getAttributeValue().size();
                    List<Object> values = att.getAttributeValue();
                    String ns = att.getAttributeNamespace();
                    String format = att.getNameFormat();
                    String friend = att.getFriendlyName();
                    ArrayList<XMLStructure> xmlList = new ArrayList<XMLStructure>();
                    ArrayList<String> stringList = new ArrayList<String>();
                    for (Object obj : values) {
                        if (obj instanceof String) {
                            stringList.add((String)obj);
                            continue;
                        }
                        if (!(obj instanceof XMLStructure)) continue;
                        xmlList.add((XMLStructure)obj);
                    }
                    String[] stringAttributeValues = null;
                    XMLStructure[] xmlAttributeValues = null;
                    if (!stringList.isEmpty()) {
                        stringAttributeValues = new String[stringList.size()];
                        for (x = 0; x < stringAttributeValues.length; ++x) {
                            stringAttributeValues[x] = (String)stringList.get(x);
                        }
                    }
                    if (!xmlList.isEmpty()) {
                        xmlAttributeValues = new XMLStructure[xmlList.size()];
                        for (x = 0; x < xmlAttributeValues.length; ++x) {
                            xmlAttributeValues[x] = (XMLStructure)xmlList.get(x);
                        }
                    }
                    SAMLAttribute samlAtt = new SAMLAttribute(name, stringAttributeValues, xmlAttributeValues, ns, format, friend);
                    samlAtts.add(samlAtt);
                    if (size != 1 || SAMLTokenBuilder.hasValue(ns) || SAMLTokenBuilder.hasValue(format) || SAMLTokenBuilder.hasValue(friend) || !(values.get(0) instanceof String)) continue;
                    simpleAtts.put(name, (String)values.get(0));
                }
                samlToken.setSAMLAttributes(samlAtts);
                samlToken.setStringAttributes(simpleAtts);
                if (attState.getSubject() == null) continue;
                if (attState.getSubject().getNameIdentifier() != null) {
                    String name = attState.getSubject().getNameIdentifier().getValue();
                    samlToken.setPrincipal(name);
                    String format = attState.getSubject().getNameIdentifier().getFormat();
                    String qualifier = attState.getSubject().getNameIdentifier().getNameQualifier();
                    SAMLNameID samlNameId = new SAMLNameID(name, format, qualifier, null, null);
                    samlToken.setSAMLNameID(samlNameId);
                }
                if (attState.getSubject().getSubjectConfirmation() == null || (hok = attState.getSubject().getSubjectConfirmation().getKeyInfoAssertion()) == null || hok.getPrivateOrSharedKey() == null) continue;
                symmetricHok = true;
                continue;
            }
            if (!(statements[i] instanceof AuthenticationStatement)) continue;
            AuthenticationStatement authnSt = (AuthenticationStatement)statements[i];
            SubjectLocality sl = authnSt.getSubjectLocality();
            if (sl != null) {
                samlToken.setSubjectIPAddress(sl.getIPAddress());
                samlToken.setSubjectDNS(sl.getDNSAddress());
            }
            if (authnSt.getSubject() != null) {
                HoKAssertion hok;
                if (authnSt.getSubject().getNameIdentifier() != null) {
                    String name = authnSt.getSubject().getNameIdentifier().getValue();
                    samlToken.setPrincipal(name);
                    String format = authnSt.getSubject().getNameIdentifier().getFormat();
                    String qualifier = authnSt.getSubject().getNameIdentifier().getNameQualifier();
                    SAMLNameID samlNameId = new SAMLNameID(name, format, qualifier, null, null);
                    samlToken.setSAMLNameID(samlNameId);
                }
                if (authnSt.getSubject().getSubjectConfirmation() != null && (hok = authnSt.getSubject().getSubjectConfirmation().getKeyInfoAssertion()) != null && hok.getPrivateOrSharedKey() != null) {
                    symmetricHok = true;
                }
            }
            if (authnSt.getAuthenticationMethod() == null) continue;
            samlToken.setAuthenticationMethod(authnSt.getAuthenticationMethod());
            samlToken.setAuthenticationInstant(authnSt.getAuthenticationInstant());
        }
        if (saml.getConditions() != null) {
            Conditions con = saml.getConditions();
            samlToken.setSamlCreated(con.getNotBefore());
            samlToken.setSamlExpires(con.getNotOnOrAfter());
            if (con.getAudienceRestrictionConditionOrDoNotCacheConditionOrCondition() != null) {
                for (ConditionAbstract condition : con.getAudienceRestrictionConditionOrDoNotCacheConditionOrCondition()) {
                    if (!(condition instanceof AudienceRestrictionCondition)) continue;
                    List<String> audiences = ((AudienceRestrictionCondition)condition).getAudience();
                    samlToken.setAudienceRestriction(audiences);
                }
            }
        }
        if (saml.getHolderOfKey() != null) {
            if (symmetricHok) {
                byte[] entropy = saml.getHolderOfKey().getEncoded();
                samlToken.setHolderOfKeyBytes(entropy);
                Key key = KeyUtils.genertaeEncryptionKey(entropy, "AES");
                samlToken.setKey(62, key);
                samlToken.setKey(64, key);
                key = KeyUtils.genertaeSigningKey(entropy, null);
                samlToken.setKey(61, key);
                samlToken.setKey(63, key);
                samlToken.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey");
            } else {
                samlToken.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey");
                samlToken.setKey(63, saml.getHolderOfKey());
                samlToken.setKey(62, saml.getHolderOfKey());
            }
        } else {
            samlToken.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer");
        }
        samlToken.setKeyIdentifier(saml.getSamlID());
        samlToken.setKeyIdentifierValueType(SAMLTokenImpl.saml11KeyIdentifierValueType);
        samlToken.setSamlID(saml.getSamlID());
        samlToken.setXML(new OMStructure(saml.getXML()));
        log.exit("createSAMLToken(SAMLAssertion)");
        return samlToken;
    }

    public static SAML11TokenImpl createSAMLToken(Map rstrProperties, Map publicRSTRProperties, OMElement samlOM) throws SoapSecurityException {
        SAML11TokenImpl samlToken = SAMLTokenBuilder.createSAMLToken(rstrProperties, samlOM);
        if (publicRSTRProperties != null) {
            samlToken.setProperties(publicRSTRProperties);
        }
        return samlToken;
    }

    public static SAML11TokenImpl createSAMLToken(Map map, OMElement samlOM) throws SoapSecurityException {
        OMElement proofToken;
        log.entry("createEncryptedSAMLToken(Map, OMElement)");
        SAML11TokenImpl samlToken = (SAML11TokenImpl)_tokenFactory.getToken(true);
        if (!samlOM.getLocalName().equals("EncryptedData") && !samlOM.getLocalName().equals("EncryptedAssertion")) {
            SAMLAssertion newSAML = null;
            final OMElement samlXMLPriv = samlOM;
            try {
                newSAML = (SAMLAssertion)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws SoapSecurityException {
                        return SAMLAssertionParser.parseSAML(samlXMLPriv);
                    }
                });
                samlToken = SAMLTokenBuilder.createSAMLToken(newSAML);
            }
            catch (PrivilegedActionException pae) {
                log.debug("caught exception calling doPrivileged method: " + pae.getException().getMessage());
            }
        }
        if ((proofToken = (OMElement)map.get("RequestedProofTokenXML")) != null) {
            OMElement sec2 = OMUtil.getFirstElement(proofToken);
            String sec1 = sec2.getText();
            byte[] entropy = Base64.decode(sec1);
            try {
                samlToken.setHolderOfKeyBytes(entropy);
                Key key = KeyUtils.genertaeEncryptionKey(entropy, "AES");
                samlToken.setKey(62, key);
                samlToken.setKey(64, key);
                key = KeyUtils.genertaeSigningKey(entropy, null);
                samlToken.setKey(61, key);
                samlToken.setKey(63, key);
                samlToken.setKeyType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey");
                log.debug("Extracted proof key in RSTR");
            }
            catch (Exception e) {
                log.debug("fail to extract proof key in RSTR");
                throw new SoapSecurityException(e.getMessage());
            }
        } else {
            String keyType = (String)map.get("KeyType");
            log.debug("No proof key included in RSTR");
        }
        samlToken.setXML(new OMStructure(samlOM));
        if (samlToken.getSamlCreated() == null) {
            Date created = (Date)map.get("LifetimeCreated");
            samlToken.setSamlCreated(created);
        }
        if (samlToken.getSamlExpires() == null) {
            Date expires = (Date)map.get("LifetimeExpires");
            samlToken.setSamlExpires(expires);
        }
        samlToken.setAssertionQName(SAMLObjectElement._saml_ns_qname);
        String samlId = null;
        OMElement samlIDRef = (OMElement)map.get("RequestedUnattachedReferenceXML");
        if (samlIDRef == null) {
            samlIDRef = (OMElement)map.get("RequestedAttachedReferenceXML");
        }
        OMElement el = DOMUtils.getFirstElement(samlIDRef);
        while (el != null) {
            OMElement keyID;
            String ln = el.getLocalName();
            if ("SecurityTokenReference".equals(ln) && (keyID = DOMUtils.getFirstElement(el)) != null && "KeyIdentifier".equals(keyID.getLocalName())) {
                samlId = keyID.getText();
            }
            el = DOMUtils.getNextElement(el);
        }
        samlToken.setKeyIdentifier(samlId);
        samlToken.setKeyIdentifierValueType(SAMLTokenImpl.saml11KeyIdentifierValueType);
        samlToken.setSamlID(samlId);
        samlToken.setXML(new OMStructure(samlOM));
        log.exit("createEncryptedSAMLToken(Map, OMElement)");
        return samlToken;
    }

    public static boolean hasValue(String value) {
        log.entry("hasValue(String)");
        if (value == null || value.isEmpty()) {
            return false;
        }
        log.exit("hasValue(String)");
        return true;
    }
}

