/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.utils;

import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion;
import com.ibm.ws.wssecurity.saml.saml11.assertion.AttributeStatement;
import com.ibm.ws.wssecurity.saml.saml11.assertion.AuthenticationStatement;
import com.ibm.ws.wssecurity.saml.saml11.assertion.StatementAbstract;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Subject;
import com.ibm.ws.wssecurity.saml.saml11.assertion.SubjectConfirmation;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.AssertionImpl;
import com.ibm.ws.wssecurity.saml.security.HoKAssertion;
import com.ibm.ws.wssecurity.saml.security.impl.HoKAssertionImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import java.security.Key;
import org.apache.axiom.om.OMElement;

public class SAMLParser {
    private static final TraceLog log = new TraceLog(SAMLParser.class);

    public static Assertion parseSAML(OMElement aOM) throws SoapSecurityException {
        log.entry("parseSAML(OMElement)");
        Assertion as = SAMLParser.parseSAML(aOM, null);
        log.exit("parseSAML(OMElement)");
        return as;
    }

    public static Assertion parseSAML(OMElement aOM, ConsumerConfig decryptingKeyStoreCfg) throws SoapSecurityException {
        log.entry("parseSAML(OMElement, ConsumerConfig)");
        AssertionImpl as = new AssertionImpl(aOM, decryptingKeyStoreCfg);
        as.unMarshal(aOM);
        log.exit("parseSAML(OMElement, ConsumerConfig)");
        return as;
    }

    public static Key unMarshalHoKKey(Assertion saml, ConsumerConfig decryptingKeyStoreCfg) throws SoapSecurityException {
        log.entry("unMarshalHoKKey(Assertion, ConsumerConfig)");
        Key key = SAMLParser.getHoKAssertion(saml, decryptingKeyStoreCfg).getKey();
        log.exit("unMarshalHoKKey(Assertion, ConsumerConfig)");
        return key;
    }

    public static HoKAssertion getHoKAssertion(Assertion saml, ConsumerConfig decryptingKeyStoreCfg) throws SoapSecurityException {
        log.entry("getHoKAssertion(Assertion, ConsumerConfig)");
        HoKAssertionImpl keyInfoAss = new HoKAssertionImpl(decryptingKeyStoreCfg);
        OMElement aOM = SAMLParser.gethokElement(saml);
        keyInfoAss.unMarshal(aOM);
        log.exit("getHoKAssertion(Assertion, ConsumerConfig)");
        return keyInfoAss;
    }

    private static OMElement gethokElement(Assertion assertion) {
        log.entry("gethokElement(Assertion)");
        Assertion as = assertion;
        Subject sj = null;
        SubjectConfirmation sc = null;
        Object kia = null;
        OMElement keyinfo = null;
        StatementAbstract[] sta = as.getAllStatements();
        for (int i = 0; i < sta.length; ++i) {
            if (sta[i] != null && sta[i] instanceof AuthenticationStatement) {
                sj = ((AuthenticationStatement)sta[i]).getSubject();
            } else if (sta[i] != null && sta[i] instanceof AttributeStatement) {
                sj = ((AttributeStatement)sta[i]).getSubject();
            }
            if (sj == null || (sc = sj.getSubjectConfirmation()) == null) continue;
            keyinfo = sc.getKeyInfoElement();
        }
        log.exit("gethokElement(Assertion)");
        return keyinfo;
    }
}

