/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.utils;

import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.AssertionModifierCallback;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.CallbackHandler;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.SamlCallbackHandlerLoader;
import com.ibm.ws.wssecurity.saml.common.SAMLAssertion;
import com.ibm.ws.wssecurity.saml.config.impl.SamlConfigUtil;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.AssertionImpl;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.AttributeStatementImpl;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.AuthenticationStatementImpl;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.ConditionsImpl;
import com.ibm.ws.wssecurity.saml.security.impl.SamlSignatureUtils;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.util.Date;
import java.util.HashMap;
import org.apache.axiom.om.OMElement;

public class SAMLBuilder {
    private static final TraceLog log = new TraceLog(SAMLBuilder.class);

    public static Assertion createUnsignedAssertion(ProviderConfig issue, RequesterConfig request, CredentialConfig cred) throws SoapSecurityException {
        log.entry("createUnsignedAssertion (ProviderConfig, RequesterConfig, CredentialConfig)");
        Assertion assertion = null;
        boolean createAuthnStatement = SamlConfigUtil.createAuthnStatement(cred, request, issue);
        boolean createArttibuteStatement = SamlConfigUtil.createAttributeStatement(cred, request, issue);
        HashMap<String, Object> context = new HashMap<String, Object>();
        try {
            assertion = new AssertionImpl(issue, request, cred);
            assertion.create();
            Date issueInst = assertion.getIssueInstant();
            context.put("create_instance", issueInst);
            ConditionsImpl cond = new ConditionsImpl(issue, request, cred);
            cond.create();
            assertion.setConditions(cond);
            if (createAuthnStatement) {
                AuthenticationStatementImpl authStatement = new AuthenticationStatementImpl(issue, request, cred);
                authStatement.create();
                assertion.addStatementOrSubjectStatementOrAuthenticationStatement(authStatement);
                context.put("AuthenticationStatementImpl", authStatement);
            }
            if (createArttibuteStatement) {
                AttributeStatementImpl attrStatement = new AttributeStatementImpl(issue, request, cred, context);
                attrStatement.create();
                assertion.addStatementOrSubjectStatementOrAuthenticationStatement(attrStatement);
            }
            AssertionImpl finalAssertion = assertion;
            if (issue.getSamlModifier() != null && !issue.getSamlModifier().isEmpty()) {
                AssertionModifierCallback acb = new AssertionModifierCallback(issue, request, cred, finalAssertion);
                CallbackHandler handler = SamlCallbackHandlerLoader.getCallbackHandler(issue.getSamlModifier());
                handler.handle(acb);
                assertion = (Assertion)acb.getAssertion();
            }
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage());
        }
        log.exit("createUnsignedAssertion (ProviderConfig, RequesterConfig, CredentialConfig)");
        return assertion;
    }

    public static OMElement getSignedSAMLAssertion(ProviderConfig issue, RequesterConfig request, SAMLAssertion unSignedAssertion) throws SoapSecurityException {
        return SamlSignatureUtils.getSignedSAML(issue, request, unSignedAssertion);
    }

    public static OMElement getSignedSAMLAssertion(ProviderConfig issue, RequesterConfig requesterData, OMElement unsignedSamlOm, String samlID) throws SoapSecurityException {
        return SamlSignatureUtils.getSignedSAML(issue, requesterData, unsignedSamlOm, samlID);
    }

    public static Assertion createSignedAssertion(ProviderConfig issue, RequesterConfig requesterData, CredentialConfig cred) throws SoapSecurityException {
        log.entry("createSignedAssertion (ProviderConfig, RequesterConfig, CredentialConfig)");
        Assertion unSignedAssertion = SAMLBuilder.createUnsignedAssertion(issue, requesterData, cred);
        OMElement om = SamlSignatureUtils.getSignedSAML(issue, requesterData, unSignedAssertion);
        if (unSignedAssertion instanceof AssertionImpl) {
            ((AssertionImpl)unSignedAssertion).setXML(om);
            ((AssertionImpl)unSignedAssertion).setSigned();
        }
        log.exit("createSignedAssertion (ProviderConfig, RequesterConfig, CredentialConfig)");
        return unSignedAssertion;
    }
}

