/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.impl;

import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.saml11.assertion.SubjectLocality;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class SubjectLocalityImpl
implements SubjectLocality {
    private static final TraceLog log = new TraceLog(SubjectLocalityImpl.class);
    private String dnsAddress = null;
    private String ipAddress = null;
    private OMElement xml = null;
    private ProviderConfig issueCfg = null;
    private RequesterConfig requestData = null;
    private CredentialConfig cred = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public SubjectLocalityImpl() {
    }

    public SubjectLocalityImpl(ProviderConfig conf, RequesterConfig requesterdata, CredentialConfig cred) {
        this.issueCfg = conf;
        this.requestData = requesterdata;
        this.cred = cred;
    }

    @Override
    public String getDNSAddress() {
        return this.dnsAddress;
    }

    @Override
    public void setDNSAddress(String value) {
        this.dnsAddress = value;
    }

    @Override
    public String getIPAddress() {
        return this.ipAddress;
    }

    @Override
    public void setIPAddress(String value) {
        this.ipAddress = value;
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        return this.xml;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        log.entry("unMarshal(OMElement)");
        this.xml = om;
        QName QAttr = new QName(null, "IPAddress");
        this.ipAddress = om.getAttributeValue(QAttr);
        QAttr = new QName(null, "DNSAddress");
        this.dnsAddress = om.getAttributeValue(QAttr);
        log.exit("unMarshal(OMElement)");
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        log.entry("unMarshal(OMElement)");
        if (this.ipAddress == null && this.ipAddress.isEmpty()) {
            return null;
        }
        OMElement subC = null;
        if (parent == null) {
            subC = omFactory.createOMElement("SubjectLocality", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
            subC.declareNamespace(SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
        } else {
            subC = parent.getOMFactory().createOMElement("SubjectLocality", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
        }
        if (this.ipAddress != null && !this.ipAddress.isEmpty()) {
            subC.addAttribute("IPAddress", this.ipAddress, null);
        }
        if (this.dnsAddress != null && !this.dnsAddress.isEmpty()) {
            subC.addAttribute("DNSAddress", this.dnsAddress, null);
        }
        this.xml = subC;
        log.exit("unMarshal(OMElement)");
        return subC;
    }

    @Override
    public void create() throws SoapSecurityException {
        log.entry("create()");
        this.ipAddress = this.requestData.getRequesterIPAddress();
        this.dnsAddress = this.requestData.getRequesterDNSAddress();
        log.exit("create()");
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        return true;
    }
}

