/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.impl;

import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml11.assertion.NameIdentifier;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Subject;
import com.ibm.ws.wssecurity.saml.saml11.assertion.SubjectConfirmation;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.NameIdentifierImpl;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.SubjectConfirmationImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class SubjectImpl
implements Subject {
    private static final TraceLog log = new TraceLog(SubjectImpl.class);
    private List content = null;
    private NameIdentifier nameIdentifier;
    private SubjectConfirmation subjectConfirmation;
    private ProviderConfig issueCfg = null;
    private RequesterConfig requestData = null;
    private CredentialConfig cred = null;
    private boolean hasBeenCreated = false;
    private boolean hasBeenInserted = false;
    private OMElement xml = null;
    private ConsumerConfig consumer = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public SubjectImpl(ConsumerConfig consumer) {
        this.consumer = consumer;
    }

    public SubjectImpl(ProviderConfig issueCfg, RequesterConfig requesterData, CredentialConfig cred) {
        this.issueCfg = issueCfg;
        this.requestData = requesterData;
        this.cred = cred;
    }

    public SubjectImpl(NameIdentifier nameIdentifier, SubjectConfirmation subjectConfirmation) {
        this.nameIdentifier = nameIdentifier;
        this.subjectConfirmation = subjectConfirmation;
    }

    @Override
    public List getContent() {
        return this.content;
    }

    @Override
    public NameIdentifier getNameIdentifier() {
        return this.nameIdentifier;
    }

    @Override
    public void setNameIdentifier(NameIdentifier nameIdentifier) throws IllegalArgumentException {
        this.nameIdentifier = nameIdentifier;
    }

    @Override
    public SubjectConfirmation getSubjectConfirmation() {
        return this.subjectConfirmation;
    }

    @Override
    public void setSubjectConfirmation(SubjectConfirmation subjectConfirmation) throws IllegalArgumentException {
        this.subjectConfirmation = subjectConfirmation;
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        return this.xml;
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        OMElement nameI;
        log.entry("marshal(OMElement)");
        if (this.hasBeenInserted) {
            return null;
        }
        OMElement subj = null;
        if (parent == null) {
            subj = omFactory.createOMElement("Subject", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
            subj.declareNamespace(SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
        } else {
            subj = parent.getOMFactory().createOMElement("Subject", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
        }
        if (this.nameIdentifier != null && (nameI = this.nameIdentifier.marshal(subj)) != null) {
            subj.addChild(nameI);
        }
        OMElement subC = this.subjectConfirmation.marshal(subj);
        subj.addChild(subC);
        this.hasBeenInserted = true;
        this.xml = subj;
        log.exit("marshal(OMElement)");
        return subj;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        log.entry("unMarshal(OMElement)");
        this.xml = om;
        if (om != null && "Subject".equals(om.getLocalName())) {
            OMElement el = OMUtil.getFirstElement(om);
            while (el != null) {
                String ln = el.getLocalName();
                if ("NameIdentifier".equals(ln)) {
                    this.nameIdentifier = new NameIdentifierImpl();
                    this.nameIdentifier.unMarshal(el);
                } else if ("SubjectConfirmation".equals(ln)) {
                    this.subjectConfirmation = new SubjectConfirmationImpl(this.consumer);
                    this.subjectConfirmation.unMarshal(el);
                }
                el = OMUtil.getNextElement(el);
            }
        }
        log.exit("unMarshal(OMElement)");
    }

    @Override
    public void create() throws SoapSecurityException {
        log.entry("create()");
        if (!this.hasBeenCreated) {
            this.subjectConfirmation = new SubjectConfirmationImpl(this.issueCfg, this.requestData, this.cred);
            this.subjectConfirmation.create();
            this.nameIdentifier = new NameIdentifierImpl(this.issueCfg, this.requestData, this.cred);
            this.nameIdentifier.create();
            this.hasBeenCreated = true;
        }
        log.exit("create()");
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        log.entry("validate()");
        if (this.nameIdentifier == null && this.subjectConfirmation == null) {
            return false;
        }
        log.exit("validate()");
        return true;
    }
}

