/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.impl;

import com.ibm.ws.wssecurity.common.Messages;
import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.common.SAML11Constants;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.config.impl.SamlConfigUtil;
import com.ibm.ws.wssecurity.saml.saml11.assertion.SubjectConfirmation;
import com.ibm.ws.wssecurity.saml.security.HoKAssertion;
import com.ibm.ws.wssecurity.saml.security.impl.HoKAssertionImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class SubjectConfirmationImpl
implements SubjectConfirmation {
    private static final TraceLog log = new TraceLog(SubjectConfirmationImpl.class);
    private List<String> confirmationMethod = new ArrayList<String>();
    private HoKAssertion keyInfoAssertion = null;
    private OMElement keyInfoElm = null;
    private ProviderConfig issueCfg = null;
    private RequesterConfig requestData = null;
    private CredentialConfig cred = null;
    private boolean hasBeenCreated = false;
    private OMElement xml = null;
    private ConsumerConfig consumer = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public SubjectConfirmationImpl(ConsumerConfig consumer) {
        this.consumer = consumer;
    }

    public SubjectConfirmationImpl(ProviderConfig conf, RequesterConfig requesterdata, CredentialConfig cred) {
        this.issueCfg = conf;
        this.requestData = requesterdata;
        this.cred = cred;
    }

    public OMElement getNode() {
        return null;
    }

    @Override
    public List<String> getConfirmationMethod() {
        return this.confirmationMethod;
    }

    @Override
    public HoKAssertion getKeyInfoAssertion() {
        return this.keyInfoAssertion;
    }

    @Override
    public void setKeyInfoAssertion(HoKAssertion value) {
        this.keyInfoAssertion = value;
    }

    @Override
    public void setKeyInfoElement(OMElement keyInfo) {
        this.keyInfoElm = keyInfo;
    }

    @Override
    public OMElement getKeyInfoElement() {
        return this.keyInfoElm;
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        return this.xml;
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        log.entry("marshal(OMElement)");
        OMElement subC = null;
        if (parent == null) {
            subC = omFactory.createOMElement("SubjectConfirmation", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
            subC.declareNamespace(SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
        } else {
            subC = parent.getOMFactory().createOMElement("SubjectConfirmation", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
        }
        OMElement confirmM = omFactory.createOMElement("ConfirmationMethod", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
        confirmM.addChild(omFactory.createOMText(this.getConfirmationMethod().get(0)));
        subC.addChild(confirmM);
        if (this.keyInfoAssertion != null) {
            OMElement keyElement = this.keyInfoAssertion.marshal(null);
            if (keyElement != null) {
                subC.addChild(keyElement);
            }
        } else if (this.keyInfoElm != null) {
            subC.addChild(this.keyInfoElm);
        }
        this.xml = subC;
        log.exit("marshal(OMElement)");
        return subC;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        log.entry("unMarshal(OMElement)");
        this.xml = om;
        OMElement el = OMUtil.getFirstElement(om);
        while (el != null) {
            String ln = el.getLocalName();
            if ("ConfirmationMethod".equals(ln)) {
                String confMethod = el.getText();
                if (confMethod != null) {
                    this.confirmationMethod = Arrays.asList(confMethod);
                }
            } else if ("KeyInfo".equals(ln)) {
                this.keyInfoElm = el;
                this.keyInfoAssertion = new HoKAssertionImpl(this.consumer);
                this.keyInfoAssertion.unMarshal(el);
            }
            el = OMUtil.getNextElement(el);
        }
        log.exit("unMarshal(OMElement)");
    }

    @Override
    public void create() throws SoapSecurityException {
        log.entry("create()");
        String confirmationMethods = SamlConfigUtil.getConfirmationMethod(this.requestData, this.issueCfg);
        this.confirmationMethod.add(this.normalizeMethod(confirmationMethods));
        if (!this.hasBeenCreated && this.confirmationMethod.contains(SAML11Constants._HOLDER_OF_KEY)) {
            this.keyInfoAssertion = new HoKAssertionImpl(this.issueCfg, this.requestData, this.cred);
            this.hasBeenCreated = true;
        }
        if (this.keyInfoAssertion != null) {
            this.keyInfoAssertion.create();
        }
        log.exit("create()");
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        log.entry("validate()");
        if (this.confirmationMethod == null || this.confirmationMethod.isEmpty()) {
            return false;
        }
        if (!(((Object)this.confirmationMethod).equals(SAML11Constants._SENDER_VOUCHES) || ((Object)this.confirmationMethod).equals(SAML11Constants._HOLDER_OF_KEY) || ((Object)this.confirmationMethod).equals(SAML11Constants._BEARER))) {
            return false;
        }
        log.exit("validate()");
        return true;
    }

    private String normalizeMethod(String inMethod) throws SoapSecurityException {
        log.entry("normalizeMethod(String)");
        if (inMethod == null) {
            return inMethod;
        }
        String outMethod = inMethod;
        if (inMethod.equalsIgnoreCase("sender-vouches") || inMethod.equalsIgnoreCase("sendervouches") || inMethod.equalsIgnoreCase("sender vouches") || inMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches")) {
            outMethod = SAML11Constants._SENDER_VOUCHES;
        } else if (inMethod.equalsIgnoreCase("holder-of-key") || inMethod.equalsIgnoreCase("holderofkey") || inMethod.equalsIgnoreCase("holder of key") || inMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key")) {
            outMethod = SAML11Constants._HOLDER_OF_KEY;
        } else if (inMethod.equalsIgnoreCase("bearer") || inMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:1.0:cm:bearer")) {
            outMethod = SAML11Constants._BEARER;
        } else {
            throw new SoapSecurityException(Messages.getString("CWSML2030E"));
        }
        log.exit("normalizeMethod(String)");
        return outMethod;
    }
}

