/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.impl;

import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.CallbackHandler;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.NameIDCallback;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.SamlCallbackHandlerLoader;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.saml11.assertion.NameIdentifier;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import com.ibm.wsspi.wssecurity.saml.data.SAMLNameID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class NameIdentifierImpl
implements NameIdentifier {
    private static final TraceLog log = new TraceLog(NameIdentifierImpl.class);
    private String value = null;
    private String format = null;
    private String nameQualifier = null;
    private ProviderConfig issueCfg = null;
    private RequesterConfig requestData = null;
    private CredentialConfig cred = null;
    private OMElement xml = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public NameIdentifierImpl() {
    }

    public NameIdentifierImpl(ProviderConfig issueCfg, RequesterConfig requesterData, CredentialConfig crd) {
        this.issueCfg = issueCfg;
        this.requestData = requesterData;
        this.cred = crd;
    }

    public NameIdentifierImpl(String value) {
        this("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", value);
    }

    public NameIdentifierImpl(String format, String value) {
        this(null, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", value);
    }

    public NameIdentifierImpl(String qualifier, String format, String value) {
        this.format = format;
        this.value = value;
        this.nameQualifier = qualifier;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String value) {
        this.format = value;
    }

    @Override
    public String getNameQualifier() {
        return this.nameQualifier;
    }

    @Override
    public void setNameQualifier(String value) {
        this.nameQualifier = value;
    }

    @Override
    public OMElement getXML() {
        return this.xml;
    }

    @Override
    public OMElement marshal(OMElement parent) {
        log.entry("marshal(OMElement)");
        OMElement nameI = null;
        if (parent == null) {
            nameI = omFactory.createOMElement("NameIdentifier", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
            nameI.declareNamespace(SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
        } else {
            nameI = parent.getOMFactory().createOMElement("NameIdentifier", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
        }
        if (this.nameQualifier != null && this.nameQualifier.length() > 0) {
            nameI.addAttribute("NameQualifier", this.nameQualifier, null);
        }
        if (this.format != null && !this.format.isEmpty()) {
            nameI.addAttribute("Format", this.format, null);
        }
        if (this.nameQualifier != null && !this.format.isEmpty()) {
            nameI.addAttribute("NameQualifier", this.nameQualifier, null);
        }
        nameI.addChild(omFactory.createOMText(this.value));
        this.xml = nameI;
        log.exit("marshal(OMElement)");
        return nameI;
    }

    @Override
    public void unMarshal(OMElement om) {
        log.entry("unMarshal(OMElement om)");
        this.xml = om;
        QName QAttr = new QName(null, "NameQualifier");
        this.nameQualifier = om.getAttributeValue(QAttr);
        QAttr = new QName(null, "Format");
        this.format = om.getAttributeValue(QAttr);
        this.value = om.getText();
        log.exit("unMarshal(OMElement)");
    }

    @Override
    public void create() throws SoapSecurityException {
        log.entry("create()");
        if (this.issueCfg.getNameIDProvider() != null && !this.issueCfg.getNameIDProvider().isEmpty()) {
            NameIDCallback idCallback = new NameIDCallback(this.issueCfg, this.requestData, this.cred);
            CallbackHandler handler = SamlCallbackHandlerLoader.getCallbackHandler(this.issueCfg.getNameIDProvider());
            handler.handle(idCallback);
            SAMLNameID nameID = idCallback.getSAMLNameID();
            if (nameID != null) {
                this.format = nameID.getFormat();
                this.nameQualifier = nameID.getNameQualifier();
                this.value = nameID.getValue();
            }
        } else if (this.cred.getSAMLNameID() != null && this.cred.getSAMLNameID().getValue() != null) {
            this.value = this.cred.getSAMLNameID().getValue();
            this.format = this.cred.getSAMLNameID().getFormat();
            this.nameQualifier = this.cred.getSAMLNameID().getNameQualifier();
        }
        log.exit("create()");
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        log.entry("validate()");
        if (this.value == null || this.value.isEmpty()) {
            return false;
        }
        log.exit("validate()");
        return true;
    }
}

