/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.impl;

import com.ibm.ws.wssecurity.common.Messages;
import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml11.assertion.ConditionAbstract;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Conditions;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.AudienceRestrictionConditionImpl;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.DoNotCacheConditionImpl;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class ConditionsImpl
implements Conditions {
    private static final TraceLog log = new TraceLog(ConditionsImpl.class);
    private List<ConditionAbstract> audienceRestrictionConditionOrDoNotCacheConditionOrCondition = new ArrayList<ConditionAbstract>();
    private Date notBefore = null;
    private Date notOnOrAfter = null;
    private ProviderConfig issueCfg = null;
    private RequesterConfig requestData = null;
    private CredentialConfig cred = null;
    private OMElement xml = null;
    private Map context = new HashMap();
    private ConsumerConfig assertionConsumingCfg = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public ConditionsImpl(ProviderConfig issueCfg, RequesterConfig requestData, CredentialConfig cred, Map context) {
        this.issueCfg = issueCfg;
        this.requestData = requestData;
        this.cred = cred;
        this.context = context;
    }

    public ConditionsImpl(ProviderConfig issueCfg, RequesterConfig requestData, CredentialConfig cred) {
        this.issueCfg = issueCfg;
        this.requestData = requestData;
        this.cred = cred;
    }

    public ConditionsImpl() {
        this.notBefore = null;
        this.notOnOrAfter = null;
        this.audienceRestrictionConditionOrDoNotCacheConditionOrCondition = new ArrayList<ConditionAbstract>();
        this.issueCfg = null;
        this.requestData = null;
    }

    public ConditionsImpl(ConsumerConfig consumer) {
        this.notBefore = null;
        this.notOnOrAfter = null;
        this.audienceRestrictionConditionOrDoNotCacheConditionOrCondition = new ArrayList<ConditionAbstract>();
        this.issueCfg = null;
        this.requestData = null;
        this.assertionConsumingCfg = consumer;
    }

    @Override
    public List<ConditionAbstract> getAudienceRestrictionConditionOrDoNotCacheConditionOrCondition() {
        log.entry("getAudienceRestrictionConditionOrDoNotCacheConditionOrCondition()");
        if (this.audienceRestrictionConditionOrDoNotCacheConditionOrCondition == null) {
            this.audienceRestrictionConditionOrDoNotCacheConditionOrCondition = new ArrayList<ConditionAbstract>();
        }
        log.exit("getAudienceRestrictionConditionOrDoNotCacheConditionOrCondition()");
        return this.audienceRestrictionConditionOrDoNotCacheConditionOrCondition;
    }

    @Override
    public Date getNotBefore() {
        return this.notBefore;
    }

    @Override
    public void setNotBefore(Date value) {
        this.notBefore = value;
    }

    @Override
    public Date getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    @Override
    public void setNotOnOrAfter(Date value) {
        this.notOnOrAfter = value;
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        return this.xml;
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        log.entry("marshal(OMElement)");
        OMElement cond = null;
        if (parent == null) {
            cond = omFactory.createOMElement("Conditions", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
            cond.declareNamespace(SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
        } else {
            cond = parent.getOMFactory().createOMElement("Conditions", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
        }
        cond.addAttribute("NotBefore", UTC.format(this.notBefore), null);
        cond.addAttribute("NotOnOrAfter", UTC.format(this.notOnOrAfter), null);
        if (!this.getAudienceRestrictionConditionOrDoNotCacheConditionOrCondition().isEmpty()) {
            for (ConditionAbstract obj : this.getAudienceRestrictionConditionOrDoNotCacheConditionOrCondition()) {
                OMElement om2 = obj.marshal(cond);
                cond.addChild(om2);
            }
        }
        this.xml = cond;
        log.exit("marshal(OMElement)");
        return cond;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        log.entry("unMarshal(OMElement)");
        this.xml = om;
        QName QAttr = new QName(null, "NotBefore");
        String date = om.getAttributeValue(QAttr);
        try {
            this.notBefore = UTC.parse(date);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        QAttr = new QName(null, "NotOnOrAfter");
        date = om.getAttributeValue(QAttr);
        try {
            this.notOnOrAfter = UTC.parse(date);
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        OMElement el = OMUtil.getFirstElement(om);
        while (el != null) {
            String ln = el.getLocalName();
            if ("AudienceRestrictionCondition".equals(ln)) {
                AudienceRestrictionConditionImpl adudience = new AudienceRestrictionConditionImpl();
                adudience.unMarshal(el);
                this.getAudienceRestrictionConditionOrDoNotCacheConditionOrCondition().add(adudience);
            } else if ("DoNotCacheCondition".equals(ln)) {
                new DoNotCacheConditionImpl();
            } else {
                throw new SoapSecurityException(Messages.getString("CWSML2031E"));
            }
            el = OMUtil.getNextElement(el);
        }
        log.exit("unMarshal(OMElement)");
    }

    @Override
    public void create() throws SoapSecurityException {
        log.entry("create()");
        if (this.context != null) {
            this.notBefore = (Date)this.context.get("create_instance");
        }
        if (this.notBefore == null) {
            this.notBefore = new Date();
        }
        this.notOnOrAfter = new Date(this.notBefore.getTime() + this.issueCfg.getTimeToLive());
        String appliesTo = this.requestData.getRSTTProperties().get("wstrustClientAppliesToAddress");
        if (appliesTo != null && !appliesTo.isEmpty()) {
            AudienceRestrictionConditionImpl audienceCondition = new AudienceRestrictionConditionImpl(this.issueCfg, this.requestData, this.cred);
            audienceCondition.create();
            this.getAudienceRestrictionConditionOrDoNotCacheConditionOrCondition().add(audienceCondition);
        }
        log.exit("create()");
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        long time;
        log.entry("validate()");
        long clockskew = 180000L;
        if (this.assertionConsumingCfg != null) {
            clockskew = this.assertionConsumingCfg.getClockSkew();
        }
        if ((time = clockskew + new Date().getTime()) < this.notBefore.getTime()) {
            return false;
        }
        time = new Date().getTime() - clockskew;
        if (time > this.notOnOrAfter.getTime()) {
            return false;
        }
        log.exit("validate()");
        return true;
    }
}

