/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.impl;

import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml11.assertion.AuthenticationStatement;
import com.ibm.ws.wssecurity.saml.saml11.assertion.AuthorityBinding;
import com.ibm.ws.wssecurity.saml.saml11.assertion.NameIdentifier;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Subject;
import com.ibm.ws.wssecurity.saml.saml11.assertion.SubjectConfirmation;
import com.ibm.ws.wssecurity.saml.saml11.assertion.SubjectLocality;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.SubjectImpl;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.SubjectLocalityImpl;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class AuthenticationStatementImpl
implements AuthenticationStatement {
    private static final TraceLog log = new TraceLog(AuthenticationStatementImpl.class);
    private SubjectLocality subjectLocality = null;
    private List<AuthorityBinding> authorityBinding = null;
    private Date authenticationInstant = null;
    private String authenticationMethod = null;
    private Subject subject = null;
    private NameIdentifier nameId = null;
    private SubjectConfirmation subjectConfirm = null;
    private OMElement xml = null;
    private ProviderConfig issueCfg;
    private RequesterConfig requestData;
    private CredentialConfig cred = null;
    private ConsumerConfig consumer = null;
    public static final String AUTHENTICATION_STATEMENT = "AuthenticationStatementImpl";
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public AuthenticationStatementImpl(ConsumerConfig cunsumer) {
        this.authenticationMethod = "urn:oasis:names:tc:SAML:1.0:am:unspecified";
        this.authenticationInstant = new Date();
        this.consumer = cunsumer;
    }

    public AuthenticationStatementImpl(ProviderConfig cfg, RequesterConfig requestData, CredentialConfig cred) {
        this.issueCfg = cfg;
        this.requestData = requestData;
        this.cred = cred;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(Subject value) {
        this.subject = value;
    }

    @Override
    public SubjectLocality getSubjectLocality() {
        return this.subjectLocality;
    }

    @Override
    public void setSubjectLocality(SubjectLocality value) {
        this.subjectLocality = value;
    }

    @Override
    public List<AuthorityBinding> getAuthorityBinding() {
        return this.authorityBinding;
    }

    @Override
    public Date getAuthenticationInstant() {
        return this.authenticationInstant;
    }

    @Override
    public void setAuthenticationInstant(Date value) {
        this.authenticationInstant = value;
    }

    @Override
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @Override
    public void setAuthenticationMethod(String value) {
        this.authenticationMethod = value;
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        return this.xml;
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        log.entry("marshal(OMElement)");
        OMElement authen = null;
        try {
            OMElement subjElm;
            if (parent == null) {
                authen = omFactory.createOMElement("AuthenticationStatement", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
                authen.declareNamespace(SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
            } else {
                authen = parent.getOMFactory().createOMElement("AuthenticationStatement", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
            }
            authen.addAttribute("AuthenticationInstant", UTC.format(this.authenticationInstant), null);
            authen.addAttribute("AuthenticationMethod", this.authenticationMethod, null);
            if (this.subject != null && (subjElm = this.subject.marshal(authen)) != null) {
                authen.addChild(subjElm);
            }
            if (this.subjectLocality != null) {
                subjElm = this.subjectLocality.marshal(authen);
                authen.addChild(subjElm);
            }
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        this.xml = authen;
        log.exit("marshal(OMElement)");
        return authen;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        log.entry("unMarshal(OMElement)");
        this.xml = om;
        try {
            QName QAttr = new QName(null, "AuthenticationInstant");
            String date = om.getAttributeValue(QAttr);
            this.authenticationInstant = UTC.parse(date);
            QAttr = new QName(null, "AuthenticationMethod");
            this.authenticationMethod = om.getAttributeValue(QAttr);
            OMElement el = OMUtil.getFirstElement(om);
            while (el != null) {
                String ln = el.getLocalName();
                if ("Subject".equals(ln)) {
                    this.subject = new SubjectImpl(this.consumer);
                    this.subject.unMarshal(el);
                } else if ("SubjectLocality".equals(ln)) {
                    this.subjectLocality = new SubjectLocalityImpl();
                    this.subjectLocality.unMarshal(el);
                }
                el = OMUtil.getNextElement(el);
            }
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        log.exit("unMarshal(OMElement)");
    }

    @Override
    public void create() throws SoapSecurityException {
        log.entry("create()");
        String method = this.requestData.getAuthenticationMethod();
        this.authenticationMethod = method != null && !method.startsWith("urn:oasis:names:tc:SAML:1.0:am:") ? "urn:oasis:names:tc:SAML:1.0:am:" + method : method;
        this.authenticationInstant = new Date();
        if (this.cred != null && this.cred.getProperties() != null) {
            String amethod;
            Date date = (Date)this.cred.getProperties().get("AuthenticationInstant");
            if (date != null) {
                this.authenticationInstant = date;
            }
            if (this.authenticationMethod == null && (amethod = (String)this.cred.getProperties().get("AuthenticationMethod")) != null && !amethod.isEmpty()) {
                this.authenticationMethod = amethod;
            }
        }
        this.subject = new SubjectImpl(this.issueCfg, this.requestData, this.cred);
        this.subject.create();
        this.subjectLocality = null;
        if (this.requestData.getRequesterIPAddress() != null && !this.requestData.getRequesterIPAddress().isEmpty()) {
            this.subjectLocality = new SubjectLocalityImpl(this.issueCfg, this.requestData, this.cred);
            this.subjectLocality.create();
        }
        log.exit("create()");
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        long time;
        log.entry("validate(");
        if (this.authenticationMethod == null || this.authenticationMethod.isEmpty()) {
            return false;
        }
        if (this.authenticationInstant == null) {
            return false;
        }
        long clockskew = 180000L;
        if (this.consumer != null) {
            clockskew = this.consumer.getClockSkew();
        }
        if ((time = clockskew + new Date().getTime()) < this.authenticationInstant.getTime()) {
            return false;
        }
        log.exit("validate(");
        return true;
    }
}

