/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.impl;

import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml11.assertion.AudienceRestrictionCondition;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class AudienceRestrictionConditionImpl
implements AudienceRestrictionCondition {
    private static final TraceLog log = new TraceLog(AudienceRestrictionConditionImpl.class);
    private ProviderConfig conf = null;
    private RequesterConfig req = null;
    private CredentialConfig cred = null;
    private ArrayList<String> audiences = new ArrayList();
    private OMElement xml = null;
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public AudienceRestrictionConditionImpl(ProviderConfig config2, RequesterConfig request, CredentialConfig cred) {
        this.req = request;
        this.conf = config2;
        this.cred = cred;
    }

    public AudienceRestrictionConditionImpl() {
    }

    @Override
    public List<String> getAudience() {
        return this.audiences;
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        return this.xml;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        log.entry("unMarshal(OMElement");
        this.xml = om;
        OMElement el = OMUtil.getFirstElement(om);
        while (el != null) {
            String ln = el.getLocalName();
            if ("Audience".equals(ln)) {
                String adudience = el.getText();
                this.audiences.add(adudience);
            }
            el = OMUtil.getNextElement(el);
        }
        log.exit("unMarshal(OMElement");
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        log.entry("marshal(OMElement)");
        OMElement om = null;
        if (!this.audiences.isEmpty()) {
            if (parent == null) {
                om = omFactory.createOMElement("AudienceRestrictionCondition", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
                om.declareNamespace(SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
            } else {
                om = parent.getOMFactory().createOMElement("AudienceRestrictionCondition", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
            }
            for (String audience : this.audiences) {
                OMElement om1 = om.getOMFactory().createOMElement("Audience", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
                om1.setText(audience);
                om.addChild(om1);
            }
        }
        this.xml = om;
        log.exit("marshal(OMElement)");
        return om;
    }

    @Override
    public void create() throws SoapSecurityException {
        log.entry("create()");
        String appliesTo = this.req.getRSTTProperties().get("wstrustClientAppliesToAddress");
        if (appliesTo != null && !appliesTo.isEmpty()) {
            this.getAudience().add(appliesTo);
        }
        log.exit("create()");
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        return true;
    }
}

