/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.impl;

import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.CallbackHandler;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.Saml11AttributeCallback;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.SamlCallbackHandlerLoader;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.config.impl.SamlConfigUtil;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Attribute;
import com.ibm.ws.wssecurity.saml.saml11.assertion.AttributeStatement;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Subject;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.AttributeImpl;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.AuthenticationStatementImpl;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.SubjectImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import com.ibm.wsspi.wssecurity.saml.data.SAMLAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXBuilder;

public class AttributeStatementImpl
implements AttributeStatement {
    private static final TraceLog log = new TraceLog(AttributeStatementImpl.class);
    private ArrayList<Attribute> attribute = new ArrayList();
    private Subject subject = null;
    private OMElement xml = null;
    private ProviderConfig issue = null;
    private RequesterConfig request = null;
    private CredentialConfig cred = null;
    private ConsumerConfig consumer = null;
    private Map context = new HashMap();
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public AttributeStatementImpl(ConsumerConfig keyStoreCfg) {
        this.issue = null;
        this.request = null;
        this.cred = null;
        this.consumer = keyStoreCfg;
    }

    public AttributeStatementImpl(ProviderConfig issueCfg, RequesterConfig requestData, CredentialConfig cred) {
        this.issue = issueCfg;
        this.request = requestData;
        this.cred = cred;
    }

    public AttributeStatementImpl(ProviderConfig issueCfg, RequesterConfig requestData, CredentialConfig cred, Map map) {
        this.issue = issueCfg;
        this.request = requestData;
        this.cred = cred;
        this.context = map;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(Subject value) {
        this.subject = value;
    }

    @Override
    public ArrayList<Attribute> createSAMLAttributes(List<SAMLAttribute> simpleAtts) {
        log.entry("createSAMLAttributes(List<SAMLAttribute>)");
        if (simpleAtts != null && !simpleAtts.isEmpty()) {
            for (SAMLAttribute simpleAtt : simpleAtts) {
                String fn;
                String nf;
                int i;
                String key = simpleAtt.getName();
                String[] stringValues = simpleAtt.getStringAttributeValue();
                XMLStructure[] xmlValues = simpleAtt.getXMLAttributeValue();
                ArrayList<Object> attValue = new ArrayList<Object>();
                if (stringValues != null) {
                    for (i = 0; i < stringValues.length; ++i) {
                        attValue.add(stringValues[i]);
                    }
                }
                if (xmlValues != null) {
                    for (i = 0; i < xmlValues.length; ++i) {
                        attValue.add(xmlValues[i]);
                    }
                }
                if (attValue.isEmpty()) continue;
                AttributeImpl anAttribute = new AttributeImpl();
                anAttribute.setName(key);
                anAttribute.setAttributeValue(attValue);
                String ns = simpleAtt.getAttributeNamespace();
                if (ns != null && !ns.isEmpty()) {
                    anAttribute.setAttributeNamespace(ns);
                }
                if ((nf = simpleAtt.getNameFormat()) != null && !nf.isEmpty()) {
                    anAttribute.setNameFormat(nf);
                }
                if ((fn = simpleAtt.getNameFormat()) != null && !fn.isEmpty()) {
                    anAttribute.setFriendlyName(fn);
                }
                this.getAttribute().add(anAttribute);
            }
        }
        log.exit("createSAMLAttributes(List<SAMLAttribute>)");
        return this.getAttribute();
    }

    @Override
    public void addAttributes(ArrayList<Attribute> atts) {
        log.entry("addAttributes(ArrayList<Attribute>)");
        if (atts != null && !atts.isEmpty()) {
            for (Attribute att : atts) {
                this.getAttribute().add(att);
            }
        }
        log.exit("addAttributes(ArrayList<Attribute>)");
    }

    @Override
    public ArrayList<Attribute> getAttribute() {
        log.entry("getAttribute()");
        if (this.attribute == null) {
            this.attribute = new ArrayList();
        }
        log.exit("getAttribute()");
        return this.attribute;
    }

    public void addAttribute(Attribute a) {
        this.getAttribute().add(a);
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        return this.xml;
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        log.entry("marshal(OMElement)");
        OMElement attrib = null;
        try {
            OMElement subjElm;
            OMElement subjElm2;
            Subject subj;
            if (parent == null) {
                attrib = omFactory.createOMElement("AttributeStatement", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
                attrib.declareNamespace(SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
            } else {
                attrib = parent.getOMFactory().createOMElement("AttributeStatement", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
            }
            boolean hasSubject = false;
            AuthenticationStatementImpl authn = (AuthenticationStatementImpl)this.context.get("AuthenticationStatementImpl");
            if (authn != null && (subj = authn.getSubject()) != null && (subjElm2 = subj.getXML()) != null && (subjElm2 = subjElm2.cloneOMElement()).getParent() != null) {
                subjElm2.detach();
                StAXBuilder aBuilder = (StAXBuilder)subjElm2.getBuilder();
                if (aBuilder != null) {
                    aBuilder.releaseParserOnClose(true);
                }
                attrib.addChild(subjElm2);
                hasSubject = true;
            }
            if (!hasSubject && (subjElm = this.subject.marshal(attrib)) != null) {
                attrib.addChild(subjElm);
            }
            ArrayList<Attribute> atts = this.attribute;
            for (Attribute att : atts) {
                OMElement om2 = att.marshal(attrib);
                attrib.addChild(om2);
            }
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        this.xml = attrib;
        log.exit("marshal(OMElement)");
        return attrib;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        log.entry("unMarshal(OMElement)");
        this.xml = om;
        try {
            OMElement ele = OMUtil.getFirstElement(om);
            while (ele != null) {
                if (ele != null && "Subject".equals(ele.getLocalName())) {
                    this.subject = new SubjectImpl(this.consumer);
                    this.subject.unMarshal(ele);
                } else if (ele != null && "Attribute".equals(ele.getLocalName())) {
                    AttributeImpl att = new AttributeImpl();
                    att.unMarshal(ele);
                    this.attribute.add(att);
                }
                ele = OMUtil.getNextElement(ele);
            }
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        log.exit("unMarshal(OMElement)");
    }

    @Override
    public void create() throws SoapSecurityException {
        log.entry("create()");
        AuthenticationStatementImpl authn = (AuthenticationStatementImpl)this.context.get("AuthenticationStatementImpl");
        if (authn != null) {
            this.subject = authn.getSubject();
        } else {
            this.subject = new SubjectImpl(this.issue, this.request, this.cred);
            this.subject.create();
        }
        List<SAMLAttribute> preAtts = this.cred.getSAMLAttributes();
        this.createSAMLAttributes(preAtts);
        if (this.issue.getAttributeProvider() != null && !this.issue.getAttributeProvider().isEmpty()) {
            ArrayList<Attribute> saml11Attributes = null;
            Saml11AttributeCallback acb = new Saml11AttributeCallback(this.issue, this.request, this.cred);
            CallbackHandler handler = SamlCallbackHandlerLoader.getCallbackHandler(this.issue.getAttributeProvider());
            handler.handle(acb);
            if (acb.isSAMLAttributeTypeOnly()) {
                ArrayList<SAMLAttribute> attris = acb.getSAMLAttributes();
                this.createSAMLAttributes(attris);
            } else {
                saml11Attributes = acb.getSaml11Attribute();
                this.addAttributes(saml11Attributes);
            }
        }
        log.exit("create()");
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        log.entry("validate()");
        if (this.attribute.isEmpty() && this.subject == null) {
            return false;
        }
        for (Attribute at : this.attribute) {
            if (at.validate()) continue;
            return false;
        }
        log.exit("validate()");
        return true;
    }

    private boolean hasAuthnStatement() {
        return SamlConfigUtil.createAuthnStatement(this.cred, this.request, this.issue);
    }
}

