/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.impl;

import com.ibm.ws.wssecurity.common.Messages;
import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Attribute;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.AttributeDesignatorImpl;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

public class AttributeImpl
extends AttributeDesignatorImpl
implements Attribute {
    private static final TraceLog log = new TraceLog(AttributeImpl.class);
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private List<Object> attributeValue = new ArrayList<Object>();
    protected String name;
    protected String nameFormat;
    protected String friendlyName;
    protected OMElement attributeElement;
    protected boolean isStringType;
    private String attributeNamespace;
    private OMElement xml = null;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getNameFormat() {
        return this.nameFormat;
    }

    @Override
    public void setNameFormat(String value) {
        this.nameFormat = value;
    }

    @Override
    public String getFriendlyName() {
        return this.friendlyName;
    }

    @Override
    public void setFriendlyName(String value) {
        this.friendlyName = value;
    }

    @Override
    public boolean isStringType() {
        return this.isStringType;
    }

    @Override
    public String getAttributeNamespace() {
        return this.attributeNamespace;
    }

    @Override
    public void setAttributeNamespace(String ns) {
        this.attributeNamespace = ns;
    }

    @Override
    public List<Object> getAttributeValue() {
        return this.attributeValue;
    }

    @Override
    public void setAttributeValue(List<Object> value) {
        this.attributeValue = value;
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        log.entry("getXML()");
        if (this.xml != null) {
            return this.xml;
        }
        log.exit("getXML()");
        return this.marshal(null);
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        log.entry("marshal(OMElement)");
        if (this.name == null) {
            return null;
        }
        OMElement om = null;
        if (parent == null) {
            om = omFactory.createOMElement("Attribute", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
            om.declareNamespace(SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
        } else {
            om = parent.getOMFactory().createOMElement("Attribute", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
        }
        om.addAttribute("AttributeName", this.name, null);
        if (this.nameFormat != null) {
            if ("NameFormat".length() > 0) {
                om.addAttribute("NameFormat", this.nameFormat, null);
            }
        }
        if (this.attributeNamespace != null && this.attributeNamespace.length() > 0) {
            om.addAttribute("AttributeNamespace", this.attributeNamespace, null);
        }
        OMElement om2 = null;
        if (this.attributeValue != null && !this.attributeValue.isEmpty()) {
            for (Object obj : this.attributeValue) {
                if (obj == null) continue;
                om2 = om.getOMFactory().createOMElement("AttributeValue", SAMLCommonConstants._saml_ns, SAMLCommonConstants._saml_prefix);
                if (obj instanceof String) {
                    om2.setText((String)obj);
                } else if (obj instanceof OMElement) {
                    om2.addChild((OMElement)obj);
                } else if (obj instanceof OMStructure) {
                    OMElement om3 = ((OMStructure)obj).getNode();
                    om2.addChild(om3);
                } else {
                    throw new SoapSecurityException(Messages.getString("CWSML2014E"));
                }
                om.addChild(om2);
            }
        }
        this.xml = om;
        log.exit("marshal(OMElement)");
        return om;
    }

    @Override
    public void unMarshal(OMElement om) throws SoapSecurityException {
        log.entry("unMarshal(OMElement)");
        this.xml = om;
        QName QAttr = new QName(null, "AttributeName");
        this.name = om.getAttributeValue(QAttr);
        QAttr = new QName(null, "NameFormat");
        this.nameFormat = om.getAttributeValue(QAttr);
        QAttr = new QName(null, "AttributeNamespace");
        this.attributeNamespace = om.getAttributeValue(QAttr);
        OMElement el = OMUtil.getFirstElement(om);
        while (el != null) {
            String ln = el.getLocalName();
            if ("AttributeValue".equals(ln)) {
                if (el.getText() != null && !el.getText().trim().isEmpty()) {
                    String obj = el.getText().trim();
                    this.getAttributeValue().add(obj);
                }
                if (OMUtil.getFirstElement(el) != null) {
                    this.getAttributeValue().add(new OMStructure(OMUtil.getFirstElement(el)));
                }
            }
            el = OMUtil.getNextElement(el);
        }
        log.exit("unMarshal(OMElement)");
    }

    @Override
    public void create() throws SoapSecurityException {
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        log.entry("validate()");
        if (this.name == null || this.name.isEmpty()) {
            return false;
        }
        log.exit("validate()");
        return true;
    }
}

