/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.saml11.assertion.impl;

import com.ibm.ws.wssecurity.common.Messages;
import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.common.SAMLObjectElement;
import com.ibm.ws.wssecurity.saml.common.impl.SAMLAssertionImpl;
import com.ibm.ws.wssecurity.saml.common.util.OMUtil;
import com.ibm.ws.wssecurity.saml.common.util.UTC;
import com.ibm.ws.wssecurity.saml.common.util.UUIDGenerator;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Advice;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion;
import com.ibm.ws.wssecurity.saml.saml11.assertion.AttributeStatement;
import com.ibm.ws.wssecurity.saml.saml11.assertion.AuthenticationStatement;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Conditions;
import com.ibm.ws.wssecurity.saml.saml11.assertion.StatementAbstract;
import com.ibm.ws.wssecurity.saml.saml11.assertion.Subject;
import com.ibm.ws.wssecurity.saml.saml11.assertion.SubjectConfirmation;
import com.ibm.ws.wssecurity.saml.saml11.assertion.SubjectStatementAbstract;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.AdviceImpl;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.AttributeStatementImpl;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.AuthenticationStatementImpl;
import com.ibm.ws.wssecurity.saml.saml11.assertion.impl.ConditionsImpl;
import com.ibm.ws.wssecurity.saml.security.HoKAssertion;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import java.security.Key;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

public class AssertionImpl
extends SAMLAssertionImpl
implements Assertion {
    private static final TraceLog log = new TraceLog(AssertionImpl.class);
    private Conditions conditions = null;
    private Advice advice = null;
    private List<StatementAbstract> statementOrSubjectStatementOrAuthenticationStatement = null;
    private Date issueInstant = null;
    private String issueInstantUTC = null;
    private String issuer = null;
    private String majorVersion = null;
    private String minorVersion = null;
    private OMElement xml = null;
    private String confirmMethod;
    private ConsumerConfig assertionConsumingCfg = null;
    private Key holderOfKey = null;
    private ProviderConfig issue = null;
    private RequesterConfig request = null;
    private CredentialConfig cred = null;
    private boolean isSigned = false;
    public static final String CREATE_INSTANCE = "create_instance";
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();

    public AssertionImpl(OMElement om, ConsumerConfig keyStoreCfg) {
        this.initVersion();
        this.xml = om;
        this.assertionConsumingCfg = keyStoreCfg;
    }

    public AssertionImpl(ProviderConfig issueCfg, RequesterConfig requestData, CredentialConfig cred) {
        this.issue = issueCfg;
        this.request = requestData;
        this.cred = cred;
    }

    private void initialize(String issuer) {
        this.initialize();
        this.issuer = issuer;
    }

    private void initialize() {
        log.entry("initialize()");
        this.id = UUIDGenerator.generateUUID();
        this.issueInstant = new Date();
        this.issueInstantUTC = UTC.format(this.issueInstant);
        this.minorVersion = "1";
        this.majorVersion = "1";
        log.exit("initialize()");
    }

    private void initVersion() {
        this.assertionVersion = SAMLObjectElement._saml_ns_qname;
    }

    @Override
    public Conditions getConditions() {
        return this.conditions;
    }

    @Override
    public void setConditions(Conditions value) {
        this.conditions = value;
    }

    @Override
    public Advice getAdvice() {
        return this.advice;
    }

    @Override
    public void setAdvice(Advice value) {
        this.advice = value;
    }

    @Override
    public List<StatementAbstract> getStatementOrSubjectStatementOrAuthenticationStatement() {
        return this.statementOrSubjectStatementOrAuthenticationStatement;
    }

    @Override
    public void setStatementOrSubjectStatementOrAuthenticationStatement(List<StatementAbstract> stateList) {
        this.statementOrSubjectStatementOrAuthenticationStatement = stateList;
    }

    @Override
    public void addStatementOrSubjectStatementOrAuthenticationStatement(StatementAbstract statement) {
        log.entry("addStatementOrSubjectStatementOrAuthenticationStatement(StatementAbstract)");
        if (this.statementOrSubjectStatementOrAuthenticationStatement == null) {
            this.statementOrSubjectStatementOrAuthenticationStatement = new ArrayList<StatementAbstract>();
        }
        this.statementOrSubjectStatementOrAuthenticationStatement.add(statement);
        log.exit("addStatementOrSubjectStatementOrAuthenticationStatement(StatementAbstract)");
    }

    @Override
    public String getAssertionID() {
        return this.id;
    }

    @Override
    public void setAssertionID(String value) {
        this.id = value;
    }

    @Override
    public Date getIssueInstant() {
        return this.issueInstant;
    }

    @Override
    public void setIssueInstant(Date value) {
        this.issueInstant = value;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public void setIssuer(String value) {
        this.issuer = value;
    }

    @Override
    public String getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public void setMajorVersion(String value) {
        this.majorVersion = value;
    }

    @Override
    public String getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public void setMinorVersion(String value) {
        this.minorVersion = value;
    }

    @Override
    public StatementAbstract[] getAllStatements() {
        log.entry("getAllStatements()");
        StatementAbstract[] stms = null;
        if (this.statementOrSubjectStatementOrAuthenticationStatement != null) {
            stms = new StatementAbstract[this.statementOrSubjectStatementOrAuthenticationStatement.size()];
            this.statementOrSubjectStatementOrAuthenticationStatement.toArray(stms);
        }
        log.exit("getAllStatements()");
        return stms;
    }

    @Override
    public Date getSamlExpirationTime() {
        return this.conditions.getNotOnOrAfter();
    }

    @Override
    public String getConfirmationMethod() {
        StatementAbstract[] st;
        log.entry("getConfirmationMethod()");
        if (this.confirmMethod == null && (st = this.getAllStatements()) != null) {
            for (int i = 0; i < st.length; ++i) {
                SubjectConfirmation scf;
                Subject sub;
                if (st[i] instanceof AttributeStatement && (sub = ((AttributeStatement)st[i]).getSubject()) != null && (scf = sub.getSubjectConfirmation()) != null) {
                    this.confirmMethod = scf.getConfirmationMethod().get(0);
                }
                if (st[i] instanceof AuthenticationStatement && (sub = ((AuthenticationStatement)st[i]).getSubject()) != null && (scf = sub.getSubjectConfirmation()) != null) {
                    this.confirmMethod = scf.getConfirmationMethod().get(0);
                }
                if (this.confirmMethod != null) break;
            }
        }
        log.exit("getConfirmationMethod()");
        return this.confirmMethod;
    }

    @Override
    public Key getHolderOfKey() {
        log.entry("getHolderOfKey()");
        if (this.holderOfKey != null) {
            return this.holderOfKey;
        }
        Iterator<StatementAbstract> it = this.statementOrSubjectStatementOrAuthenticationStatement.iterator();
        if (it != null) {
            while (it.hasNext()) {
                HoKAssertion hok;
                SubjectConfirmation sc;
                SubjectStatementAbstract as;
                Subject sj;
                StatementAbstract obj = it.next();
                if (!(obj instanceof SubjectStatementAbstract) || (sj = (as = (SubjectStatementAbstract)obj).getSubject()) == null || (sc = sj.getSubjectConfirmation()) == null || (hok = sc.getKeyInfoAssertion()) == null) continue;
                this.holderOfKey = hok.getKey();
                break;
            }
        }
        log.exit("getHolderOfKey()");
        return this.holderOfKey;
    }

    public void setHolderOfKey(Key k) {
        this.holderOfKey = k;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public void setSigned() {
        this.isSigned = true;
    }

    @Override
    public void create() throws SoapSecurityException {
        String issuer;
        log.entry("create()");
        boolean created = false;
        if (this.issue != null && (issuer = this.issue.getIssuerURI()) != null && !issuer.isEmpty()) {
            this.initVersion();
            this.initialize(issuer);
            created = true;
        }
        if (!created) {
            throw new SoapSecurityException(Messages.getString("CWSML2012E"));
        }
        log.exit("create()");
    }

    @Override
    public boolean validate() throws SoapSecurityException {
        log.entry("validate()");
        if (!"1".equals(this.majorVersion)) {
            return false;
        }
        if (!"1".equals(this.minorVersion)) {
            return false;
        }
        if (this.issueInstant.before(new Date())) {
            long time;
            long clockskew = 180000L;
            if (this.assertionConsumingCfg != null) {
                clockskew = this.assertionConsumingCfg.getClockSkew();
            }
            if ((time = clockskew + new Date().getTime()) < this.issueInstant.getTime()) {
                return false;
            }
        }
        if (this.id == null || this.id.isEmpty()) {
            return false;
        }
        if (this.issuer == null || this.issuer.isEmpty()) {
            return false;
        }
        if (this.conditions != null && !this.conditions.validate()) {
            return false;
        }
        if (this.advice != null && this.advice.validate()) {
            return false;
        }
        StatementAbstract[] allStms = this.getAllStatements();
        if (allStms != null) {
            int length = allStms.length;
            for (int i = 0; i < length; ++i) {
                if (allStms[i].validate()) continue;
                return false;
            }
        }
        log.exit("validate()");
        return true;
    }

    @Override
    public OMElement getXML() throws SoapSecurityException {
        log.entry("getXML()");
        if (this.isSigned || this.xml != null) {
            return this.xml;
        }
        log.exit("getXML()");
        return this.marshal(null);
    }

    public void setXML(OMElement om) throws SoapSecurityException {
        log.entry("setXML(OMElement)");
        if (this.isSigned) {
            throw new SoapSecurityException(Messages.getString("CWSML2013E"));
        }
        this.xml = om;
        log.exit("setXML(OMElement)");
    }

    @Override
    public OMElement marshal(OMElement parent) throws SoapSecurityException {
        log.entry("marshal(OMElement)");
        if (this.isSigned) {
            return this.xml;
        }
        OMElement as = null;
        try {
            StatementAbstract[] allStms;
            if (parent == null) {
                as = omFactory.createOMElement("Assertion", _saml_ns, _saml_prefix);
                OMNamespace omns = as.declareNamespace(_saml_ns, _saml_prefix);
            } else {
                as = parent.getOMFactory().createOMElement("Assertion", _saml_ns, _saml_prefix);
            }
            as.addAttribute("MajorVersion", "1", null);
            as.addAttribute("MinorVersion", "1", null);
            as.addAttribute("AssertionID", this.id, null);
            as.addAttribute("Issuer", this.issuer, null);
            as.addAttribute("IssueInstant", UTC.format(this.issueInstant), null);
            if (this.conditions != null) {
                OMElement cond = this.conditions.marshal(as);
                as.addChild(cond);
            }
            if (this.advice != null) {
                OMElement adv = this.advice.marshal(as);
                as.addChild(adv);
            }
            if ((allStms = this.getAllStatements()) != null) {
                int length = allStms.length;
                for (int i = 0; i < length; ++i) {
                    as.addChild(allStms[i].marshal(as));
                }
            }
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage(), e.getCause());
        }
        this.xml = as;
        log.exit("marshal(OMElement)");
        return as;
    }

    @Override
    public void unMarshal(OMElement aOM) throws SoapSecurityException {
        log.entry("unMarshal(OMElement)");
        this.xml = aOM;
        String MajorVersion = null;
        String MinorVersion = null;
        QName QAttr = new QName(null, "MajorVersion");
        this.majorVersion = MajorVersion = aOM.getAttributeValue(QAttr);
        QAttr = new QName(null, "MinorVersion");
        this.minorVersion = MinorVersion = aOM.getAttributeValue(QAttr);
        QAttr = new QName(null, "Issuer");
        this.issuer = aOM.getAttributeValue(QAttr);
        QAttr = new QName(null, "AssertionID");
        this.id = aOM.getAttributeValue(QAttr);
        QAttr = new QName(null, "IssueInstant");
        this.issueInstantUTC = aOM.getAttributeValue(QAttr);
        try {
            this.issueInstant = UTC.parse(this.issueInstantUTC);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            OMElement el = OMUtil.getFirstElement(aOM);
            while (el != null) {
                String ns;
                String ln = el.getLocalName();
                String string = ns = el.getNamespace() == null ? null : el.getNamespace().getNamespaceURI();
                if ("Conditions".equals(ln)) {
                    this.conditions = new ConditionsImpl();
                    this.conditions.unMarshal(el);
                } else if ("Advice".equals(ln)) {
                    this.advice = new AdviceImpl();
                    this.advice.unMarshal(el);
                } else if ("AttributeStatement".equals(ln)) {
                    AttributeStatementImpl attrStatement = new AttributeStatementImpl(this.assertionConsumingCfg);
                    attrStatement.unMarshal(el);
                    this.addStatementOrSubjectStatementOrAuthenticationStatement(attrStatement);
                } else if ("AuthenticationStatement".equals(ln)) {
                    AuthenticationStatementImpl authStatement = new AuthenticationStatementImpl(this.assertionConsumingCfg);
                    authStatement.unMarshal(el);
                    this.addStatementOrSubjectStatementOrAuthenticationStatement(authStatement);
                }
                el = OMUtil.getNextElement(el);
            }
        }
        catch (Exception ex) {
            throw new SoapSecurityException(ex.getMessage(), ex.getCause());
        }
        log.exit("unMarshal(OMElement)");
    }
}

