/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.config.impl;

import com.ibm.ws.wssecurity.saml.common.SAML11Constants;
import com.ibm.ws.wssecurity.saml.common.util.MessageHelper;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;

public class SamlConfigUtil {
    private static final TraceComponent tc = Tr.register(SamlConfigUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SamlConfigUtil.class.getName();

    public static boolean isHolderOfKey(RequesterConfig requesterData) {
        String method;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isHolderOfKey(RequesterConfig requesterData)");
        }
        boolean isHoK = false;
        if (requesterData != null && (method = requesterData.getConfirmationMethod()) != null && method.contains("holder-of-key")) {
            isHoK = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, new Boolean(isHoK).toString());
        }
        return isHoK;
    }

    public static KeyStoreManager.KeyInformation getSamlSigningKeyInformation(ProviderConfig samlCfg) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSamlSigningKeyInformation(ProviderConfig samlCfg)");
        }
        String storePath = samlCfg.getKeyStoreConfig().getPath();
        String storeType = samlCfg.getKeyStoreConfig().getType();
        char[] storePassword = samlCfg.getKeyStoreConfig().getPassword().toCharArray();
        String keyStoreRef = samlCfg.getKeyStoreConfig().getKsRef();
        String alias = samlCfg.getKeyInformationConfig().getAlias();
        char[] keyPassword = samlCfg.getKeyInformationConfig().getKeyPass().toCharArray();
        String keyName = samlCfg.getKeyInformationConfig().getName();
        KeyStoreManager ksManager = KeyStoreManager.getInstance();
        KeyStoreManager.KeyInformation keyInformation = null;
        try {
            keyInformation = ksManager.getKeyInformation(storePath, storeType, storePassword, keyStoreRef, alias, keyPassword, keyName);
        }
        catch (Exception e) {
            String msg = MessageHelper.getMessage("security.wssecurity.WSSML0001E");
            throw new SoapSecurityException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSamlSigningKeyInformation(ProviderConfig samlCfg)");
        }
        return keyInformation;
    }

    public static boolean createAuthnStatement(CredentialConfig cred, RequesterConfig request, ProviderConfig issue) {
        String type;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthnStatement(CredentialConfig cred, RequesterConfig request, ProviderConfig issue");
        }
        if ("Authn".equals(type = SamlConfigUtil.getStatementType(cred, request, issue)) || "Authn_Attribute".equals(type)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, new Boolean(true).toString());
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, new Boolean(false).toString());
        }
        return false;
    }

    public static boolean createAttributeStatement(CredentialConfig cred, RequesterConfig request, ProviderConfig issue) {
        String type;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAttributeStatement(CredentialConfig  cred, RequesterConfig request, ProviderConfig issue)");
        }
        if ("Attribute".equals(type = SamlConfigUtil.getStatementType(cred, request, issue)) || "Authn_Attribute".equals(type)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, new Boolean(true).toString());
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, new Boolean(false).toString());
        }
        return false;
    }

    public static String getStatementType(CredentialConfig cred, RequesterConfig request, ProviderConfig issue) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatementType(CredentialConfig cred, RequesterConfig request, ProviderConfig issue)");
        }
        if (request.getStatementType() != null && !request.getStatementType().isEmpty()) {
            return request.getStatementType();
        }
        String type = "Attribute";
        if (request.getAuthenticationMethod() != null && !request.getAuthenticationMethod().isEmpty() || cred != null && cred.getProperties() != null && cred.getProperties().get("AuthenticationMethod") != null) {
            type = "Authn";
            if (cred.getSAMLAttributes() != null && !cred.getSAMLAttributes().isEmpty() || issue.getAttributeProvider() != null && !issue.getAttributeProvider().isEmpty()) {
                type = "Authn_Attribute";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, type);
        }
        return type;
    }

    public static String getConfirmationMethod(RequesterConfig request, ProviderConfig issue) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfirmationMethod(RequesterConfig request, ProviderConfig issue)");
        }
        String confirm_method = null;
        if (request.getConfirmationMethod() != null) {
            confirm_method = request.getConfirmationMethod();
        }
        String keyTyep = request.getRSTTProperties().get("wstrustClientKeyType");
        String tokenTyep = request.getRSTTProperties().get("wstrustClientTokenType");
        if (keyTyep != null && !keyTyep.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer")) {
            if (tokenTyep != null && tokenTyep.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1")) {
                confirm_method = SAML11Constants._HOLDER_OF_KEY;
            } else if (tokenTyep != null && tokenTyep.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0")) {
                confirm_method = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
            }
        } else if (tokenTyep != null && tokenTyep.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1")) {
            confirm_method = SAML11Constants._BEARER;
        } else if (tokenTyep != null && tokenTyep.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0")) {
            confirm_method = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
        }
        confirm_method = SamlConfigUtil.normalizeMethod(confirm_method);
        if (!SamlConfigUtil.isConfirmationMethod(confirm_method)) {
            throw new SoapSecurityException("Confirmation Method is not valid");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, confirm_method);
        }
        return confirm_method;
    }

    public static boolean isConfirmationMethod(String method) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        boolean isValid = false;
        if (method != null && !method.isEmpty() && (method.equals(SAML11Constants._BEARER) || method.equals("urn:oasis:names:tc:SAML:2.0:cm:bearer") || method.equals(SAML11Constants._HOLDER_OF_KEY) || method.equals("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key") || method.equals(SAML11Constants._SENDER_VOUCHES) || method.equals("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches"))) {
            isValid = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, new Boolean(isValid).toString());
        }
        return isValid;
    }

    public static String normalizeMethod(String inMethod) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, inMethod);
        }
        String outMethod = inMethod;
        if (inMethod != null) {
            if (inMethod.equalsIgnoreCase("sender-vouches") || inMethod.equalsIgnoreCase("sendervouches") || inMethod.equalsIgnoreCase("sender vouches") || inMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches")) {
                outMethod = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches".intern();
            } else if (inMethod.equalsIgnoreCase("holder-of-key") || inMethod.equalsIgnoreCase("holderofkey") || inMethod.equalsIgnoreCase("holder of keys") || inMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key")) {
                outMethod = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".intern();
            } else if (inMethod.equalsIgnoreCase("bearer") || inMethod.equalsIgnoreCase("bearer") || inMethod.equalsIgnoreCase("bearer") || inMethod.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:cm:bearer")) {
                outMethod = "urn:oasis:names:tc:SAML:2.0:cm:bearer".intern();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, outMethod);
        }
        return outMethod;
    }
}

