/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.config.impl;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.token.config.WSSConstants;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import com.ibm.wsspi.wssecurity.saml.data.SAMLAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RequesterConfigImpl
implements RequesterConfig {
    private static final TraceComponent tc = Tr.register(RequesterConfigImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = RequesterConfigImpl.class.getName();
    public static final String default_ConfirmationMethod = "holder-of-key";
    public static final String default_SignKeyInfoType = "X509Certificate";
    public static final String default_EncryptionKeyInfoType = "X509Certificate";
    public static final String default_HolderOfKeyKeyInfoType = "KeyValue";
    public static final String canonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String computedKeyAlgorithm = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/CK/PSHA1";
    public static final String encryptWith = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String encryptionAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String keySize = "128";
    public static final String keyType = "http://docs.oasis-open.org/ws-sx/wstrust/200512/Bearer";
    public static final String signWith = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String tokenType = WSSConstants.SAML.SAML11_VALUE_TYPE;
    private String confirmationMethod;
    private String authenticationMethod;
    private String requesterAlias;
    private String statemenType = null;
    private String signKeyInfoType = null;
    private String encKeyInfoType = null;
    private String holderOfKeyKeyInfoType = null;
    private String appliesToAlias = null;
    private String requesterIP = null;
    private String requesterDns = null;
    private boolean isSessionIndexEnabled = false;
    private boolean signAssertion = true;
    private boolean oneTimeUse = false;
    private Map<String, String> rstMap = new HashMap<String, String>();
    private ArrayList<SAMLAttribute> samlAttributes = new ArrayList();
    private Map<String, String> stringAttributes = new HashMap<String, String>();

    public RequesterConfigImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "entered default constructor");
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exiting default constructor");
        }
    }

    private void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        this.rstMap.put("wstrustClientAppliesToAddress", null);
        this.rstMap.put("wstrustClientCanonicalizationAlgorithm", canonicalizationAlgorithm);
        this.rstMap.put("wstrustClientComputedKeyAlgorithm", computedKeyAlgorithm);
        this.rstMap.put("wstrustClientEncryptionAlgorithm", "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.rstMap.put("wstrustClientEncryptWith", "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.rstMap.put("wstrustClientKeySize", keySize);
        this.rstMap.put("wstrustClientSignWith", signWith);
        this.signKeyInfoType = "X509Certificate";
        this.encKeyInfoType = "X509Certificate";
        this.holderOfKeyKeyInfoType = default_HolderOfKeyKeyInfoType;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    @Override
    public String getAuthenticationMethod() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthenticationMethod() to return: " + this.authenticationMethod);
        }
        return this.authenticationMethod;
    }

    @Override
    public String getConfirmationMethod() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfirmationMethod() to return: " + this.confirmationMethod);
        }
        return this.confirmationMethod;
    }

    @Override
    public String getEncryptionKeyInfoType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEncryptionKeyInfoType() to return: " + this.encKeyInfoType);
        }
        return this.encKeyInfoType;
    }

    @Override
    public String getHolderOfKeyKeyInfoType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHolderOfKeyKeyInfoType() to return: " + this.holderOfKeyKeyInfoType);
        }
        return this.holderOfKeyKeyInfoType;
    }

    @Override
    public String getKeyAliasForAppliesTo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyAliasForAppliesTo() to return: " + this.appliesToAlias);
        }
        return this.appliesToAlias;
    }

    @Override
    public String getKeyAliasForRequester() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyAliasForRequester() to return: " + this.requesterAlias);
        }
        return this.requesterAlias;
    }

    @Override
    public Map<String, String> getRSTTProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRSTTProperties() to return: " + this.rstMap);
        }
        return this.rstMap;
    }

    @Override
    public String getRequesterDNSAddress() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequesterDNSAddress() to return: " + this.requesterDns);
        }
        return this.requesterDns;
    }

    @Override
    public String getRequesterIPAddress() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequesterIPAddress() to return: " + this.requesterIP);
        }
        return this.requesterIP;
    }

    @Override
    public boolean isSessionIndexEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSessionIndexEnabled() to return: " + this.isSessionIndexEnabled);
        }
        return this.isSessionIndexEnabled;
    }

    @Override
    public String getSignatureKeyInfoType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignatureKeyInfoType() to return: " + this.signKeyInfoType);
        }
        return this.signKeyInfoType;
    }

    @Override
    public String getStatementType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatementType() to return: " + this.statemenType);
        }
        return this.statemenType;
    }

    @Override
    public boolean isAssertionSignatureRequired() {
        return this.signAssertion;
    }

    @Override
    public boolean isOneTimeUse() {
        return this.oneTimeUse;
    }

    @Override
    public void validate() throws SoapSecurityException {
    }

    @Override
    public void setAuthenticationMethod(String method) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        this.authenticationMethod = method;
    }

    @Override
    public void setConfirmationMethod(String method) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, method);
        }
        this.confirmationMethod = method;
    }

    @Override
    public void setEncryptionKeyInfoType(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, type);
        }
        this.encKeyInfoType = type;
    }

    @Override
    public void setHolderOfKeyKeyInfoType(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, type);
        }
        this.holderOfKeyKeyInfoType = type;
    }

    @Override
    public void setKeyAliasForAppliesTo(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, type);
        }
        this.appliesToAlias = type;
    }

    @Override
    public void setKeyAliasForRequester(String alias) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, alias);
        }
        this.requesterAlias = alias;
    }

    @Override
    public void setRSTTProperties(Map<String, String> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRSTTProperties(Map<String, String> map)", map);
        }
        this.rstMap = map;
    }

    @Override
    public void setRequesterDNSAddress(String dns) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, dns);
        }
        this.requesterDns = dns;
    }

    @Override
    public void setRequesterIPAddress(String ip) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, ip);
        }
        this.requesterIP = ip;
    }

    @Override
    public void setSignatureKeyInfoType(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, type);
        }
        this.signKeyInfoType = type;
    }

    @Override
    public void setStatementType(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, type);
        }
        this.statemenType = type;
    }

    @Override
    public void setAssertionSignatureRequired(boolean option) {
        this.signAssertion = option;
    }

    @Override
    public void setOneTimeUse(boolean option) {
        this.oneTimeUse = option;
    }
}

