/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.config.impl;

import com.ibm.ws.wssecurity.saml.config.impl.KeyInformationConfigImpl;
import com.ibm.ws.wssecurity.saml.config.impl.KeyStoreConfigImpl;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.KeyInformationConfig;
import com.ibm.wsspi.wssecurity.core.config.KeyStoreConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;

public class ProviderConfigImpl
implements ProviderConfig {
    private static final TraceComponent tc = Tr.register(ProviderConfigImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = ProviderConfigImpl.class.getName();
    private String issuerURI;
    private long timeToLive;
    private String attributeProvider;
    private String nameIDProvider;
    private String modifier;
    private KeyInformationConfig kic = null;
    private KeyStoreConfig ksc = null;
    private KeyStoreConfig tsc = null;
    public int hashcode = 0;

    public ProviderConfigImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "entered default constructor");
        }
        this.kic = new KeyInformationConfigImpl();
        this.ksc = new KeyStoreConfigImpl();
        this.tsc = new KeyStoreConfigImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exited default constructor");
        }
    }

    @Override
    public KeyInformationConfig getKeyInformationConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInformationConfig()");
        }
        return this.kic;
    }

    @Override
    public KeyStoreConfig getKeyStoreConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreConfig()");
        }
        return this.ksc;
    }

    @Override
    public KeyStoreConfig getTrustStoreConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStoreConfig()");
        }
        return this.tsc;
    }

    @Override
    public void validate() throws SoapSecurityException {
    }

    @Override
    public String getIssuerURI() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIssuerURI() to return: " + this.issuerURI);
        }
        return this.issuerURI;
    }

    @Override
    public long getTimeToLive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimeToLive to return: " + this.timeToLive);
        }
        return this.timeToLive;
    }

    @Override
    public String getAttributeProvider() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeProvider to return: " + this.attributeProvider);
        }
        return this.attributeProvider;
    }

    @Override
    public String getNameIDProvider() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNameIDProvider to return: " + this.nameIDProvider);
        }
        return this.nameIDProvider;
    }

    @Override
    public String getSamlModifier() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSamlModifier to return: " + this.modifier);
        }
        return this.modifier;
    }

    @Override
    public void setIssuerURI(String uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, uri);
        }
        this.issuerURI = uri;
    }

    @Override
    public void setTimeToLive(long ttl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, new Long(ttl).toString());
        }
        this.timeToLive = ttl;
    }

    @Override
    public void setAttributeProvider(String provider) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, this.attributeProvider);
        }
        this.attributeProvider = provider;
    }

    @Override
    public void setNameIDProvider(String provider) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, this.nameIDProvider);
        }
        this.nameIDProvider = provider;
    }

    @Override
    public void setSamlModifier(String mod) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, this.modifier);
        }
        this.modifier = mod;
    }

    @Override
    public void setKeyInformationConfig(KeyInformationConfig kic) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyInformationConfig(KeyInformationConfig kic)");
        }
        this.kic = kic;
    }

    @Override
    public void setKeyStoreConfig(KeyStoreConfig ksc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyStoreConfig(KeyStoreConfig ksc)");
        }
        this.ksc = ksc;
    }

    @Override
    public void setTrustStoreConfig(KeyStoreConfig tsc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTrustStoreConfig(KeyStoreConfig tsc)");
        }
        this.tsc = tsc;
    }

    public int hashCode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hashCode()");
        }
        if (this.hashcode == 0) {
            StringBuffer buf = new StringBuffer(this.getClass().getName()).append("(");
            if (this.issuerURI != null) {
                buf.append(this.issuerURI);
            }
            if (this.kic != null) {
                buf.append(this.kic.toString());
            }
            if (this.ksc != null) {
                buf.append(this.ksc);
            }
            if (this.tsc != null) {
                buf.append(this.tsc.toString());
            }
            this.hashcode = buf.toString().hashCode();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, new Integer(this.hashcode).toString());
        }
        return this.hashcode;
    }
}

