/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.common.util;

import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

public class OMUtil {
    public static OMElement getFirstElement(OMNode parent) {
        OMNode child = OMUtil.getFirstChild2(parent);
        while (child != null && child.getType() != 1) {
            child = OMUtil.getNextSibling2(child);
        }
        OMElement ret = (OMElement)child;
        return ret;
    }

    public static OMElement getFirstElement(OMNode parent, String ns, String name) {
        OMNode child = OMUtil.getFirstChild2(parent);
        while (child != null) {
            if (child.getType() == 1) {
                String elns;
                OMElement el = (OMElement)child;
                String string = elns = el.getNamespace() == null ? null : el.getNamespace().getName();
                if ((name.equals("*") || el.getLocalName().equals(name)) && (ns == null && elns == null || ns != null && ns.equals("*") || ns != null && ns.equals(elns))) break;
            }
            child = OMUtil.getNextSibling2(child);
        }
        OMElement ret = (OMElement)child;
        return ret;
    }

    public static OMElement getNextElement(OMNode node) {
        OMNode next = node;
        while ((next = OMUtil.getNextSibling2(next)) != null) {
            if (next == node) {
                next = null;
                break;
            }
            if (next.getType() != 1) continue;
        }
        OMElement ret = (OMElement)next;
        return ret;
    }

    public static OMNode getNextSibling2(OMNode node) {
        OMContainer parent;
        OMNode ret = node.getNextOMSibling();
        if (ret == null && ((parent = node.getParent()) == null || parent instanceof OMDocument)) {
            return null;
        }
        return ret;
    }

    public static OMNode getLastChild2(OMNode node) {
        OMNode ret = null;
        if (node.getType() == 1) {
            OMElement elem = (OMElement)node;
            Iterator i = elem.getChildren();
            while (i.hasNext()) {
                ret = (OMNode)i.next();
            }
        }
        return ret;
    }

    public static OMNode getFirstChild2(OMNode node) {
        OMNode ret = null;
        if (node.getType() == 1) {
            ret = ((OMElement)node).getFirstOMChild();
        }
        return ret;
    }

    public static String getStringValue(OMNode node) {
        String ret = null;
        switch (node.getType()) {
            case 1: 
            case 9: {
                OMNode child = ((OMElement)node).getFirstOMChild();
                if (child == null) {
                    ret = "";
                    break;
                }
                if (child == OMUtil.getLastChild2(node) && (child.getType() == 4 || child.getType() == 12)) {
                    ret = ((OMText)child).getText();
                    break;
                }
                StringBuffer buf = new StringBuffer();
                OMUtil.getStringValue0(node, buf);
                ret = new String(buf);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                ret = ((OMText)node).getText();
                break;
            }
            default: {
                throw new RuntimeException("Internal Error: Unexpected node type: " + node.getType());
            }
        }
        return ret;
    }

    private static void getStringValue0(OMNode n, StringBuffer buf) {
        switch (n.getType()) {
            case 1: 
            case 9: {
                for (OMNode ch = ((OMElement)n).getFirstOMChild(); ch != null; ch = ch.getNextOMSibling()) {
                    OMUtil.getStringValue0(ch, buf);
                }
                break;
            }
            case 4: 
            case 12: {
                buf.append(((OMText)n).getTextCharacters());
                break;
            }
        }
    }

    private static String setQName0(OMElement elem, QName qName, int wssVersion) {
        String nsURI = qName.getNamespaceURI();
        String localPart = qName.getLocalPart();
        if (nsURI == null || nsURI.length() == 0 && wssVersion == 0) {
            return localPart;
        }
        OMContainer n = elem;
        String prefix = null;
        HashSet<String> usedPrefixes = new HashSet<String>();
        while (n instanceof OMElement) {
            Iterator map = n.getAllDeclaredNamespaces();
            while (map.hasNext()) {
                OMNamespace ns = (OMNamespace)map.next();
                String tmpPrefix = ns.getPrefix();
                String value = ns.getNamespaceURI();
                if (!value.equals(nsURI) || prefix != null || usedPrefixes.contains(tmpPrefix)) continue;
                prefix = tmpPrefix;
                usedPrefixes.add(tmpPrefix);
            }
            n = n.getParent();
        }
        if (prefix == null) {
            while (usedPrefixes.contains(prefix = "ns" + OMUtil.makeRandomStr())) {
            }
            elem.declareNamespace(nsURI, prefix);
        }
        return prefix.equals("") ? localPart : prefix + ":" + localPart;
    }

    public static void setQNameAttr(OMElement element, String attrNameNS, String attrName, QName attrValue, int wssVersion) {
        String attrLocal;
        String attrPrefix;
        String strQName = OMUtil.setQName0(element, attrValue, wssVersion);
        int index = attrName.indexOf(":");
        if (index == -1) {
            attrPrefix = "";
            attrLocal = attrName;
        } else {
            attrPrefix = attrName.substring(0, index);
            attrLocal = attrName.substring(index + 1);
        }
        if (attrNameNS == null) {
            element.addAttribute(attrLocal, strQName, null);
        } else {
            element.addAttribute(attrLocal, strQName, element.getOMFactory().createOMNamespace(attrNameNS, attrPrefix));
        }
    }

    public static void setQNameAttr(OMElement element, String attrNameNS, String attrName, QName attrValue) {
        String strQName = OMUtil.setQName0(element, attrValue, -1);
        if (attrNameNS == null) {
            element.addAttribute(attrName, strQName, null);
        } else {
            element.addAttribute(attrName, strQName, element.getOMFactory().createOMNamespace(attrNameNS, ""));
        }
    }

    protected static String makeRandomStr() {
        return String.valueOf(Math.abs(new Random().nextLong()));
    }

    public static OMDocument createDocument() throws SoapSecurityException {
        OMDocument doc = null;
        try {
            doc = OMAbstractFactory.getOMFactory().createOMDocument();
        }
        catch (Exception e) {
            throw new SoapSecurityException(e.getMessage());
        }
        return doc;
    }
}

