/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.assertion.wsspi.callback;

import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.CallbackHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class SamlCallbackHandlerLoader {
    private static final TraceLog log = new TraceLog(SamlCallbackHandlerLoader.class);
    private static final PrivilegedAction getCtxClassLoader = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public static CallbackHandler getCallbackHandler(String className) {
        log.entry("getCallbackHandler(String): " + className);
        CallbackHandler handler = null;
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
        try {
            handler = cl != null ? (CallbackHandler)cl.loadClass(className).newInstance() : (CallbackHandler)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        log.exit("getCallbackHandler(String)");
        return handler;
    }
}

