/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.assertion.wsspi.callback;

import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.assertion.wsspi.callback.Callback;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Attribute;
import com.ibm.wsspi.wssecurity.saml.config.CredentialConfig;
import com.ibm.wsspi.wssecurity.saml.config.ProviderConfig;
import com.ibm.wsspi.wssecurity.saml.config.RequesterConfig;
import com.ibm.wsspi.wssecurity.saml.data.SAMLAttribute;
import java.util.ArrayList;

public class Saml20AttributeCallback
implements Callback {
    private static final TraceLog log = new TraceLog(Saml20AttributeCallback.class);
    private ArrayList<Attribute> saml20Attributes = null;
    private ArrayList<SAMLAttribute> stringOrElementAttributes = new ArrayList();
    private boolean simpleTypeOnly = false;
    private ProviderConfig issuerCfg = null;
    private RequesterConfig rstCfg = null;
    private CredentialConfig cred = null;

    public Saml20AttributeCallback(ProviderConfig conf, RequesterConfig requester, CredentialConfig cred) {
        this.issuerCfg = conf;
        this.rstCfg = requester;
        this.cred = cred;
    }

    public ProviderConfig getProviderConfig() {
        return this.issuerCfg;
    }

    public RequesterConfig getRequesterConfig() {
        return this.rstCfg;
    }

    public ArrayList<Attribute> getSaml20Attribute() {
        log.entry("getSaml20Attribute()");
        if (this.saml20Attributes == null) {
            this.saml20Attributes = new ArrayList();
        }
        log.exit("getSaml20Attribute()");
        return this.saml20Attributes;
    }

    public void addSaml20Attribute(Attribute att) {
        this.getSaml20Attribute().add(att);
    }

    public ArrayList<SAMLAttribute> getSAMLAttributes() {
        return this.stringOrElementAttributes;
    }

    public void setSAMLAttributes(ArrayList<SAMLAttribute> atts) {
        this.stringOrElementAttributes = atts;
    }

    public boolean isSAMLAttributeTypeOnly() {
        return this.simpleTypeOnly;
    }

    public void setSAMLAttributeTypeOnly() {
        this.simpleTypeOnly = true;
    }
}

