/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.assertion.wssapi;

import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.common.SAMLAssertion;
import com.ibm.ws.wssecurity.saml.saml11.assertion.utils.SAMLVerifier;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Assertion;
import com.ibm.ws.wssecurity.saml.security.impl.SAMLSignatureVerification;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import java.security.KeyStore;
import org.apache.axiom.om.OMElement;

public class SAMLAssertionVerifier {
    private static final TraceLog log = new TraceLog(SAMLAssertionVerifier.class);

    public static boolean verifySAMLCondition(SAMLAssertion saml) {
        log.entry("verifySAMLCondition(SAMLAssertion)");
        boolean verified = false;
        if (SAMLAssertion._saml_ns_qname.equals(saml.getAssertionQName())) {
            com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion assertion = (com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion)saml;
            verified = SAMLVerifier.verifySAMLCondition(assertion);
        } else if (SAMLAssertion._saml2_ns_qname.equals(saml.getAssertionQName())) {
            Assertion assertion = (Assertion)saml;
            verified = com.ibm.ws.wssecurity.saml.saml20.assertion.utils.SAMLVerifier.verifySAMLCondition(assertion);
        }
        log.exit("verifySAMLCondition(SAMLAssertion): " + new Boolean(verified).toString());
        return verified;
    }

    public static boolean verifySAMLAssertion(SAMLAssertion saml) throws Exception {
        log.entry("verifySAMLAssertion(SAMLAssertion)");
        boolean verified = false;
        if (SAMLAssertion._saml_ns_qname.equals(saml.getAssertionQName())) {
            com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion assertion = (com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion)saml;
            verified = SAMLVerifier.verifySAMLAssertion(assertion);
        } else if (SAMLAssertion._saml2_ns_qname.equals(saml.getAssertionQName())) {
            Assertion assertion = (Assertion)saml;
            verified = com.ibm.ws.wssecurity.saml.saml20.assertion.utils.SAMLVerifier.verifySAMLHeader(assertion);
        }
        log.exit("verifySAMLAssertion(SAMLAssertion): " + new Boolean(verified).toString());
        return verified;
    }

    public static boolean verifySAMLSignature(OMElement om, KeyStoreManager.KeyInformation keyInformation, KeyStore trustAnchor) throws SoapSecurityException {
        log.entry("verifySAMLSignature(OMElement, KeyInformation)");
        boolean verify = SAMLSignatureVerification.verify(om, keyInformation, trustAnchor);
        log.exit("verifySAMLSignature(OMElement, KeyInformation): " + new Boolean(verify).toString());
        return verify;
    }

    public static boolean verifySAMLSignature(OMElement om, KeyStoreManager.KeyInformation keyInformation) throws SoapSecurityException {
        log.entry("verifySAMLSignature(OMElement, KeyInformation)");
        boolean verify = SAMLAssertionVerifier.verifySAMLSignature(om, keyInformation, null);
        log.exit("verifySAMLSignature(OMElement, KeyInformation): " + new Boolean(verify).toString());
        return verify;
    }

    public static boolean verifySAMLClaims(OMElement om) {
        return true;
    }

    public static KeyStoreManager.KeyInformation getKeyInformationForVerification(ConsumerConfig samlCfg) throws SoapSecurityException {
        log.entry("getKeyInformationForVerification(ConsumerConfig)");
        KeyStoreManager.KeyInformation keyInformation = null;
        KeyStoreManager ksManager = KeyStoreManager.getInstance();
        keyInformation = ksManager.getKeyInformation(samlCfg.getTrustStoreConfig().getPath(), samlCfg.getTrustStoreConfig().getType(), samlCfg.getTrustStoreConfig().getPassword().toCharArray(), samlCfg.getTrustStoreConfig().getKsRef(), samlCfg.getKeyInformationConfig().getAlias(), null, samlCfg.getKeyInformationConfig().getName());
        log.exit("getKeyInformationForVerification(ConsumerConfig)");
        return keyInformation;
    }
}

