/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.saml.assertion.wssapi;

import com.ibm.ws.wssecurity.common.Messages;
import com.ibm.ws.wssecurity.common.TraceLog;
import com.ibm.ws.wssecurity.saml.common.SAMLAssertion;
import com.ibm.ws.wssecurity.saml.common.SAMLCommonConstants;
import com.ibm.ws.wssecurity.saml.saml11.assertion.utils.SAMLParser;
import com.ibm.ws.wssecurity.saml.saml20.assertion.Assertion;
import com.ibm.ws.wssecurity.saml.security.HoKAssertion;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SAML20TokenFactoryImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.saml.config.ConsumerConfig;
import java.security.Key;
import org.apache.axiom.om.OMElement;

public class SAMLAssertionParser {
    private static final TraceLog log = new TraceLog(SAMLAssertionParser.class);
    private static final TraceComponent tc = Tr.register(SAML20TokenFactoryImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.samlmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SAML20TokenFactoryImpl.class.getName();

    public static SAMLAssertion parseSAML(OMElement aOM) throws SoapSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSAML(OMElement): " + (aOM == null ? null : ((Object)aOM).toString()));
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SAMLCommonConstants.CONSUME_SAMLTOKEN_PERM.toString());
            }
            sm.checkPermission(SAMLCommonConstants.CONSUME_SAMLTOKEN_PERM);
        }
        SAMLAssertion sa = SAMLAssertionParser.parseSAML(aOM, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSAML(OMElement)");
        }
        return sa;
    }

    public static SAMLAssertion parseSAML(OMElement aOM, ConsumerConfig decryptingKeyStoreCfg) throws SoapSecurityException {
        log.entry("parseSAML(OMElement, ConsumerConfig decryptingKeyStoreCfg)");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SAMLCommonConstants.CONSUME_SAMLTOKEN_PERM.toString());
            }
            sm.checkPermission(SAMLCommonConstants.CONSUME_SAMLTOKEN_PERM);
        }
        boolean saml11 = true;
        String samlNs = aOM.getNamespace().getNamespaceURI();
        if (SAMLCommonConstants._saml_ns.equals(samlNs)) {
            saml11 = true;
        } else if (SAMLCommonConstants._saml2_ns.equals(samlNs)) {
            saml11 = false;
        } else {
            throw new SoapSecurityException(Messages.getString("CWSML2038E") + samlNs);
        }
        SAMLAssertion saml = null;
        saml = saml11 ? SAMLParser.parseSAML(aOM, decryptingKeyStoreCfg) : com.ibm.ws.wssecurity.saml.saml20.assertion.utils.SAMLParser.parseSAML(aOM, decryptingKeyStoreCfg);
        log.exit("parseSAML(OMElement, ConsumerConfig decryptingKeyStoreCfg)");
        return saml;
    }

    public static HoKAssertion getHoKAssertion(SAMLAssertion saml, ConsumerConfig decryptingKeyStoreCfg) throws SoapSecurityException {
        log.entry("getHoKAssertion(SAMLAssertionl, ConsumerConfig)");
        HoKAssertion hok = null;
        if (saml instanceof com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion) {
            com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion as = (com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion)saml;
            hok = SAMLParser.getHoKAssertion(as, decryptingKeyStoreCfg);
        } else if (saml instanceof Assertion) {
            Assertion as = (Assertion)saml;
            hok = com.ibm.ws.wssecurity.saml.saml20.assertion.utils.SAMLParser.getHoKAssertion(as, decryptingKeyStoreCfg);
        }
        log.exit("getHoKAssertion(SAMLAssertionl, ConsumerConfig)");
        return hok;
    }

    public static Key unMarshalHoKKey(SAMLAssertion saml, ConsumerConfig decryptingKeyStoreCfg) throws SoapSecurityException {
        log.entry("unMarshalHoKKey(SAMLAssertion, ConsumerConfig)");
        Key key = null;
        if (saml instanceof com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion) {
            com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion as = (com.ibm.ws.wssecurity.saml.saml11.assertion.Assertion)saml;
            key = SAMLParser.unMarshalHoKKey(as, decryptingKeyStoreCfg);
        } else if (saml instanceof Assertion) {
            Assertion as = (Assertion)saml;
            key = com.ibm.ws.wssecurity.saml.saml20.assertion.utils.SAMLParser.unMarshalHoKKey(as, decryptingKeyStoreCfg);
        }
        log.exit("unMarshalHoKKey(SAMLAssertion, ConsumerConfig)");
        return key;
    }
}

